/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.normalize;

public final class PathNormalizer {
    public static String normalize(String path) {
        if (null == path || path.isEmpty()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < path.length()) {
            int nextSlash = path.indexOf(47, i);
            if (nextSlash != i) {
                int endOfSegment = nextSlash == -1 ? path.length() : nextSlash;
                int segmentLength = endOfSegment - i;
                if (segmentLength <= 3 && segmentLength > 1 && (path.charAt(i) | 0x20) == 118) {
                    boolean numeric = true;
                    for (int j = i + 1; j < endOfSegment; ++j) {
                        numeric &= Character.isDigit(path.charAt(j));
                    }
                    if (numeric) {
                        sb.append(path, i, endOfSegment);
                    } else {
                        sb.append('?');
                    }
                } else {
                    int snapshot = sb.length();
                    boolean numeric = false;
                    for (int j = i; j < endOfSegment && !numeric; ++j) {
                        char c = path.charAt(j);
                        numeric = Character.isDigit(c);
                        if (numeric || Character.isWhitespace(c)) continue;
                        sb.append(c);
                    }
                    if (numeric) {
                        sb.setLength(snapshot);
                        sb.append('?');
                    }
                }
                i = endOfSegment + 1;
            } else {
                ++i;
            }
            if (nextSlash == -1) continue;
            sb.append('/');
        }
        return sb.length() == 0 ? "/" : sb.toString();
    }
}

