/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.common.writer.ddagent.DroppingPolicy;
import datadog.trace.core.http.OkHttpUtils;
import datadog.trace.core.monitor.DDAgentStatsDClientManager;
import datadog.trace.core.monitor.Monitoring;
import datadog.trace.core.monitor.Recording;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentFeaturesDiscovery
implements DroppingPolicy {
    private static final Logger log = LoggerFactory.getLogger(DDAgentFeaturesDiscovery.class);
    private static final JsonAdapter<Map<String, Object>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Object.class}));
    public static final String V3_ENDPOINT = "v0.3/traces";
    public static final String V4_ENDPOINT = "v0.4/traces";
    public static final String V5_ENDPOINT = "v0.5/traces";
    public static final String V6_METRICS_ENDPOINT = "v0.6/stats";
    private static final String DATADOG_AGENT_STATE = "Datadog-Agent-State";
    private final OkHttpClient client;
    private final HttpUrl agentBaseUrl;
    private final Recording discoveryTimer;
    private final String[] traceEndpoints;
    private final String[] metricsEndpoints = new String[]{"v0.6/stats"};
    private final boolean metricsEnabled;
    private final AtomicLong discoveryCounter = new AtomicLong(0L);
    private volatile String traceEndpoint;
    private volatile String metricsEndpoint;
    private volatile boolean supportsDropping;
    private volatile String state;

    public DDAgentFeaturesDiscovery(OkHttpClient client, Monitoring monitoring, HttpUrl agentUrl, boolean enableV05Traces, boolean metricsEnabled) {
        String[] stringArray;
        this.client = client;
        this.agentBaseUrl = agentUrl;
        this.metricsEnabled = metricsEnabled;
        if (enableV05Traces) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = V5_ENDPOINT;
            stringArray2[1] = V4_ENDPOINT;
            stringArray = stringArray2;
            stringArray2[2] = V3_ENDPOINT;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = V4_ENDPOINT;
            stringArray = stringArray3;
            stringArray3[1] = V3_ENDPOINT;
        }
        this.traceEndpoints = stringArray;
        this.discoveryTimer = monitoring.newTimer("trace.agent.discovery.time");
    }

    public void discover() {
        long sequence = this.discoveryCounter.getAndIncrement();
        try (Recording recording = this.discoveryTimer.start();){
            boolean fallback = true;
            try (Response response = this.client.newCall(new Request.Builder().url(this.agentBaseUrl.resolve("info").url()).build()).execute();){
                if (response.isSuccessful()) {
                    fallback = !this.processInfoResponse(sequence == 0L, response.body().string());
                }
            }
            catch (Throwable error) {
                this.errorQueryingEndpoint("info", error);
            }
            if (fallback) {
                this.supportsDropping = false;
                log.debug("Falling back to probing, client dropping will be disabled");
                this.metricsEndpoint = null;
                if (null == this.traceEndpoint) {
                    this.traceEndpoint = this.probeTracesEndpoint();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String probeTracesEndpoint() {
        String[] stringArray = this.traceEndpoints;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            try (Response response = this.client.newCall(new Request.Builder().put(OkHttpUtils.msgpackRequestBodyOf(Collections.emptyList())).url(this.agentBaseUrl.resolve(candidate)).build()).execute();){
                if (response.code() != 404) {
                    this.state = response.header(DATADOG_AGENT_STATE);
                    String string = candidate;
                    return string;
                }
            }
            catch (IOException e) {
                this.errorQueryingEndpoint(candidate, e);
            }
            ++n2;
        }
        return V3_ENDPOINT;
    }

    private boolean processInfoResponse(boolean firstAttempt, String response) {
        try {
            boolean metricsEndpointFound;
            Map map = (Map)RESPONSE_ADAPTER.fromJson(response);
            DDAgentFeaturesDiscovery.discoverStatsDPort(map);
            List endpoints = (List)map.get("endpoints");
            ListIterator traceAgentSupportedEndpoints = endpoints.listIterator(endpoints.size());
            boolean traceEndpointFound = false;
            boolean bl = metricsEndpointFound = !this.metricsEnabled || !firstAttempt;
            block2: while (!(traceEndpointFound && metricsEndpointFound || !traceAgentSupportedEndpoints.hasPrevious())) {
                int i;
                String traceAgentSupportedEndpoint = (String)traceAgentSupportedEndpoints.previous();
                if (traceAgentSupportedEndpoint.startsWith("/") && traceAgentSupportedEndpoint.length() > 1) {
                    traceAgentSupportedEndpoint = traceAgentSupportedEndpoint.substring(1);
                }
                if (firstAttempt && !metricsEndpointFound) {
                    for (i = this.metricsEndpoints.length - 1; i >= 0; --i) {
                        if (!this.metricsEndpoints[i].equalsIgnoreCase(traceAgentSupportedEndpoint)) continue;
                        this.metricsEndpoint = traceAgentSupportedEndpoint;
                        metricsEndpointFound = true;
                        break;
                    }
                }
                if (traceEndpointFound) continue;
                for (i = this.traceEndpoints.length - 1; i >= 0; --i) {
                    if (!this.traceEndpoints[i].equalsIgnoreCase(traceAgentSupportedEndpoint)) continue;
                    this.traceEndpoint = traceAgentSupportedEndpoint;
                    traceEndpointFound = true;
                    continue block2;
                }
            }
            if (this.metricsEnabled) {
                Object canDrop = map.get("client_drop_p0s");
                this.supportsDropping = null != canDrop && ("true".equalsIgnoreCase(String.valueOf(canDrop)) || Boolean.TRUE.equals(canDrop));
            }
            return true;
        }
        catch (Throwable error) {
            log.debug("Error parsing trace agent /info response", error);
            return false;
        }
    }

    private static void discoverStatsDPort(Map<String, Object> info) {
        try {
            Map config = (Map)info.get("config");
            int statsdPort = ((Number)config.get("statsd_port")).intValue();
            DDAgentStatsDClientManager.setDefaultStatsDPort(statsdPort);
        }
        catch (Throwable ignore) {
            log.debug("statsd_port missing from trace agent /info response", ignore);
        }
    }

    public boolean supportsMetrics() {
        return this.metricsEnabled && null != this.metricsEndpoint;
    }

    boolean supportsDropping() {
        return this.supportsDropping;
    }

    public String getMetricsEndpoint() {
        return this.metricsEndpoint;
    }

    public String getTraceEndpoint() {
        return this.traceEndpoint;
    }

    private void errorQueryingEndpoint(String endpoint, Throwable t) {
        log.debug("Error querying {} at {}", new Object[]{endpoint, this.agentBaseUrl, t});
    }

    public String state() {
        return this.state;
    }

    @Override
    public boolean active() {
        return this.supportsMetrics() && this.supportsDropping;
    }
}

