/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.bootstrap.instrumentation.api.InstrumentationTags;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.common.writer.ddagent.Payload;
import datadog.trace.common.writer.ddagent.TraceMapper;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.Metadata;
import datadog.trace.core.MetadataConsumer;
import datadog.trace.core.http.OkHttpUtils;
import datadog.trace.core.serialization.GrowableBuffer;
import datadog.trace.core.serialization.Mapper;
import datadog.trace.core.serialization.Writable;
import datadog.trace.core.serialization.WritableFormatter;
import datadog.trace.core.serialization.msgpack.MsgPackWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.RequestBody;

public final class TraceMapperV0_5
implements TraceMapper {
    private final WritableFormatter dictionaryWriter;
    private final DictionaryMapper dictionaryMapper = new DictionaryMapper();
    private final Map<Object, Integer> encoding = new HashMap<Object, Integer>();
    private final GrowableBuffer dictionary;
    private final MetaWriter metaWriter = new MetaWriter();
    private final int size;

    public TraceMapperV0_5() {
        this(0x200000);
    }

    public TraceMapperV0_5(int dictionarySize, int bufferSize) {
        this.dictionary = new GrowableBuffer(bufferSize);
        this.dictionaryWriter = new MsgPackWriter(this.dictionary);
        this.size = bufferSize;
        this.reset();
    }

    public TraceMapperV0_5(int dictionarySize) {
        this(dictionarySize, 0x200000);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        writable.startArray(trace.size());
        for (CoreSpan<?> span : trace) {
            writable.startArray(12);
            this.writeDictionaryEncoded(writable, span.getServiceName());
            this.writeDictionaryEncoded(writable, span.getOperationName());
            this.writeDictionaryEncoded(writable, span.getResourceName());
            writable.writeLong(span.getTraceId().toLong());
            writable.writeLong(span.getSpanId().toLong());
            writable.writeLong(span.getParentId().toLong());
            writable.writeLong(span.getStartTime());
            writable.writeLong(span.getDurationNano());
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable));
            this.writeDictionaryEncoded(writable, span.getType());
        }
    }

    private void writeDictionaryEncoded(Writable writable, Object value) {
        Object target = null == value ? "" : value;
        Integer encoded = this.encoding.get(target);
        if (null == encoded) {
            this.dictionaryWriter.format(target, this.dictionaryMapper);
            int dictionaryCode = this.dictionary.messageCount() - 1;
            this.encoding.put(target, dictionaryCode);
            writable.writeInt(dictionaryCode);
        } else {
            writable.writeInt(encoded);
        }
    }

    @Override
    public Payload newPayload() {
        return new PayloadV0_5(this.dictionary.slice(), this.dictionary.messageCount());
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
        this.dictionary.reset();
        this.encoding.clear();
    }

    @Override
    public String endpoint() {
        return "v0.5";
    }

    private final class MetaWriter
    extends MetadataConsumer {
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int metaSize = metadata.getBaggage().size() + metadata.getTags().size() + (null == metadata.getHttpStatusCode() ? 0 : 1) + 1;
            int metricsSize = (metadata.hasSamplingPriority() ? 1 : 0) + (metadata.measured() ? 1 : 0) + (metadata.topLevel() ? 1 : 0) + 1;
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                ++metricsSize;
                --metaSize;
            }
            this.writable.startMap(metaSize);
            for (Map.Entry<String, Object> entry : metadata.getBaggage().entrySet()) {
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getKey());
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getValue());
            }
            TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, TraceMapper.THREAD_NAME);
            TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, metadata.getThreadName());
            if (null != metadata.getHttpStatusCode()) {
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, TraceMapper.HTTP_STATUS);
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, metadata.getHttpStatusCode());
            }
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (entry.getValue() instanceof Number) continue;
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getKey());
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getValue());
            }
            this.writable.startMap(metricsSize);
            if (metadata.hasSamplingPriority()) {
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, TraceMapper.SAMPLING_PRIORITY_KEY);
                this.writable.writeInt(metadata.samplingPriority());
            }
            if (metadata.measured()) {
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, InstrumentationTags.DD_MEASURED);
                this.writable.writeInt(1);
            }
            if (metadata.topLevel()) {
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, InstrumentationTags.DD_TOP_LEVEL);
                this.writable.writeInt(1);
            }
            TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, TraceMapper.THREAD_ID);
            this.writable.writeLong(metadata.getThreadId());
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                TraceMapperV0_5.this.writeDictionaryEncoded(this.writable, entry.getKey());
                this.writable.writeObject(entry.getValue(), null);
            }
        }
    }

    private static class PayloadV0_5
    extends Payload {
        private final ByteBuffer dictionary;
        private final int stringCount;

        private PayloadV0_5(ByteBuffer dictionary, int stringCount) {
            this.dictionary = dictionary;
            this.stringCount = stringCount;
        }

        @Override
        int sizeInBytes() {
            return 1 + this.msgpackArrayHeaderSize(this.stringCount) + this.dictionary.remaining() + this.msgpackArrayHeaderSize(this.traceCount()) + this.body.remaining();
        }

        @Override
        void writeTo(WritableByteChannel channel) throws IOException {
            for (ByteBuffer buffer : this.toList()) {
                while (buffer.hasRemaining()) {
                    channel.write(buffer);
                }
            }
        }

        @Override
        RequestBody toRequest() {
            return OkHttpUtils.msgpackRequestBodyOf(this.toList());
        }

        private List<ByteBuffer> toList() {
            return Arrays.asList(ByteBuffer.allocate(1).put(0, (byte)-110), this.msgpackArrayHeader(this.stringCount), this.dictionary, this.msgpackArrayHeader(this.traceCount()), this.body);
        }
    }

    private static class DictionaryMapper
    implements Mapper<Object> {
        private DictionaryMapper() {
        }

        @Override
        public void map(Object data, Writable packer) {
            if (data instanceof UTF8BytesString) {
                packer.writeObject(data, null);
            } else {
                packer.writeString(String.valueOf(data), null);
            }
        }
    }
}

