/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDId;
import datadog.trace.api.Functions;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.cache.RadixTreeCache;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.Metadata;
import datadog.trace.core.MetadataConsumer;
import datadog.trace.core.PendingTrace;
import datadog.trace.core.taginterceptor.TagInterceptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpanContext
implements AgentSpan.Context {
    private static final Logger log = LoggerFactory.getLogger(DDSpanContext.class);
    public static final String PRIORITY_SAMPLING_KEY = "_sampling_priority_v1";
    public static final String SAMPLE_RATE_KEY = "_sample_rate";
    public static final String ORIGIN_KEY = "_dd.origin";
    private static final DDCache<String, UTF8BytesString> THREAD_NAMES = DDCaches.newFixedSizeCache(256);
    private static final Map<String, String> EMPTY_BAGGAGE = Collections.emptyMap();
    private final PendingTrace trace;
    private volatile Map<String, String> baggageItems;
    private final DDId traceId;
    private final DDId spanId;
    private final DDId parentId;
    private final String parentServiceName;
    private final long threadId;
    private final UTF8BytesString threadName;
    private volatile short httpStatusCode;
    private final Map<String, Object> unsafeTags;
    private volatile String serviceName;
    private volatile CharSequence resourceName;
    private volatile CharSequence operationName;
    private volatile CharSequence spanType;
    private volatile boolean errorFlag;
    private volatile boolean measured;
    private volatile boolean topLevel;
    private static final AtomicIntegerFieldUpdater<DDSpanContext> SAMPLING_PRIORITY_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DDSpanContext.class, "samplingPriorityV1");
    private volatile int samplingPriorityV1 = -128;
    private final String origin;

    public DDSpanContext(DDId traceId, DDId spanId, DDId parentId, CharSequence parentServiceName, String serviceName, CharSequence operationName, CharSequence resourceName, int samplingPriority, String origin, Map<String, String> baggageItems, boolean errorFlag, CharSequence spanType, int tagsSize, PendingTrace trace) {
        assert (trace != null);
        this.trace = trace;
        assert (traceId != null);
        assert (spanId != null);
        assert (parentId != null);
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.parentServiceName = String.valueOf(parentServiceName);
        this.baggageItems = baggageItems == null || baggageItems.isEmpty() ? EMPTY_BAGGAGE : new ConcurrentHashMap<String, String>(baggageItems);
        int capacity = Math.max((tagsSize <= 0 ? 3 : tagsSize + 1) * 4 / 3, 8);
        this.unsafeTags = new HashMap<String, Object>(capacity);
        this.setServiceName(serviceName);
        this.operationName = operationName;
        this.resourceName = resourceName;
        this.errorFlag = errorFlag;
        this.spanType = spanType;
        this.origin = origin;
        if (samplingPriority != -128) {
            this.setSamplingPriority(samplingPriority);
        }
        if (origin != null) {
            this.unsafeTags.put(ORIGIN_KEY, origin);
        }
        Thread current = Thread.currentThread();
        this.threadId = current.getId();
        this.threadName = THREAD_NAMES.computeIfAbsent(current.getName(), Functions.UTF8_ENCODE);
    }

    @Override
    public DDId getTraceId() {
        return this.traceId;
    }

    public DDId getParentId() {
        return this.parentId;
    }

    @Override
    public DDId getSpanId() {
        return this.spanId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = this.trace.getTracer().mapServiceName(serviceName);
        this.topLevel = DDSpanContext.isTopLevel(this.parentServiceName, this.serviceName);
    }

    public CharSequence getResourceName() {
        return this.isResourceNameSet() ? this.resourceName : this.operationName;
    }

    public boolean isResourceNameSet() {
        return this.resourceName != null && this.resourceName.length() != 0;
    }

    public boolean hasResourceName() {
        return this.isResourceNameSet() || this.getTag("resource.name") != null;
    }

    public void setResourceName(CharSequence resourceName) {
        this.resourceName = resourceName;
    }

    public CharSequence getOperationName() {
        return this.operationName;
    }

    public void setOperationName(CharSequence operationName) {
        this.operationName = operationName;
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean errorFlag) {
        if (errorFlag != this.errorFlag) {
            this.errorFlag = errorFlag;
        }
    }

    public boolean isMeasured() {
        return this.measured;
    }

    public void setMeasured(boolean measured) {
        if (measured != this.measured) {
            this.measured = measured;
        }
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    private static boolean isTopLevel(String parentServiceName, String serviceName) {
        return parentServiceName == null || parentServiceName.length() == 0 || !parentServiceName.equals(serviceName);
    }

    public CharSequence getSpanType() {
        return this.spanType;
    }

    public void setSpanType(CharSequence spanType) {
        this.spanType = spanType;
    }

    public void forceKeep() {
        DDSpan rootSpan;
        if (this.trace != null && null != (rootSpan = this.trace.getRootSpan()) && rootSpan.context() != this) {
            rootSpan.context().forceKeep();
            return;
        }
        SAMPLING_PRIORITY_UPDATER.set(this, 2);
    }

    public boolean setSamplingPriority(int newPriority) {
        DDSpan rootSpan;
        if (newPriority == -128) {
            log.debug("{}: Refusing to set samplingPriority to UNSET", (Object)this);
            return false;
        }
        if (this.trace != null && null != (rootSpan = this.trace.getRootSpan()) && rootSpan.context() != this) {
            return rootSpan.context().setSamplingPriority(newPriority);
        }
        if (!SAMPLING_PRIORITY_UPDATER.compareAndSet(this, -128, newPriority)) {
            if (log.isDebugEnabled()) {
                log.debug("samplingPriority locked at {}. Refusing to set to {}", (Object)this.samplingPriorityV1, (Object)newPriority);
            }
            return false;
        }
        return true;
    }

    public int getSamplingPriority() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().getSamplingPriority();
        }
        return this.samplingPriorityV1;
    }

    @Deprecated
    public boolean lockSamplingPriority() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().lockSamplingPriority();
        }
        return SAMPLING_PRIORITY_UPDATER.get(this) != -128;
    }

    public String getOrigin() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan) {
            return rootSpan.context().origin;
        }
        return this.origin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaggageItem(String key, String value) {
        if (this.baggageItems == EMPTY_BAGGAGE) {
            DDSpanContext dDSpanContext = this;
            synchronized (dDSpanContext) {
                if (this.baggageItems == EMPTY_BAGGAGE) {
                    this.baggageItems = new ConcurrentHashMap<String, String>(4);
                }
            }
        }
        this.baggageItems.put(key, value);
    }

    public String getBaggageItem(String key) {
        return this.baggageItems.get(key);
    }

    public Map<String, String> getBaggageItems() {
        return this.baggageItems;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggageItems.entrySet();
    }

    @Override
    public PendingTrace getTrace() {
        return this.trace;
    }

    public CoreTracer getTracer() {
        return this.trace.getTracer();
    }

    public void setHttpStatusCode(short statusCode) {
        this.httpStatusCode = statusCode;
    }

    public short getHttpStatusCode() {
        return this.httpStatusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetric(CharSequence key, Number value) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            this.unsafeSetTag(key.toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTag(String tag, Object value) {
        if (null == value || "".equals(value)) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeTags.remove(tag);
            }
        }
        if (!this.trace.getTracer().getTagInterceptor().interceptTag(this, tag, value)) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeSetTag(tag, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAllTags(Map<String, ? extends Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        TagInterceptor tagInterceptor = this.trace.getTracer().getTagInterceptor();
        Map<String, Object> map2 = this.unsafeTags;
        synchronized (map2) {
            for (Map.Entry<String, ? extends Object> tag : map.entrySet()) {
                if (tagInterceptor.interceptTag(this, tag.getKey(), tag.getValue())) continue;
                this.unsafeSetTag(tag.getKey(), tag.getValue());
            }
        }
    }

    void unsafeSetTag(String tag, Object value) {
        this.unsafeTags.put(tag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getTag(String key) {
        switch (key) {
            case "thread.id": {
                return this.threadId;
            }
            case "thread.name": {
                return this.threadName.toString();
            }
            case "http.status_code": {
                return 0 == this.httpStatusCode ? null : Integer.valueOf(this.httpStatusCode);
            }
        }
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            return this.unsafeGetTag(key);
        }
    }

    public Object unsafeGetTag(String tag) {
        return this.unsafeTags.get(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            HashMap<String, Object> tags = new HashMap<String, Object>(this.unsafeTags);
            tags.put("thread.id", this.threadId);
            tags.put("thread.name", this.threadName.toString());
            if (this.samplingPriorityV1 != -128) {
                tags.put(SAMPLE_RATE_KEY, this.samplingPriorityV1);
            }
            if (this.httpStatusCode != 0) {
                tags.put("http.status_code", this.httpStatusCode);
            }
            return Collections.unmodifiableMap(tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTagsAndBaggage(MetadataConsumer consumer) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            consumer.accept(new Metadata(this.threadId, this.threadName, this.unsafeTags, this.baggageItems, this.samplingPriorityV1, this.measured, this.topLevel, this.httpStatusCode == 0 ? null : RadixTreeCache.HTTP_STATUSES.get(this.httpStatusCode)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder s = new StringBuilder().append("DDSpan [ t_id=").append(this.traceId).append(", s_id=").append(this.spanId).append(", p_id=").append(this.parentId).append(" ] trace=").append(this.getServiceName()).append("/").append(this.getOperationName()).append("/").append(this.getResourceName()).append(" metrics=");
        if (this.errorFlag) {
            s.append(" *errored*");
        }
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            s.append(" tags=").append(new TreeMap<String, Object>(this.getTags()));
        }
        return s.toString();
    }
}

