/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.TypeConverter;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.context.TraceScope;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import java.util.Objects;

class CustomScopeManagerWrapper
implements AgentScopeManager {
    private final ScopeManager delegate;
    private final TypeConverter converter;

    CustomScopeManagerWrapper(ScopeManager scopeManager, TypeConverter converter) {
        this.delegate = scopeManager;
        this.converter = converter;
    }

    @Override
    public AgentScope activate(AgentSpan agentSpan, ScopeSource source) {
        Span span = this.converter.toSpan(agentSpan);
        Scope scope = this.delegate.activate(span);
        return new CustomScopeManagerScope(scope);
    }

    @Override
    public AgentScope activate(AgentSpan agentSpan, ScopeSource source, boolean isAsyncPropagating) {
        Span span = this.converter.toSpan(agentSpan);
        Scope scope = this.delegate.activate(span);
        CustomScopeManagerScope agentScope = new CustomScopeManagerScope(scope);
        agentScope.setAsyncPropagation(isAsyncPropagating);
        return agentScope;
    }

    @Override
    public TraceScope active() {
        return new CustomScopeManagerScope(this.delegate.active());
    }

    @Override
    public AgentSpan activeSpan() {
        return this.converter.toAgentSpan(this.delegate.activeSpan());
    }

    @Override
    public TraceScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
        try (AgentScope scope = this.activate(span, source);){
            TraceScope.Continuation continuation = scope.capture();
            return continuation;
        }
    }

    class CustomScopeManagerScope
    implements AgentScope,
    TraceScope {
        private final Scope delegate;
        private final boolean traceScope;

        private CustomScopeManagerScope(Scope delegate) {
            this.delegate = delegate;
            this.traceScope = delegate instanceof TraceScope;
        }

        @Override
        public AgentSpan span() {
            return CustomScopeManagerWrapper.this.converter.toAgentSpan(this.delegate.span());
        }

        @Override
        public void setAsyncPropagation(boolean value) {
            if (this.traceScope) {
                ((TraceScope)this.delegate).setAsyncPropagation(value);
            }
        }

        public boolean isAsyncPropagating() {
            return this.traceScope && ((TraceScope)this.delegate).isAsyncPropagating();
        }

        public TraceScope.Continuation capture() {
            if (this.traceScope) {
                return ((TraceScope)this.delegate).capture();
            }
            return null;
        }

        public TraceScope.Continuation captureConcurrent() {
            if (this.traceScope) {
                return ((TraceScope)this.delegate).captureConcurrent();
            }
            return null;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        Scope getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomScopeManagerScope that = (CustomScopeManagerScope)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }
    }
}

