/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import datadog.trace.api.StatsDClient;
import datadog.trace.api.scopemanager.ExtendedScopeListener;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuableScopeManager
implements AgentScopeManager {
    private static final Logger log = LoggerFactory.getLogger(ContinuableScopeManager.class);
    final ThreadLocal<ScopeStack> tlsScopeStack = new ThreadLocal<ScopeStack>(){

        @Override
        protected final ScopeStack initialValue() {
            return new ScopeStack();
        }
    };
    private final List<ScopeListener> scopeListeners;
    private final List<ExtendedScopeListener> extendedScopeListeners;
    private final int depthLimit;
    private final StatsDClient statsDClient;
    private final boolean strictMode;
    private final boolean inheritAsyncPropagation;

    public ContinuableScopeManager(int depthLimit, StatsDClient statsDClient, boolean strictMode, boolean inheritAsyncPropagation) {
        this.depthLimit = depthLimit == 0 ? Integer.MAX_VALUE : depthLimit;
        this.statsDClient = statsDClient;
        this.strictMode = strictMode;
        this.inheritAsyncPropagation = inheritAsyncPropagation;
        this.scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
        this.extendedScopeListeners = new CopyOnWriteArrayList<ExtendedScopeListener>();
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source) {
        return this.activate(span, source.id(), false, false);
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.activate(span, source.id(), true, isAsyncPropagating);
    }

    @Override
    public TraceScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
        SingleContinuation continuation = new SingleContinuation(this, span, source.id());
        continuation.register();
        return continuation;
    }

    private AgentScope activate(AgentSpan span, byte source, boolean overrideAsyncPropagation, boolean isAsyncPropagating) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope active = scopeStack.top();
        if (active != null && active.span.equals(span)) {
            active.incrementReferences();
            return active;
        }
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        return this.handleSpan(this.inheritAsyncPropagation ? active : null, null, span, source, overrideAsyncPropagation, isAsyncPropagating);
    }

    private ContinuableScope handleSpan(Continuation continuation, AgentSpan span, byte source) {
        ContinuableScope active = this.inheritAsyncPropagation ? this.scopeStack().top() : null;
        return this.handleSpan(active, continuation, span, source, true, true);
    }

    private ContinuableScope handleSpan(ContinuableScope active, Continuation continuation, AgentSpan span, byte source, boolean overrideAsyncPropagation, boolean isAsyncPropagating) {
        boolean asyncPropagation = overrideAsyncPropagation ? isAsyncPropagating : (active == null ? true : active.isAsyncPropagating());
        ContinuableScope scope = new ContinuableScope(this, continuation, span, source, asyncPropagation);
        this.scopeStack().push(scope);
        return scope;
    }

    @Override
    public TraceScope active() {
        return this.scopeStack().top();
    }

    @Override
    public AgentSpan activeSpan() {
        ContinuableScope active = this.scopeStack().top();
        return active == null ? null : active.span();
    }

    public void addScopeListener(ScopeListener listener) {
        if (listener instanceof ExtendedScopeListener) {
            this.addExtendedScopeListener((ExtendedScopeListener)listener);
        } else {
            this.scopeListeners.add(listener);
            log.debug("Added scope listener {}", (Object)listener);
            AgentSpan activeSpan = this.activeSpan();
            if (activeSpan != null) {
                listener.afterScopeActivated();
            }
        }
    }

    private void addExtendedScopeListener(ExtendedScopeListener listener) {
        this.extendedScopeListeners.add(listener);
        log.debug("Added scope listener {}", (Object)listener);
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan != null && !(activeSpan instanceof AgentTracer.NoopAgentSpan)) {
            listener.afterScopeActivated(activeSpan.getTraceId(), activeSpan.context().getSpanId());
        }
    }

    protected ScopeStack scopeStack() {
        return this.tlsScopeStack.get();
    }

    private static final class ConcurrentContinuation
    extends Continuation {
        private static final int START = 2;
        private static final int CLOSED = -1073741824;
        private static final int BARRIER = -536870912;
        private static final int MIGRATED = 1;
        private volatile int count = 2;
        private static final AtomicIntegerFieldUpdater<ConcurrentContinuation> COUNT = AtomicIntegerFieldUpdater.newUpdater(ConcurrentContinuation.class, "count");

        private ConcurrentContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            super(scopeManager, spanUnderScope, source);
        }

        private boolean tryActivate() {
            int current = COUNT.addAndGet(this, 2);
            if (current < 2) {
                COUNT.addAndGet(this, -2);
            }
            return current > 2;
        }

        private boolean tryClose() {
            int current = COUNT.get(this);
            if (current < -536870912) {
                return false;
            }
            current = COUNT.addAndGet(this, -2);
            while (current < 2 && current > -536870912) {
                if (COUNT.compareAndSet(this, current, -1073741824)) {
                    return true;
                }
                current = COUNT.get(this);
            }
            return false;
        }

        private void tryFinishThreadMigration() {
            int current;
            while (((current = COUNT.get(this)) & 1) == 1 && !COUNT.compareAndSet(this, current, current ^ 1)) {
            }
            if ((current & 1) == 1) {
                this.spanUnderScope.finishThreadMigration();
            }
        }

        public AgentScope activate() {
            if (this.tryActivate()) {
                this.tryFinishThreadMigration();
                return this.scopeManager.handleSpan(this, this.spanUnderScope, this.source);
            }
            return null;
        }

        public void cancel() {
            if (this.tryClose()) {
                this.trace.cancelContinuation(this);
            }
            log.debug("t_id={} -> canceling continuation {}", (Object)this.spanUnderScope.getTraceId(), (Object)this);
        }

        @Override
        public void migrate() {
            int snapshot;
            while (((snapshot = COUNT.get(this)) & 1) != 1 && !COUNT.compareAndSet(this, snapshot, snapshot | 1)) {
            }
            this.spanUnderScope.startThreadMigration();
        }

        @Override
        void cancelFromContinuedScopeClose() {
            this.cancel();
        }

        public String toString() {
            int c = COUNT.get(this);
            String s = c < -536870912 ? "CANCELED" : String.valueOf(c);
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "(" + s + ")->" + this.spanUnderScope;
        }
    }

    private static final class SingleContinuation
    extends Continuation {
        private static final AtomicIntegerFieldUpdater<SingleContinuation> USED = AtomicIntegerFieldUpdater.newUpdater(SingleContinuation.class, "used");
        private volatile int used = 0;

        private SingleContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            super(scopeManager, spanUnderScope, source);
        }

        public AgentScope activate() {
            if (USED.compareAndSet(this, 0, 1)) {
                if (this.migrated) {
                    this.spanUnderScope.finishThreadMigration();
                }
                return this.scopeManager.handleSpan(this, this.spanUnderScope, this.source);
            }
            log.debug("Failed to activate continuation. Reusing a continuation not allowed. Spans may be reported separately.");
            return this.scopeManager.handleSpan(null, this.spanUnderScope, this.source);
        }

        public void cancel() {
            if (USED.compareAndSet(this, 0, 1)) {
                this.trace.cancelContinuation(this);
            } else {
                log.debug("Failed to close continuation {}. Already used.", (Object)this);
            }
        }

        @Override
        public void migrate() {
            this.migrated = true;
            this.spanUnderScope.startThreadMigration();
        }

        @Override
        void cancelFromContinuedScopeClose() {
            this.trace.cancelContinuation(this);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "->" + this.spanUnderScope;
        }
    }

    private static abstract class Continuation
    implements AgentScope.Continuation {
        final ContinuableScopeManager scopeManager;
        final AgentSpan spanUnderScope;
        final byte source;
        final AgentTrace trace;
        protected volatile boolean migrated;

        public Continuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            this.scopeManager = scopeManager;
            this.spanUnderScope = spanUnderScope;
            this.source = source;
            this.trace = spanUnderScope.context().getTrace();
        }

        Continuation register() {
            this.trace.registerContinuation(this);
            return this;
        }

        abstract void cancelFromContinuedScopeClose();
    }

    static final class ScopeStack {
        private final ArrayDeque<ContinuableScope> stack = new ArrayDeque();

        ScopeStack() {
        }

        final ContinuableScope top() {
            return this.stack.peek();
        }

        void cleanup() {
            ContinuableScope curScope = this.stack.peek();
            boolean changedTop = false;
            while (curScope != null) {
                if (curScope.alive()) {
                    if (!changedTop) break;
                    curScope.afterActivated();
                    break;
                }
                curScope.onProperClose();
                this.stack.poll();
                changedTop = true;
                curScope = this.stack.peek();
            }
        }

        final void push(ContinuableScope scope) {
            this.stack.push(scope);
            scope.afterActivated();
        }

        final boolean checkTop(ContinuableScope expectedScope) {
            return expectedScope.equals(this.stack.peek());
        }

        final int depth() {
            return this.stack.size();
        }

        final void clear() {
            this.stack.clear();
        }
    }

    private static final class ContinuableScope
    implements AgentScope {
        private final ContinuableScopeManager scopeManager;
        private final Continuation continuation;
        private boolean isAsyncPropagating;
        private byte flags;
        private short referenceCount = 1;
        private final AgentSpan span;

        ContinuableScope(ContinuableScopeManager scopeManager, Continuation continuation, AgentSpan span, byte source, boolean isAsyncPropagating) {
            this.isAsyncPropagating = isAsyncPropagating;
            this.span = span;
            this.scopeManager = scopeManager;
            this.continuation = continuation;
            this.flags = source;
        }

        @Override
        public void close() {
            boolean alive;
            ScopeStack scopeStack = this.scopeManager.scopeStack();
            boolean onTop = scopeStack.checkTop(this);
            if (!onTop) {
                if (log.isDebugEnabled()) {
                    log.debug("Tried to close {} scope when not on top.  Current top: {}", (Object)this, (Object)scopeStack.top());
                }
                this.scopeManager.statsDClient.incrementCounter("scope.close.error", new String[0]);
                if (this.source() == ScopeSource.MANUAL.id()) {
                    this.scopeManager.statsDClient.incrementCounter("scope.user.close.error", new String[0]);
                    if (this.scopeManager.strictMode) {
                        throw new RuntimeException("Tried to close scope when not on top");
                    }
                }
            }
            if (alive = this.decrementReferences()) {
                return;
            }
            scopeStack.cleanup();
            if (null != this.continuation) {
                this.continuation.cancelFromContinuedScopeClose();
            }
        }

        final void onProperClose() {
            for (ScopeListener listener : this.scopeManager.scopeListeners) {
                try {
                    listener.afterScopeClosed();
                }
                catch (Exception e) {
                    log.debug("ScopeListener threw exception in close()", (Throwable)e);
                }
            }
            if (!this.notifiedOnActivate()) {
                return;
            }
            for (ScopeListener listener : this.scopeManager.extendedScopeListeners) {
                try {
                    listener.afterScopeClosed();
                }
                catch (Exception e) {
                    log.debug("ScopeListener threw exception in close()", (Throwable)e);
                }
            }
        }

        final void incrementReferences() {
            this.referenceCount = (short)(this.referenceCount + 1);
        }

        final boolean decrementReferences() {
            this.referenceCount = (short)(this.referenceCount - 1);
            return this.referenceCount > 0;
        }

        final boolean alive() {
            return this.referenceCount > 0;
        }

        public boolean isAsyncPropagating() {
            return this.isAsyncPropagating;
        }

        @Override
        public AgentSpan span() {
            return this.span;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
            this.isAsyncPropagating = value;
        }

        public Continuation capture() {
            return this.isAsyncPropagating ? new SingleContinuation(this.scopeManager, this.span, this.source()).register() : null;
        }

        public Continuation captureConcurrent() {
            return this.isAsyncPropagating ? new ConcurrentContinuation(this.scopeManager, this.span, this.source()).register() : null;
        }

        public String toString() {
            return super.toString() + "->" + this.span;
        }

        public void afterActivated() {
            for (ScopeListener listener : this.scopeManager.scopeListeners) {
                try {
                    listener.afterScopeActivated();
                }
                catch (Throwable e) {
                    log.debug("ScopeListener threw exception in afterActivated()", e);
                }
            }
            if (this.span.eligibleForDropping()) {
                return;
            }
            this.flags = (byte)(this.flags | 0x80);
            for (ScopeListener listener : this.scopeManager.extendedScopeListeners) {
                try {
                    listener.afterScopeActivated(this.span.getTraceId(), this.span.context().getSpanId());
                }
                catch (Throwable e) {
                    log.debug("ExtendedScopeListener threw exception in afterActivated()", e);
                }
            }
        }

        private byte source() {
            return (byte)(this.flags & 0x7F);
        }

        private boolean notifiedOnActivate() {
            return this.flags < 0;
        }
    }
}

