/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.monitor;

import datadog.communication.monitor.Counter;
import datadog.communication.monitor.Monitoring;
import datadog.communication.monitor.NoOpCounter;
import datadog.communication.monitor.NoOpRecording;
import datadog.communication.monitor.Recording;
import datadog.trace.api.Platform;
import datadog.trace.api.StatsDClient;
import datadog.trace.core.monitor.StatsDCounter;
import datadog.trace.core.monitor.ThreadLocalRecording;
import datadog.trace.core.monitor.Timer;
import java.util.concurrent.TimeUnit;

public final class MonitoringImpl
implements Monitoring {
    private final StatsDClient statsd;
    private final long flushAfterNanos;
    private final boolean enabled;

    public MonitoringImpl(StatsDClient statsd, long flushInterval, TimeUnit flushUnit) {
        this.statsd = statsd;
        this.flushAfterNanos = flushUnit.toNanos(flushInterval);
        this.enabled = true;
    }

    private MonitoringImpl() {
        this.statsd = StatsDClient.NO_OP;
        this.flushAfterNanos = 0L;
        this.enabled = false;
    }

    public Recording newTimer(String name) {
        if (!this.enabled || !Platform.isJavaVersionAtLeast(8)) {
            return NoOpRecording.NO_OP;
        }
        return new Timer(name, this.statsd, this.flushAfterNanos);
    }

    public Recording newTimer(String name, String ... tags) {
        if (!this.enabled || !Platform.isJavaVersionAtLeast(8)) {
            return NoOpRecording.NO_OP;
        }
        return new Timer(name, tags, this.statsd, this.flushAfterNanos);
    }

    public Recording newThreadLocalTimer(final String name) {
        if (!this.enabled || !Platform.isJavaVersionAtLeast(8)) {
            return NoOpRecording.NO_OP;
        }
        return new ThreadLocalRecording(new ThreadLocal<Recording>(){

            @Override
            protected Recording initialValue() {
                return MonitoringImpl.this.newTimer(name, "thread:" + Thread.currentThread().getName());
            }
        });
    }

    public Counter newCounter(String name) {
        if (!this.enabled) {
            return NoOpCounter.NO_OP;
        }
        return new StatsDCounter(name, this.statsd);
    }
}

