/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.util;

import datadog.trace.api.Config;
import datadog.trace.core.util.SystemAccessProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemAccess {
    private static final Logger log = LoggerFactory.getLogger(SystemAccess.class);
    private static volatile SystemAccessProvider systemAccessProvider = SystemAccessProvider.NONE;

    public static void disableJmx() {
        log.debug("Disabling JMX system access provider");
        systemAccessProvider = SystemAccessProvider.NONE;
    }

    public static void enableJmx() {
        if (!Config.get().isProfilingEnabled() && !Config.get().isHealthMetricsEnabled()) {
            log.debug("Will not enable JMX access. Profiling and metrics are both disabled.");
            return;
        }
        try {
            log.debug("Enabling JMX system provider");
            systemAccessProvider = (SystemAccessProvider)Class.forName("datadog.trace.core.util.JmxSystemAccessProvider", false, SystemAccess.class.getClassLoader()).getField("INSTANCE").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            log.info("Unable to initialize JMX system provider", (Throwable)e);
        }
    }

    public static long getCurrentThreadCpuTime() {
        return systemAccessProvider.getThreadCpuTime();
    }
}

