/*
 * Decompiled with CFR 0.152.
 */
package datadog.communication.http;

import datadog.common.container.ContainerInfo;
import datadog.common.socket.UnixDomainSocketFactory;
import datadog.communication.http.RejectingExecutorService;
import datadog.trace.util.AgentProxySelector;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;

public final class OkHttpUtils {
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_META_LANG_VERSION = "Datadog-Meta-Lang-Version";
    private static final String DATADOG_META_LANG_INTERPRETER = "Datadog-Meta-Lang-Interpreter";
    private static final String DATADOG_META_LANG_INTERPRETER_VENDOR = "Datadog-Meta-Lang-Interpreter-Vendor";
    private static final String DATADOG_CONTAINER_ID = "Datadog-Container-ID";
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String JAVA_VM_NAME = System.getProperty("java.vm.name", "unknown");
    private static final String JAVA_VM_VENDOR = System.getProperty("java.vm.vendor", "unknown");

    public static OkHttpClient buildHttpClient(HttpUrl url, long timeoutMillis) {
        return OkHttpUtils.buildHttpClient(url.scheme(), null, timeoutMillis);
    }

    public static OkHttpClient buildHttpClient(HttpUrl url, String unixDomainSocketPath, long timeoutMillis) {
        return OkHttpUtils.buildHttpClient(url.scheme(), unixDomainSocketPath, timeoutMillis);
    }

    public static OkHttpClient buildHttpClient(String scheme, String unixDomainSocketPath, long timeoutMillis) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (unixDomainSocketPath != null) {
            builder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File(unixDomainSocketPath)));
        }
        if (!"https".equals(scheme)) {
            builder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
        }
        builder.connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).writeTimeout(timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).proxySelector(AgentProxySelector.INSTANCE).dispatcher(new Dispatcher((ExecutorService)RejectingExecutorService.INSTANCE));
        return builder.build();
    }

    public static Request.Builder prepareRequest(HttpUrl url, Map<String, String> headers) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_META_LANG_VERSION, JAVA_VERSION).addHeader(DATADOG_META_LANG_INTERPRETER, JAVA_VM_NAME).addHeader(DATADOG_META_LANG_INTERPRETER_VENDOR, JAVA_VM_VENDOR);
        for (Map.Entry<String, String> e : headers.entrySet()) {
            builder.addHeader(e.getKey(), e.getValue());
        }
        String containerId = ContainerInfo.get().getContainerId();
        if (containerId == null) {
            return builder;
        }
        return builder.addHeader(DATADOG_CONTAINER_ID, containerId);
    }

    public static RequestBody msgpackRequestBodyOf(List<ByteBuffer> buffers) {
        return new ByteBufferRequestBody(buffers);
    }

    private static final class ByteBufferRequestBody
    extends RequestBody {
        private static final MediaType MSGPACK = MediaType.get((String)"application/msgpack");
        private final List<ByteBuffer> buffers;

        private ByteBufferRequestBody(List<ByteBuffer> buffers) {
            this.buffers = buffers;
        }

        public long contentLength() {
            long length = 0L;
            for (ByteBuffer buffer : this.buffers) {
                length += (long)buffer.remaining();
            }
            return length;
        }

        public MediaType contentType() {
            return MSGPACK;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            for (ByteBuffer buffer : this.buffers) {
                while (buffer.hasRemaining()) {
                    sink.write(buffer);
                }
            }
        }
    }
}

