/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import javax.annotation.Nonnull;

public final class Strings {
    public static String toEnvVar(String string) {
        return string.replace('.', '_').replace('-', '_').toUpperCase();
    }

    public static String getResourceName(String className) {
        if (!className.endsWith(".class")) {
            return className.replace('.', '/') + ".class";
        }
        return className;
    }

    public static String getClassName(String resourceName) {
        if (resourceName.endsWith(".class")) {
            return resourceName.substring(0, resourceName.length() - 6).replace('/', '.');
        }
        return resourceName.replace('/', '.');
    }

    public static String getInternalName(String resourceName) {
        return resourceName.replace('.', '/');
    }

    public static String getInnerClassName(String className) {
        return className.replace('.', '$');
    }

    public static String join(CharSequence joiner, Iterable<? extends CharSequence> strings) {
        StringBuilder sb = new StringBuilder();
        for (CharSequence charSequence : strings) {
            sb.append(charSequence).append(joiner);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - joiner.length());
        }
        return sb.toString();
    }

    public static String join(CharSequence joiner, CharSequence ... strings) {
        if (strings.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(strings[0]);
            for (int i = 1; i < strings.length; ++i) {
                sb.append(joiner).append(strings[i]);
            }
            return sb.toString();
        }
        return "";
    }

    public static String replace(String str, String delimiter, String replacement) {
        int matchIndex;
        StringBuilder sb = new StringBuilder(str);
        int curIndex = 0;
        while ((matchIndex = sb.indexOf(delimiter, curIndex)) != -1) {
            sb.replace(matchIndex, matchIndex + delimiter.length(), replacement);
            curIndex = matchIndex + replacement.length();
        }
        return sb.toString();
    }

    public static String replaceFirst(String str, String delimiter, String replacement) {
        StringBuilder sb = new StringBuilder(str);
        int i = sb.indexOf(delimiter);
        if (i != -1) {
            sb.replace(i, i + delimiter.length(), replacement);
        }
        return sb.toString();
    }

    @Nonnull
    public static String propertyNameToEnvironmentVariableName(String setting) {
        return "DD_" + setting.replace('.', '_').replace('-', '_').toUpperCase();
    }

    @Nonnull
    public static String propertyNameToSystemPropertyName(String setting) {
        return "dd." + setting;
    }
}

