/*
 * Decompiled with CFR 0.152.
 */
package datadog.communication.ddagent;

import datadog.common.socket.SocketUtils;
import datadog.communication.ddagent.DDAgentFeaturesDiscovery;
import datadog.communication.http.OkHttpUtils;
import datadog.communication.monitor.Monitoring;
import datadog.trace.api.Config;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class SharedCommunicationObjects {
    public OkHttpClient okHttpClient;
    public HttpUrl agentUrl;
    public Monitoring monitoring;
    public DDAgentFeaturesDiscovery featuresDiscovery;

    public void createRemaining(Config config) {
        if (this.monitoring == null) {
            this.monitoring = Monitoring.DISABLED;
        }
        if (this.agentUrl == null) {
            this.agentUrl = HttpUrl.get((String)config.getAgentUrl());
        }
        if (this.okHttpClient == null) {
            String unixDomainSocket = SocketUtils.discoverApmSocket(config);
            this.okHttpClient = OkHttpUtils.buildHttpClient(this.agentUrl, unixDomainSocket, TimeUnit.SECONDS.toMillis(config.getAgentTimeout()));
        }
        this.featuresDiscovery(config);
    }

    public DDAgentFeaturesDiscovery featuresDiscovery(Config config) {
        if (this.featuresDiscovery == null) {
            this.featuresDiscovery = new DDAgentFeaturesDiscovery(this.okHttpClient, this.monitoring, this.agentUrl, config.isTraceAgentV05Enabled(), config.isTracerMetricsEnabled());
        }
        return this.featuresDiscovery;
    }
}

