/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.CustomScopeManagerWrapper;
import datadog.opentracing.LogHandler;
import datadog.opentracing.OTScopeManager;
import datadog.opentracing.OTSpan;
import datadog.opentracing.OTSpanContext;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.context.TraceScope;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;

class TypeConverter {
    private final LogHandler logHandler;

    public TypeConverter(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public AgentSpan toAgentSpan(Span span) {
        if (span == null) {
            return null;
        }
        if (span instanceof OTSpan) {
            return ((OTSpan)span).getDelegate();
        }
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    public OTSpan toSpan(AgentSpan agentSpan) {
        if (agentSpan == null) {
            return null;
        }
        return new OTSpan(agentSpan, this, this.logHandler);
    }

    public Scope toScope(Object scope, boolean finishSpanOnClose) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof CustomScopeManagerWrapper.CustomScopeManagerScope) {
            return ((CustomScopeManagerWrapper.CustomScopeManagerScope)scope).getDelegate();
        }
        if (scope instanceof TraceScope) {
            return new OTScopeManager.OTTraceScope((TraceScope)scope, finishSpanOnClose, this);
        }
        return new OTScopeManager.OTScope((AgentScope)scope, finishSpanOnClose, this);
    }

    public SpanContext toSpanContext(AgentSpan.Context context) {
        if (context == null) {
            return null;
        }
        return new OTSpanContext(context);
    }

    public AgentSpan.Context toContext(SpanContext spanContext) {
        if (spanContext == null) {
            return null;
        }
        if (spanContext instanceof OTSpanContext) {
            return ((OTSpanContext)spanContext).getDelegate();
        }
        return AgentTracer.NoopContext.INSTANCE;
    }
}

