/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.gateway;

import datadog.trace.api.Function;
import datadog.trace.api.function.BiFunction;
import datadog.trace.api.function.Supplier;
import datadog.trace.api.function.TriConsumer;
import datadog.trace.api.gateway.EventType;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import java.util.concurrent.atomic.AtomicInteger;

public final class Events {
    private static final AtomicInteger nextId = new AtomicInteger(0);
    public static final int REQUEST_STARTED_ID = 0;
    public static final EventType<Supplier<Flow<RequestContext>>> REQUEST_STARTED = new ET<Supplier<Flow<RequestContext>>>("request.started", 0);
    public static final int REQUEST_ENDED_ID = 1;
    public static final EventType<Function<RequestContext, Flow<Void>>> REQUEST_ENDED = new ET<Function<RequestContext, Flow<Void>>>("request.ended", 1);
    public static final int REQUEST_HEADER_ID = 2;
    public static final EventType<TriConsumer<RequestContext, String, String>> REQUEST_HEADER = new ET<TriConsumer<RequestContext, String, String>>("server.request.header", 2);
    public static final int REQUEST_HEADER_DONE_ID = 3;
    public static final EventType<Function<RequestContext, Flow<Void>>> REQUEST_HEADER_DONE = new ET<Function<RequestContext, Flow<Void>>>("server.request.header.done", 3);
    public static final int REQUEST_URI_RAW_ID = 4;
    public static final EventType<BiFunction<RequestContext, URIDataAdapter, Flow<Void>>> REQUEST_URI_RAW = new ET<BiFunction<RequestContext, URIDataAdapter, Flow<Void>>>("server.request.uri.raw", 4);
    public static final int MAX_EVENTS = nextId.get();

    private Events() {
    }

    private static final class ET<T>
    extends EventType<T> {
        public ET(String type, int id) {
            super(type, id);
            int expectedId = nextId.getAndIncrement();
            if (id != expectedId) {
                throw new IllegalArgumentException("Event " + type + " has broken id " + id + ", expected " + expectedId + ".");
            }
        }
    }
}

