/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.gateway;

import datadog.trace.api.Function;
import datadog.trace.api.function.BiFunction;
import datadog.trace.api.function.Supplier;
import datadog.trace.api.function.TriConsumer;
import datadog.trace.api.gateway.CallbackProvider;
import datadog.trace.api.gateway.EventType;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.Subscription;
import datadog.trace.api.gateway.SubscriptionService;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationGateway
implements CallbackProvider,
SubscriptionService {
    private static final Logger log = LoggerFactory.getLogger(InstrumentationGateway.class);
    private final AtomicReferenceArray<Object> callbacks = new AtomicReferenceArray(Events.MAX_EVENTS);

    @Override
    public <C> C getCallback(EventType<C> eventType) {
        return (C)this.callbacks.get(eventType.getId());
    }

    @Override
    public <C> Subscription registerCallback(final EventType<C> eventType, final C callback) {
        final C wrapped = InstrumentationGateway.wrap(eventType, callback);
        final int id = eventType.getId();
        if (!this.callbacks.compareAndSet(id, null, wrapped)) {
            Object existing = this.callbacks.get(id);
            String message = "Trying to overwrite existing callback " + existing + " for event type " + eventType;
            log.warn(message);
            throw new IllegalStateException(message);
        }
        return new Subscription(){

            @Override
            public void cancel() {
                if (!InstrumentationGateway.this.callbacks.compareAndSet(id, wrapped, null) && log.isDebugEnabled()) {
                    log.debug("Failed to unregister callback {} for event type {}", callback, (Object)eventType);
                }
            }
        };
    }

    public static <C> C wrap(final EventType<C> eventType, final C callback) {
        switch (eventType.getId()) {
            case 0: {
                return (C)new Supplier<Flow<RequestContext>>(){

                    @Override
                    public Flow<RequestContext> get() {
                        try {
                            return (Flow)((Supplier)callback).get();
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 1: 
            case 3: {
                return (C)new Function<RequestContext, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx) {
                        try {
                            return (Flow)((Function)callback).apply(ctx);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 2: {
                return (C)new TriConsumer<RequestContext, String, String>(){

                    @Override
                    public void accept(RequestContext ctx, String key, String value) {
                        try {
                            ((TriConsumer)callback).accept(ctx, key, value);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 4: {
                return (C)new BiFunction<RequestContext, URIDataAdapter, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, URIDataAdapter adapter) {
                        try {
                            return (Flow)((BiFunction)callback).apply(ctx, adapter);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
        }
        log.warn("Unwrapped callback for {}", eventType);
        return callback;
    }
}

