/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.AppVeyorInfo;
import datadog.trace.bootstrap.instrumentation.ci.AzurePipelinesInfo;
import datadog.trace.bootstrap.instrumentation.ci.BitBucketInfo;
import datadog.trace.bootstrap.instrumentation.ci.BitriseInfo;
import datadog.trace.bootstrap.instrumentation.ci.BuildkiteInfo;
import datadog.trace.bootstrap.instrumentation.ci.CircleCIInfo;
import datadog.trace.bootstrap.instrumentation.ci.GitLabInfo;
import datadog.trace.bootstrap.instrumentation.ci.GithubActionsInfo;
import datadog.trace.bootstrap.instrumentation.ci.JenkinsInfo;
import datadog.trace.bootstrap.instrumentation.ci.NoopCIInfo;
import datadog.trace.bootstrap.instrumentation.ci.TravisInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitUtils;
import datadog.trace.bootstrap.instrumentation.ci.git.LocalFSGitInfoExtractor;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@SuppressForbidden
public abstract class CIProviderInfo {
    protected Map<String, String> ciTags;

    public CIProviderInfo() {
        CIInfo ciInfo = this.buildCIInfo();
        GitInfo ciGitInfo = this.buildCIGitInfo();
        GitInfo localGitInfo = this.buildCILocalGitInfo(ciInfo);
        String ciGitCommit = ciGitInfo.getCommit().getSha();
        String localFSGitCommit = localGitInfo.getCommit().getSha();
        this.ciTags = new CITagsBuilder().withCiProviderName(ciInfo.getCiProviderName()).withCiPipelineId(ciInfo.getCiPipelineId()).withCiPipelineName(ciInfo.getCiPipelineName()).withCiStageName(ciInfo.getCiStageName()).withCiJobName(ciInfo.getCiJobName()).withCiPipelineNumber(ciInfo.getCiPipelineNumber()).withCiPipelineUrl(ciInfo.getCiPipelineUrl()).withCiJorUrl(ciInfo.getCiJobUrl()).withCiWorkspacePath(ciInfo.getCiWorkspace()).withGitRepositoryUrl(ciGitInfo.getRepositoryURL(), localGitInfo.getRepositoryURL()).withGitCommit(ciGitCommit, localFSGitCommit).withGitBranch(ciGitInfo.getBranch(), localGitInfo.getBranch()).withGitTag(ciGitInfo.getTag(), localGitInfo.getTag()).withGitCommitAuthorName(ciGitInfo, localGitInfo).withGitCommitAuthorEmail(ciGitInfo, localGitInfo).withGitCommitAuthorDate(ciGitInfo, localGitInfo).withGitCommitCommitterName(ciGitInfo, localGitInfo).withGitCommitCommitterEmail(ciGitInfo, localGitInfo).withGitCommitCommitterDate(ciGitInfo, localGitInfo).withGitCommitMessage(ciGitInfo, localGitInfo).build();
    }

    protected abstract GitInfo buildCIGitInfo();

    protected abstract CIInfo buildCIInfo();

    protected String getGitFolderName() {
        return ".git";
    }

    private GitInfo buildCILocalGitInfo(CIInfo ciInfo) {
        if (ciInfo.getCiWorkspace() == null) {
            return GitInfo.NOOP;
        }
        return new LocalFSGitInfoExtractor().headCommit(Paths.get(ciInfo.getCiWorkspace(), this.getGitFolderName()).toFile().getAbsolutePath());
    }

    public boolean isCI() {
        return true;
    }

    public Map<String, String> getCiTags() {
        return this.ciTags;
    }

    public static CIProviderInfo selectCI() {
        if (System.getenv("JENKINS_URL") != null) {
            return new JenkinsInfo();
        }
        if (System.getenv("GITLAB_CI") != null) {
            return new GitLabInfo();
        }
        if (System.getenv("TRAVIS") != null) {
            return new TravisInfo();
        }
        if (System.getenv("CIRCLECI") != null) {
            return new CircleCIInfo();
        }
        if (System.getenv("APPVEYOR") != null) {
            return new AppVeyorInfo();
        }
        if (System.getenv("TF_BUILD") != null) {
            return new AzurePipelinesInfo();
        }
        if (System.getenv("BITBUCKET_BUILD_NUMBER") != null) {
            return new BitBucketInfo();
        }
        if (System.getenv("GITHUB_ACTION") != null) {
            return new GithubActionsInfo();
        }
        if (System.getenv("BUILDKITE") != null) {
            return new BuildkiteInfo();
        }
        if (System.getenv("BITRISE_BUILD_SLUG") != null) {
            return new BitriseInfo();
        }
        return new NoopCIInfo();
    }

    protected String expandTilde(String path) {
        if (path == null || path.isEmpty() || !path.startsWith("~")) {
            return path;
        }
        if (!path.equals("~") && !path.startsWith("~/")) {
            return path;
        }
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    protected String normalizeRef(String rawRef) {
        return GitUtils.normalizeRef(rawRef);
    }

    protected String filterSensitiveInfo(String urlStr) {
        return GitUtils.filterSensitiveInfo(urlStr);
    }

    public static class CIInfo {
        public static final CIInfo NOOP = new CIInfo();
        private final String ciProviderName;
        private final String ciPipelineId;
        private final String ciPipelineName;
        private final String ciStageName;
        private final String ciJobName;
        private final String ciPipelineNumber;
        private final String ciPipelineUrl;
        private final String ciJobUrl;
        private final String ciWorkspace;

        public static Builder builder() {
            return new Builder();
        }

        public CIInfo() {
            this(null, null, null, null, null, null, null, null, null);
        }

        public CIInfo(String ciProviderName, String ciPipelineId, String ciPipelineName, String ciStageName, String ciJobName, String ciPipelineNumber, String ciPipelineUrl, String ciJobUrl, String ciWorkspace) {
            this.ciProviderName = ciProviderName;
            this.ciPipelineId = ciPipelineId;
            this.ciPipelineName = ciPipelineName;
            this.ciStageName = ciStageName;
            this.ciJobName = ciJobName;
            this.ciPipelineNumber = ciPipelineNumber;
            this.ciPipelineUrl = ciPipelineUrl;
            this.ciJobUrl = ciJobUrl;
            this.ciWorkspace = ciWorkspace;
        }

        public String getCiProviderName() {
            return this.ciProviderName;
        }

        public String getCiPipelineId() {
            return this.ciPipelineId;
        }

        public String getCiPipelineName() {
            return this.ciPipelineName;
        }

        public String getCiStageName() {
            return this.ciStageName;
        }

        public String getCiJobName() {
            return this.ciJobName;
        }

        public String getCiPipelineNumber() {
            return this.ciPipelineNumber;
        }

        public String getCiPipelineUrl() {
            return this.ciPipelineUrl;
        }

        public String getCiJobUrl() {
            return this.ciJobUrl;
        }

        public String getCiWorkspace() {
            return this.ciWorkspace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CIInfo ciInfo = (CIInfo)o;
            return Objects.equals(this.ciProviderName, ciInfo.ciProviderName) && Objects.equals(this.ciPipelineId, ciInfo.ciPipelineId) && Objects.equals(this.ciPipelineName, ciInfo.ciPipelineName) && Objects.equals(this.ciStageName, ciInfo.ciStageName) && Objects.equals(this.ciJobName, ciInfo.ciJobName) && Objects.equals(this.ciPipelineNumber, ciInfo.ciPipelineNumber) && Objects.equals(this.ciPipelineUrl, ciInfo.ciPipelineUrl) && Objects.equals(this.ciJobUrl, ciInfo.ciJobUrl) && Objects.equals(this.ciWorkspace, ciInfo.ciWorkspace);
        }

        public int hashCode() {
            return Objects.hash(this.ciProviderName, this.ciPipelineId, this.ciPipelineName, this.ciStageName, this.ciJobName, this.ciPipelineNumber, this.ciPipelineUrl, this.ciJobUrl, this.ciWorkspace);
        }

        public String toString() {
            return "CIInfo{ciProviderName='" + this.ciProviderName + '\'' + ", ciPipelineId='" + this.ciPipelineId + '\'' + ", ciPipelineName='" + this.ciPipelineName + '\'' + ", ciStageName='" + this.ciStageName + '\'' + ", ciJobName='" + this.ciJobName + '\'' + ", ciPipelineNumber='" + this.ciPipelineNumber + '\'' + ", ciPipelineUrl='" + this.ciPipelineUrl + '\'' + ", ciJobUrl='" + this.ciJobUrl + '\'' + ", ciWorkspace='" + this.ciWorkspace + '\'' + '}';
        }

        public static final class Builder {
            private String ciProviderName;
            private String ciPipelineId;
            private String ciPipelineName;
            private String ciStageName;
            private String ciJobName;
            private String ciPipelineNumber;
            private String ciPipelineUrl;
            private String ciJobUrl;
            private String ciWorkspace;

            public Builder ciProviderName(String ciProviderName) {
                this.ciProviderName = ciProviderName;
                return this;
            }

            public Builder ciPipelineId(String ciPipelineId) {
                this.ciPipelineId = ciPipelineId;
                return this;
            }

            public Builder ciPipelineName(String ciPipelineName) {
                this.ciPipelineName = ciPipelineName;
                return this;
            }

            public Builder ciStageName(String ciStageName) {
                this.ciStageName = ciStageName;
                return this;
            }

            public Builder ciJobName(String ciJobName) {
                this.ciJobName = ciJobName;
                return this;
            }

            public Builder ciPipelineNumber(String ciPipelineNumber) {
                this.ciPipelineNumber = ciPipelineNumber;
                return this;
            }

            public Builder ciPipelineUrl(String ciPipelineUrl) {
                this.ciPipelineUrl = ciPipelineUrl;
                return this;
            }

            public Builder ciJobUrl(String ciJobUrl) {
                this.ciJobUrl = ciJobUrl;
                return this;
            }

            public Builder ciWorkspace(String ciWorkspace) {
                this.ciWorkspace = ciWorkspace;
                return this;
            }

            public CIInfo build() {
                return new CIInfo(this.ciProviderName, this.ciPipelineId, this.ciPipelineName, this.ciStageName, this.ciJobName, this.ciPipelineNumber, this.ciPipelineUrl, this.ciJobUrl, this.ciWorkspace);
            }
        }
    }

    public static class CITagsBuilder {
        private final Map<String, String> ciTags = new HashMap<String, String>();

        public CITagsBuilder withCiProviderName(String ciProviderName) {
            return this.putTagValue("ci.provider.name", ciProviderName);
        }

        public CITagsBuilder withCiPipelineId(String ciPipelineId) {
            return this.putTagValue("ci.pipeline.id", ciPipelineId);
        }

        public CITagsBuilder withCiPipelineName(String ciPipelineName) {
            return this.putTagValue("ci.pipeline.name", ciPipelineName);
        }

        public CITagsBuilder withCiPipelineNumber(String ciPipelineNumber) {
            return this.putTagValue("ci.pipeline.number", ciPipelineNumber);
        }

        public CITagsBuilder withCiPipelineUrl(String ciPipelineUrl) {
            return this.putTagValue("ci.pipeline.url", ciPipelineUrl);
        }

        public CITagsBuilder withCiStageName(String ciStageName) {
            return this.putTagValue("ci.stage.name", ciStageName);
        }

        public CITagsBuilder withCiJobName(String ciJobName) {
            return this.putTagValue("ci.job.name", ciJobName);
        }

        public CITagsBuilder withCiJorUrl(String ciJobUrl) {
            return this.putTagValue("ci.job.url", ciJobUrl);
        }

        public CITagsBuilder withCiWorkspacePath(String ciWorkspacePath) {
            return this.putTagValue("ci.workspace_path", ciWorkspacePath);
        }

        public CITagsBuilder withGitRepositoryUrl(String gitRepositoryUrl, String localFSGitRepositoryUrl) {
            return this.putTagValue("git.repository_url", gitRepositoryUrl, localFSGitRepositoryUrl);
        }

        public CITagsBuilder withGitCommit(String gitCommit, String localFSGitCommit) {
            return this.putTagValue("git.commit.sha", gitCommit, localFSGitCommit);
        }

        public CITagsBuilder withGitBranch(String gitBranch, String localFSGitBranch) {
            return this.putTagValue("git.branch", gitBranch, localFSGitBranch);
        }

        public CITagsBuilder withGitTag(String gitTag, String localFSGitTag) {
            return this.putTagValue("git.tag", gitTag, localFSGitTag);
        }

        public CITagsBuilder withGitCommitAuthorName(GitInfo ciGitInfo, GitInfo localGitInfo) {
            if (ciGitInfo.getCommit().getAuthor().getName() != null) {
                this.putTagValue("git.commit.author.name", ciGitInfo.getCommit().getAuthor().getName());
                return this;
            }
            return this.putTagValueIfCommitEquals("git.commit.author.name", ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha(), localGitInfo.getCommit().getAuthor().getName());
        }

        public CITagsBuilder withGitCommitAuthorEmail(GitInfo ciGitInfo, GitInfo localGitInfo) {
            if (ciGitInfo.getCommit().getAuthor().getEmail() != null) {
                this.putTagValue("git.commit.author.email", ciGitInfo.getCommit().getAuthor().getEmail());
                return this;
            }
            return this.putTagValueIfCommitEquals("git.commit.author.email", ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha(), localGitInfo.getCommit().getAuthor().getEmail());
        }

        public CITagsBuilder withGitCommitAuthorDate(GitInfo ciGitInfo, GitInfo localGitInfo) {
            if (ciGitInfo.getCommit().getAuthor().getWhen() > 0L) {
                this.putTagValue("git.commit.author.date", ciGitInfo.getCommit().getAuthor().getISO8601Date());
                return this;
            }
            return this.putTagValueIfCommitEquals("git.commit.author.date", ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha(), localGitInfo.getCommit().getAuthor().getISO8601Date());
        }

        public CITagsBuilder withGitCommitCommitterName(GitInfo ciGitInfo, GitInfo localGitInfo) {
            if (ciGitInfo.getCommit().getCommitter().getName() != null) {
                this.putTagValue("git.commit.committer.name", ciGitInfo.getCommit().getCommitter().getName());
                return this;
            }
            return this.putTagValueIfCommitEquals("git.commit.committer.name", ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha(), localGitInfo.getCommit().getCommitter().getName());
        }

        public CITagsBuilder withGitCommitCommitterEmail(GitInfo ciGitInfo, GitInfo localGitInfo) {
            if (ciGitInfo.getCommit().getCommitter().getEmail() != null) {
                this.putTagValue("git.commit.committer.email", ciGitInfo.getCommit().getCommitter().getEmail());
                return this;
            }
            return this.putTagValueIfCommitEquals("git.commit.committer.email", ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha(), localGitInfo.getCommit().getCommitter().getEmail());
        }

        public CITagsBuilder withGitCommitCommitterDate(GitInfo ciGitInfo, GitInfo localGitInfo) {
            if (ciGitInfo.getCommit().getCommitter().getWhen() > 0L) {
                this.putTagValue("git.commit.committer.date", ciGitInfo.getCommit().getCommitter().getISO8601Date());
                return this;
            }
            return this.putTagValueIfCommitEquals("git.commit.committer.date", ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha(), localGitInfo.getCommit().getCommitter().getISO8601Date());
        }

        public CITagsBuilder withGitCommitMessage(GitInfo ciGitInfo, GitInfo localGitInfo) {
            if (ciGitInfo.getCommit().getFullMessage() != null) {
                this.putTagValue("git.commit.message", ciGitInfo.getCommit().getFullMessage());
                return this;
            }
            return this.putTagValueIfCommitEquals("git.commit.message", ciGitInfo.getCommit().getSha(), localGitInfo.getCommit().getSha(), localGitInfo.getCommit().getFullMessage());
        }

        public Map<String, String> build() {
            return this.ciTags;
        }

        private CITagsBuilder putTagValue(String tagKey, String tagValue) {
            return this.putTagValue(tagKey, tagValue, null);
        }

        private CITagsBuilder putTagValue(String tagKey, String tagValue, String fallbackValue) {
            if (tagValue != null) {
                this.ciTags.put(tagKey, tagValue);
            } else if (fallbackValue != null) {
                this.ciTags.put(tagKey, fallbackValue);
            }
            return this;
        }

        private CITagsBuilder putTagValueIfCommitEquals(String tagKey, String ciGitCommit, String localFSGitCommit, String tagValue) {
            if (ciGitCommit == null || ciGitCommit.equalsIgnoreCase(localFSGitCommit)) {
                this.putTagValue(tagKey, tagValue);
            }
            return this;
        }
    }
}

