/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.http;

import datadog.trace.api.function.BiFunction;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.InstrumentationGateway;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.http.StoredBodySupplier;
import datadog.trace.api.http.StoredByteBody;
import datadog.trace.api.http.StoredCharBody;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import java.nio.charset.Charset;

public class StoredBodyFactories {
    private StoredBodyFactories() {
    }

    public static StoredByteBody maybeCreateForByte(Charset charset, String contentLengthHeader) {
        AgentSpan agentSpan = AgentTracer.activeSpan();
        if (agentSpan == null) {
            return null;
        }
        return StoredBodyFactories.maybeCreateForByte(charset, agentSpan, contentLengthHeader);
    }

    public static StoredByteBody maybeCreateForByte(Charset charset, AgentSpan agentSpan, String contentLengthHeader) {
        RequestContext requestContext = agentSpan.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        InstrumentationGateway cbp = AgentTracer.get().instrumentationGateway();
        BiFunction<RequestContext, StoredBodySupplier, Void> requestStartCb = cbp.getCallback(Events.REQUEST_BODY_START);
        BiFunction<RequestContext, StoredBodySupplier, Flow<Void>> requestEndedCb = cbp.getCallback(Events.REQUEST_BODY_DONE);
        if (requestStartCb == null || requestEndedCb == null) {
            return null;
        }
        int lengthHint = StoredBodyFactories.parseLengthHeader(contentLengthHeader);
        return new StoredByteBody(requestContext, requestStartCb, requestEndedCb, charset, lengthHint);
    }

    public static StoredCharBody maybeCreateForChar(String contentLengthHeader) {
        AgentSpan agentSpan = AgentTracer.activeSpan();
        if (agentSpan == null) {
            return null;
        }
        return StoredBodyFactories.maybeCreateForChar(agentSpan, contentLengthHeader);
    }

    public static StoredCharBody maybeCreateForChar(AgentSpan agentSpan, String contentLengthHeader) {
        RequestContext requestContext = agentSpan.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        InstrumentationGateway cbp = AgentTracer.get().instrumentationGateway();
        BiFunction<RequestContext, StoredBodySupplier, Void> requestStartCb = cbp.getCallback(Events.REQUEST_BODY_START);
        BiFunction<RequestContext, StoredBodySupplier, Flow<Void>> requestEndedCb = cbp.getCallback(Events.REQUEST_BODY_DONE);
        if (requestStartCb == null || requestEndedCb == null) {
            return null;
        }
        int lengthHint = StoredBodyFactories.parseLengthHeader(contentLengthHeader);
        return new StoredCharBody(requestContext, requestStartCb, requestEndedCb, lengthHint);
    }

    private static int parseLengthHeader(String contentLengthHeader) {
        if (contentLengthHeader != null) {
            try {
                return Integer.parseInt(contentLengthHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

