/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.communication.monitor.Recording;
import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.PendingTraceBuffer;
import datadog.trace.core.util.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTrace
implements AgentTrace,
PendingTraceBuffer.Element {
    private static final Logger log = LoggerFactory.getLogger(PendingTrace.class);
    private static final List<DDSpan> EMPTY = new ArrayList<DDSpan>(0);
    private final CoreTracer tracer;
    private final DDId traceId;
    private final PendingTraceBuffer pendingTraceBuffer;
    private final boolean strictTraceWrites;
    private final long startTimeNano;
    private final long startNanoTicks;
    private final ConcurrentLinkedDeque<DDSpan> finishedSpans = new ConcurrentLinkedDeque();
    private volatile int completedSpanCount = 0;
    private static final AtomicIntegerFieldUpdater<PendingTrace> COMPLETED_SPAN_COUNT = AtomicIntegerFieldUpdater.newUpdater(PendingTrace.class, "completedSpanCount");
    private volatile int pendingReferenceCount = 0;
    private static final AtomicIntegerFieldUpdater<PendingTrace> PENDING_REFERENCE_COUNT = AtomicIntegerFieldUpdater.newUpdater(PendingTrace.class, "pendingReferenceCount");
    private volatile DDSpan rootSpan = null;
    private static final AtomicReferenceFieldUpdater<PendingTrace, DDSpan> ROOT_SPAN = AtomicReferenceFieldUpdater.newUpdater(PendingTrace.class, DDSpan.class, "rootSpan");
    private volatile boolean rootSpanWritten = false;
    private volatile long lastReferenced = 0L;

    private PendingTrace(@Nonnull CoreTracer tracer, @Nonnull DDId traceId, @Nonnull PendingTraceBuffer pendingTraceBuffer, boolean strictTraceWrites) {
        this.tracer = tracer;
        this.traceId = traceId;
        this.pendingTraceBuffer = pendingTraceBuffer;
        this.strictTraceWrites = strictTraceWrites;
        this.startTimeNano = Clock.currentNanoTime();
        this.startNanoTicks = Clock.currentNanoTicks();
    }

    CoreTracer getTracer() {
        return this.tracer;
    }

    public long getCurrentTimeNano() {
        long nanoTicks;
        this.lastReferenced = nanoTicks = Clock.currentNanoTicks();
        return this.startTimeNano + Math.max(0L, nanoTicks - this.startNanoTicks);
    }

    public void touch() {
        this.lastReferenced = Clock.currentNanoTicks();
    }

    @Override
    public boolean lastReferencedNanosAgo(long nanos) {
        long currentNanoTicks = Clock.currentNanoTicks();
        long age = currentNanoTicks - this.lastReferenced;
        return nanos < age;
    }

    void registerSpan(DDSpan span) {
        this.tracer.onStart(span);
        ROOT_SPAN.compareAndSet(this, null, span);
        PENDING_REFERENCE_COUNT.incrementAndGet(this);
    }

    void onFinish(DDSpan span) {
        this.tracer.onFinish(span);
    }

    PublishState onPublish(DDSpan span) {
        this.finishedSpans.addFirst(span);
        COMPLETED_SPAN_COUNT.incrementAndGet(this);
        return this.decrementRefAndMaybeWrite(span == this.getRootSpan());
    }

    @Override
    public DDSpan getRootSpan() {
        return this.rootSpan;
    }

    @Override
    public long oldestFinishedTime() {
        long oldest = Long.MAX_VALUE;
        for (DDSpan span : this.finishedSpans) {
            oldest = Math.min(oldest, span.getStartTime() + span.getDurationNano());
        }
        return oldest;
    }

    @Override
    public void registerContinuation(AgentScope.Continuation continuation) {
        PENDING_REFERENCE_COUNT.incrementAndGet(this);
    }

    @Override
    public void cancelContinuation(AgentScope.Continuation continuation) {
        this.decrementRefAndMaybeWrite(false);
    }

    private PublishState decrementRefAndMaybeWrite(boolean isRootSpan) {
        int count = PENDING_REFERENCE_COUNT.decrementAndGet(this);
        if (this.strictTraceWrites && count < 0) {
            throw new IllegalStateException("Pending reference count " + count + " is negative");
        }
        int partialFlushMinSpans = this.tracer.getPartialFlushMinSpans();
        if (count == 0 && (this.strictTraceWrites || !this.rootSpanWritten)) {
            this.write();
            return PublishState.WRITTEN;
        }
        if (isRootSpan) {
            this.pendingTraceBuffer.enqueue(this);
            return PublishState.ROOT_BUFFERED;
        }
        if (0 < partialFlushMinSpans && partialFlushMinSpans < this.size()) {
            this.partialFlush();
            return PublishState.PARTIAL_FLUSH;
        }
        if (this.rootSpanWritten) {
            this.pendingTraceBuffer.enqueue(this);
            return PublishState.BUFFERED;
        }
        return PublishState.PENDING;
    }

    private void partialFlush() {
        int size = this.write(true);
        if (log.isDebugEnabled()) {
            log.debug("t_id={} -> wrote partial trace of size {}", (Object)this.traceId, (Object)size);
        }
    }

    @Override
    public void write() {
        this.write(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write(boolean isPartial) {
        if (!this.finishedSpans.isEmpty()) {
            try (Recording recording = this.tracer.writeTimer();){
                List<DDSpan> trace;
                PendingTrace pendingTrace = this;
                synchronized (pendingTrace) {
                    int size;
                    if (!isPartial) {
                        this.rootSpanWritten = true;
                    }
                    if (!((size = this.size()) <= 0 || isPartial && size <= this.tracer.getPartialFlushMinSpans())) {
                        trace = new ArrayList<DDSpan>(size);
                        DDSpan span = this.finishedSpans.pollFirst();
                        while (null != span) {
                            trace.add(span);
                            span = this.finishedSpans.pollFirst();
                        }
                    } else {
                        trace = EMPTY;
                    }
                }
                if (!trace.isEmpty()) {
                    COMPLETED_SPAN_COUNT.addAndGet(this, -trace.size());
                    this.tracer.write(trace);
                    int n = trace.size();
                    return n;
                }
            }
        }
        return 0;
    }

    public int size() {
        return this.completedSpanCount;
    }

    static enum PublishState {
        WRITTEN,
        PARTIAL_FLUSH,
        ROOT_BUFFERED,
        BUFFERED,
        PENDING;

    }

    static class Factory {
        private final CoreTracer tracer;
        private final PendingTraceBuffer pendingTraceBuffer;
        private final boolean strictTraceWrites;

        Factory(CoreTracer tracer, PendingTraceBuffer pendingTraceBuffer, boolean strictTraceWrites) {
            this.tracer = tracer;
            this.pendingTraceBuffer = pendingTraceBuffer;
            this.strictTraceWrites = strictTraceWrites;
        }

        PendingTrace create(@Nonnull DDId traceId) {
            return new PendingTrace(this.tracer, traceId, this.pendingTraceBuffer, this.strictTraceWrites);
        }
    }
}

