/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.http;

import datadog.trace.api.Config;
import datadog.trace.api.Functions;
import datadog.trace.api.Pair;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.http.AntPatternPathNormalizer;
import datadog.trace.api.http.PathNormalizer;
import datadog.trace.api.http.SimplePathNormalizer;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import java.util.Map;

public class UrlBasedResourceNameCalculator {
    private static final UTF8BytesString DEFAULT_RESOURCE_NAME = UTF8BytesString.create("/");
    public static final PathNormalizer SIMPLE_PATH_NORMALIZER = new SimplePathNormalizer();
    public static final UrlBasedResourceNameCalculator RESOURCE_NAME_CALCULATOR = new UrlBasedResourceNameCalculator();
    private final boolean shouldSetUrlResourceName = Config.get().isRuleEnabled("URLAsResourceNameRule");
    private final DDCache<Pair<String, String>, UTF8BytesString> resourceNames = this.shouldSetUrlResourceName ? DDCaches.newFixedSizeCache(512) : null;
    private final PathNormalizer pathNormalizer;

    UrlBasedResourceNameCalculator() {
        Map<String, String> httpResourceNameMatchers = Config.get().getHttpServerPathResourceNameMapping();
        this.pathNormalizer = !httpResourceNameMatchers.isEmpty() ? new AntPatternPathNormalizer(httpResourceNameMatchers, SIMPLE_PATH_NORMALIZER) : SIMPLE_PATH_NORMALIZER;
    }

    public UTF8BytesString calculate(String method, String path, boolean encoded) {
        if (!this.shouldSetUrlResourceName) {
            return DEFAULT_RESOURCE_NAME;
        }
        return this.resourceNames.computeIfAbsent(Pair.of(method, this.pathNormalizer.normalize(path, encoded)), Functions.PATH_BASED_RESOURCE_NAME);
    }
}

