/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDId;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.core.CoreSpan;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.MetadataConsumer;
import datadog.trace.core.PendingTrace;
import datadog.trace.core.util.Clock;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpan
implements AgentSpan,
CoreSpan<DDSpan> {
    private static final Logger log = LoggerFactory.getLogger(DDSpan.class);
    public static final String CHECKPOINTED_TAG = "checkpointed";
    private final DDSpanContext context;
    private final long startTimeMicro;
    private final long startTimeNano;
    private final AtomicLong durationNano = new AtomicLong();
    private boolean forceKeep;
    volatile Boolean emittingCheckpoints = null;

    static DDSpan create(long timestampMicro, @Nonnull DDSpanContext context) {
        DDSpan span = new DDSpan(timestampMicro, context);
        log.debug("Started span: {}", (Object)span);
        context.getTrace().registerSpan(span);
        return span;
    }

    private DDSpan(long timestampMicro, @Nonnull DDSpanContext context) {
        this.context = context;
        if (timestampMicro <= 0L) {
            this.startTimeMicro = Clock.currentMicroTime();
            this.startTimeNano = context.getTrace().getCurrentTimeNano();
        } else {
            this.startTimeMicro = timestampMicro;
            this.startTimeNano = 0L;
            context.getTrace().touch();
        }
    }

    public boolean isFinished() {
        return this.durationNano.get() != 0L;
    }

    private void finishAndAddToTrace(long durationNano) {
        if (this.durationNano.compareAndSet(0L, Math.max(1L, durationNano))) {
            this.context.getTrace().onFinish(this);
            PendingTrace.PublishState publishState = this.context.getTrace().onPublish(this);
            log.debug("Finished span ({}): {}", (Object)publishState, (Object)this);
        } else {
            log.debug("Already finished: {}", (Object)this);
        }
    }

    @Override
    public final void finish() {
        if (this.startTimeNano > 0L) {
            this.finishAndAddToTrace(this.context.getTrace().getCurrentTimeNano() - this.startTimeNano);
        } else {
            this.finish(Clock.currentMicroTime());
        }
    }

    @Override
    public final void finish(long stoptimeMicros) {
        this.context.getTrace().touch();
        this.finishAndAddToTrace(TimeUnit.MICROSECONDS.toNanos(stoptimeMicros - this.startTimeMicro));
    }

    @Override
    public final boolean phasedFinish() {
        long durationNano = this.startTimeNano > 0L ? this.context.getTrace().getCurrentTimeNano() - this.startTimeNano : TimeUnit.MICROSECONDS.toNanos(Clock.currentMicroTime() - this.startTimeMicro);
        if (this.durationNano.compareAndSet(0L, Math.max(1L, durationNano) | Long.MIN_VALUE)) {
            this.context.getTrace().onFinish(this);
            log.debug("Finished span (PHASED): {}", (Object)this);
            return true;
        }
        log.debug("Already finished: {}", (Object)this);
        return false;
    }

    @Override
    public final void publish() {
        long durationNano = this.durationNano.get();
        if (durationNano == 0L) {
            log.debug("Can't publish unfinished span: {}", (Object)this);
        } else if (durationNano > 0L) {
            log.debug("Already published: {}", (Object)this);
        } else if (this.durationNano.compareAndSet(durationNano, durationNano & Long.MAX_VALUE)) {
            PendingTrace.PublishState publishState = this.context.getTrace().onPublish(this);
            log.debug("Published span ({}): {}", (Object)publishState, (Object)this);
        }
    }

    @Override
    public DDSpan setError(boolean error) {
        this.context.setErrorFlag(error);
        return this;
    }

    @Override
    public DDSpan setMeasured(boolean measured) {
        this.context.setMeasured(measured);
        return this;
    }

    public DDSpan forceKeep(boolean forceKeep) {
        this.forceKeep = forceKeep;
        return this;
    }

    @Override
    public boolean isForceKeep() {
        return this.forceKeep;
    }

    @Override
    public void setEmittingCheckpoints(boolean value) {
        DDSpan rootSpan = this.getLocalRootSpan();
        if (rootSpan.emittingCheckpoints == null) {
            rootSpan.emittingCheckpoints = value;
            if (value) {
                rootSpan.setTag(CHECKPOINTED_TAG, value);
            }
        }
    }

    @Override
    public Boolean isEmittingCheckpoints() {
        return this.getLocalRootSpan().emittingCheckpoints;
    }

    public final boolean isRootSpan() {
        return DDId.ZERO.equals((Object)this.context.getParentId());
    }

    @Deprecated
    public AgentSpan getRootSpan() {
        return this.getLocalRootSpan();
    }

    @Override
    public DDSpan getLocalRootSpan() {
        return this.context.getTrace().getRootSpan();
    }

    @Override
    public boolean isSameTrace(AgentSpan otherSpan) {
        if (otherSpan instanceof DDSpan) {
            return this.getTraceId().equals((Object)otherSpan.getTraceId());
        }
        return false;
    }

    @Override
    public DDSpan setErrorMessage(String errorMessage) {
        return this.setTag("error.msg", errorMessage);
    }

    @Override
    public DDSpan addThrowable(Throwable error) {
        if (null != error) {
            String message = error.getMessage();
            if (!"broken pipe".equalsIgnoreCase(message)) {
                this.setError(true);
                StringWriter errorString = new StringWriter();
                error.printStackTrace(new PrintWriter(errorString));
                this.setTag("error.stack", errorString.toString());
            }
            this.setTag("error.msg", message);
            this.setTag("error.type", error.getClass().getName());
        }
        return this;
    }

    @Override
    public final DDSpan setTag(String tag, String value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public final DDSpan setTag(String tag, boolean value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, int value) {
        if ("http.status_code".equals(tag)) {
            this.context.setHttpStatusCode((short)value);
        }
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, long value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, double value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, Number value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setMetric(CharSequence metric, int value) {
        this.context.setMetric(metric, value);
        return this;
    }

    @Override
    public DDSpan setMetric(CharSequence name, float value) {
        this.context.setMetric(name, Float.valueOf(value));
        return this;
    }

    @Override
    public DDSpan setMetric(CharSequence metric, long value) {
        this.context.setMetric(metric, value);
        return this;
    }

    @Override
    public DDSpan setMetric(CharSequence metric, double value) {
        this.context.setMetric(metric, value);
        return this;
    }

    @Override
    public DDSpan setFlag(CharSequence name, boolean value) {
        this.context.setMetric(name, value ? 1 : 0);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, CharSequence value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan setTag(String tag, Object value) {
        this.context.setTag(tag, value);
        return this;
    }

    @Override
    public DDSpan removeTag(String tag) {
        this.context.setTag(tag, null);
        return this;
    }

    @Override
    public Object getTag(String tag) {
        return this.context.getTag(tag);
    }

    @Override
    @Nonnull
    public final DDSpanContext context() {
        return this.context;
    }

    @Override
    public final String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    @Override
    public final DDSpan setBaggageItem(String key, String value) {
        this.context.setBaggageItem(key, value);
        return this;
    }

    @Override
    public AgentSpan setHttpStatusCode(int statusCode) {
        this.context.setHttpStatusCode((short)statusCode);
        return this;
    }

    @Override
    public short getHttpStatusCode() {
        return this.context.getHttpStatusCode();
    }

    @Override
    public CharSequence getOrigin() {
        return this.context.getOrigin();
    }

    public final DDSpan setOperationName(CharSequence operationName) {
        this.context.setOperationName(operationName);
        return this;
    }

    public final DDSpan setServiceName(String serviceName) {
        this.context.setServiceName(serviceName);
        return this;
    }

    @Override
    public final DDSpan setResourceName(CharSequence resourceName) {
        this.context.setResourceName(resourceName);
        return this;
    }

    @Override
    public boolean eligibleForDropping() {
        int samplingPriority = this.context.getSamplingPriority();
        return samplingPriority == -1 || samplingPriority == 0;
    }

    @Override
    public void startThreadMigration() {
        this.context.getTracer().onStartThreadMigration(this);
    }

    @Override
    public void finishThreadMigration() {
        this.context.getTracer().onFinishThreadMigration(this);
    }

    @Override
    public void finishWork() {
        this.context.getTracer().onFinishWork(this);
    }

    @Override
    public RequestContext getRequestContext() {
        return this.context.getRequestContext();
    }

    @Override
    public final DDSpan setSamplingPriority(int newPriority) {
        this.context.setSamplingPriority(newPriority);
        return this;
    }

    @Override
    public DDSpan setSamplingPriority(int samplingPriority, CharSequence rate, double sampleRate) {
        if (this.context.setSamplingPriority(samplingPriority)) {
            this.setMetric(rate, sampleRate);
        }
        return this;
    }

    @Override
    public final DDSpan setSpanType(CharSequence type) {
        this.context.setSpanType(type);
        return this;
    }

    @Override
    public long getStartTime() {
        return this.startTimeNano > 0L ? this.startTimeNano : TimeUnit.MICROSECONDS.toNanos(this.startTimeMicro);
    }

    @Override
    public long getDurationNano() {
        return this.durationNano.get();
    }

    @Override
    public String getServiceName() {
        return this.context.getServiceName();
    }

    @Override
    public DDId getTraceId() {
        return this.context.getTraceId();
    }

    @Override
    public DDId getSpanId() {
        return this.context.getSpanId();
    }

    @Override
    public DDId getParentId() {
        return this.context.getParentId();
    }

    @Override
    public CharSequence getResourceName() {
        return this.context.getResourceName();
    }

    @Override
    public CharSequence getOperationName() {
        return this.context.getOperationName();
    }

    @Override
    public CharSequence getSpanName() {
        return this.context.getOperationName();
    }

    @Override
    public void setSpanName(CharSequence spanName) {
        this.context.setOperationName(spanName);
    }

    @Override
    public boolean hasResourceName() {
        return this.context.hasResourceName();
    }

    public Integer getSamplingPriority() {
        int samplingPriority = this.context.getSamplingPriority();
        if (samplingPriority == -128) {
            return null;
        }
        return samplingPriority;
    }

    @Override
    public int samplingPriority() {
        return this.context.getSamplingPriority();
    }

    public String getSpanType() {
        CharSequence spanType = this.context.getSpanType();
        return null == spanType ? null : spanType.toString();
    }

    public Map<String, Object> getTags() {
        return this.context.getTags();
    }

    @Override
    public CharSequence getType() {
        return this.context.getSpanType();
    }

    @Override
    public void processTagsAndBaggage(MetadataConsumer consumer) {
        this.context.processTagsAndBaggage(consumer);
    }

    public boolean isError() {
        return this.context.getErrorFlag();
    }

    @Override
    public int getError() {
        return this.context.getErrorFlag() ? 1 : 0;
    }

    @Override
    public <U> U getTag(CharSequence name, U defaultValue) {
        Object tag = this.getTag(String.valueOf(name));
        return (U)(null == tag ? defaultValue : tag);
    }

    @Override
    public <U> U getTag(CharSequence name) {
        return this.getTag(name, null);
    }

    @Override
    public boolean hasSamplingPriority() {
        return this.context.getTrace().getRootSpan() == this;
    }

    @Override
    public boolean isMeasured() {
        return this.context.isMeasured();
    }

    @Override
    public boolean isTopLevel() {
        return this.context.isTopLevel();
    }

    public Map<String, String> getBaggage() {
        return Collections.unmodifiableMap(this.context.getBaggageItems());
    }

    public String toString() {
        return this.context.toString() + ", duration_ns=" + this.durationNano;
    }
}

