/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.ContextInterpreter;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.propagation.TagContextExtractor;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class B3HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(B3HttpCodec.class);
    private static final String B3_TRACE_ID = "b3.traceid";
    private static final String B3_SPAN_ID = "b3.spanid";
    private static final String TRACE_ID_KEY = "X-B3-TraceId";
    private static final String SPAN_ID_KEY = "X-B3-SpanId";
    private static final String SAMPLING_PRIORITY_KEY = "X-B3-Sampled";
    private static final String B3_KEY = "b3";
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);

    private B3HttpCodec() {
    }

    public static HttpCodec.Extractor newExtractor(Map<String, String> tagMapping) {
        return new TagContextExtractor(tagMapping, new ContextInterpreter.Factory(){

            @Override
            protected ContextInterpreter construct(Map<String, String> mapping) {
                return new B3ContextInterpreter(mapping);
            }
        });
    }

    private static class B3ContextInterpreter
    extends ContextInterpreter {
        private static final int TRACE_ID = 0;
        private static final int SPAN_ID = 1;
        private static final int TAGS = 2;
        private static final int SAMPLING_PRIORITY = 3;
        private static final int B3_ID = 4;
        private static final int IGNORE = -1;

        private B3ContextInterpreter(Map<String, String> taggedHeaders) {
            super(taggedHeaders);
        }

        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty()) {
                return true;
            }
            if (LOG_EXTRACT_HEADER_NAMES) {
                log.debug("Header: {}", (Object)key);
            }
            String lowerCaseKey = null;
            int classification = -1;
            if (B3HttpCodec.B3_KEY.equals(key)) {
                classification = 4;
            } else if (Character.toLowerCase(key.charAt(0)) == 'x') {
                if ((this.traceId == null || this.traceId == DDId.ZERO) && B3HttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                    classification = 0;
                } else if ((this.spanId == null || this.spanId == DDId.ZERO) && B3HttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                    classification = 1;
                } else if (this.samplingPriority == this.defaultSamplingPriority() && B3HttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                    classification = 3;
                } else if (this.handledForwarding(key, value)) {
                    return true;
                }
            }
            if (!this.taggedHeaders.isEmpty() && classification == -1 && this.taggedHeaders.containsKey(lowerCaseKey = this.toLowerCase(key))) {
                classification = 2;
            }
            if (classification != -1) {
                try {
                    String firstValue = HttpCodec.firstHeaderValue(value);
                    if (null != firstValue) {
                        switch (classification) {
                            case 4: {
                                if (!this.extractB3(firstValue)) break;
                                return true;
                            }
                            case 0: {
                                if (!this.setTraceId(firstValue)) break;
                                return true;
                            }
                            case 1: {
                                this.setSpanId(firstValue);
                                break;
                            }
                            case 3: {
                                this.samplingPriority = this.convertSamplingPriority(firstValue);
                                break;
                            }
                            case 2: {
                                String mappedKey = (String)this.taggedHeaders.get(lowerCaseKey);
                                if (null == mappedKey) break;
                                if (this.tags.isEmpty()) {
                                    this.tags = new TreeMap();
                                }
                                this.tags.put(mappedKey, HttpCodec.decode(firstValue));
                                break;
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.invalidateContext();
                    log.debug("Exception when extracting context", (Throwable)e);
                    return false;
                }
            }
            return true;
        }

        private boolean extractB3(String firstValue) {
            if (firstValue.length() == 1) {
                this.samplingPriority = this.convertSamplingPriority(firstValue);
            } else {
                String b3SpanId;
                String b3TraceId;
                int firstIndex = firstValue.indexOf("-");
                int secondIndex = firstValue.indexOf("-", firstIndex + 1);
                if (firstIndex != -1 && this.setTraceId(b3TraceId = firstValue.substring(0, firstIndex))) {
                    return true;
                }
                if (secondIndex == -1) {
                    b3SpanId = firstValue.substring(firstIndex + 1);
                    this.setSpanId(b3SpanId);
                } else {
                    b3SpanId = firstValue.substring(firstIndex + 1, secondIndex);
                    this.setSpanId(b3SpanId);
                    String b3SamplingId = firstValue.substring(secondIndex + 1);
                    this.samplingPriority = this.convertSamplingPriority(b3SamplingId);
                }
            }
            return false;
        }

        private void setSpanId(String sId) {
            this.spanId = DDId.fromHexWithOriginal((String)sId);
            if (this.tags.isEmpty()) {
                this.tags = new TreeMap();
            }
            this.tags.put(B3HttpCodec.B3_SPAN_ID, sId);
        }

        private boolean setTraceId(String tId) {
            int length = tId.length();
            if (length > 32) {
                log.debug("Header {} exceeded max length of 32: {}", (Object)B3HttpCodec.TRACE_ID_KEY, (Object)tId);
                this.traceId = DDId.ZERO;
                return true;
            }
            this.traceId = DDId.fromHexTruncatedWithOriginal((String)tId);
            if (this.tags.isEmpty()) {
                this.tags = new TreeMap();
            }
            this.tags.put(B3HttpCodec.B3_TRACE_ID, tId);
            return false;
        }

        private int convertSamplingPriority(String samplingPriority) {
            return "1".equals(samplingPriority) ? 1 : 0;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            block3: {
                try {
                    String injectedTraceId = context.getTraceId().toHexStringOrOriginal();
                    String injectedSpanId = context.getSpanId().toHexStringOrOriginal();
                    setter.set(carrier, B3HttpCodec.TRACE_ID_KEY, injectedTraceId);
                    setter.set(carrier, B3HttpCodec.SPAN_ID_KEY, injectedSpanId);
                    StringBuilder injectedB3Id = new StringBuilder(100);
                    injectedB3Id.append(injectedTraceId).append('-').append(injectedSpanId);
                    if (context.lockSamplingPriority()) {
                        String injectedSamplingPriority = this.convertSamplingPriority(context.getSamplingPriority());
                        setter.set(carrier, B3HttpCodec.SAMPLING_PRIORITY_KEY, injectedSamplingPriority);
                        injectedB3Id.append('-').append(injectedSamplingPriority);
                    }
                    setter.set(carrier, B3HttpCodec.B3_KEY, injectedB3Id.toString());
                    log.debug("{} - B3 parent context injected - {}", (Object)context.getTraceId(), (Object)injectedTraceId);
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Cannot parse context id(s): {} {}", new Object[]{context.getTraceId(), context.getSpanId(), e});
                }
            }
        }

        private String convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
        }
    }
}

