/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.Checkpointer;
import datadog.trace.api.SpanCheckpointer;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SamplingCheckpointer
implements SpanCheckpointer {
    private static final Logger log = LoggerFactory.getLogger(SamplingCheckpointer.class);
    private static final AtomicReferenceFieldUpdater<SamplingCheckpointer, Checkpointer> CAS = AtomicReferenceFieldUpdater.newUpdater(SamplingCheckpointer.class, Checkpointer.class, "checkpointer");
    private volatile Checkpointer checkpointer;

    public static SamplingCheckpointer create() {
        return new SamplingCheckpointer(NoOpCheckpointer.NO_OP);
    }

    public SamplingCheckpointer(Checkpointer checkpointer) {
        this.checkpointer = checkpointer;
    }

    public void register(Checkpointer checkpointer) {
        if (!CAS.compareAndSet(this, NoOpCheckpointer.NO_OP, checkpointer)) {
            log.debug("failed to register checkpointer {} - {} already registered", checkpointer.getClass(), this.checkpointer.getClass());
        } else {
            log.debug("Registered checkpointer implementation: {}", (Object)checkpointer);
        }
    }

    @Override
    public void checkpoint(AgentSpan span, int flags) {
        if (!span.eligibleForDropping()) {
            this.checkpointer.checkpoint(span, flags);
        }
    }

    @Override
    public void onStart(AgentSpan span) {
        this.checkpoint(span, 6);
    }

    @Override
    public void onStartWork(AgentSpan span) {
        this.checkpoint(span, 2);
    }

    @Override
    public void onFinishWork(AgentSpan span) {
        this.checkpoint(span, 3);
    }

    @Override
    public void onStartThreadMigration(AgentSpan span) {
        this.checkpoint(span, 10);
    }

    @Override
    public void onFinishThreadMigration(AgentSpan span) {
        this.checkpoint(span, 11);
    }

    @Override
    public void onFinish(AgentSpan span) {
        this.checkpoint(span, 7);
    }

    @Override
    public void onRootSpan(AgentSpan rootSpan, boolean published) {
        Boolean emittingCheckpoints = rootSpan.isEmittingCheckpoints();
        this.checkpointer.onRootSpan(rootSpan, published && emittingCheckpoints != null && emittingCheckpoints != false);
    }

    private static final class NoOpCheckpointer
    implements Checkpointer {
        static final NoOpCheckpointer NO_OP = new NoOpCheckpointer();

        private NoOpCheckpointer() {
        }

        @Override
        public void checkpoint(AgentSpan span, int flags) {
        }

        @Override
        public void onRootSpan(AgentSpan rootSpan, boolean published) {
        }
    }
}

