/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.api.Checkpointer;
import datadog.trace.api.DDId;
import datadog.trace.api.SpanCheckpointer;
import datadog.trace.api.Tracer;
import datadog.trace.api.gateway.InstrumentationGateway;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import java.util.Collections;
import java.util.Map;

public class AgentTracer {
    private static final TracerAPI DEFAULT;
    private static volatile TracerAPI provider;

    public static AgentSpan startSpan(CharSequence spanName) {
        return AgentTracer.startSpan(spanName, true);
    }

    public static AgentSpan startSpan(CharSequence spanName, boolean withCheckpoints) {
        return AgentTracer.get().startSpan(spanName, withCheckpoints);
    }

    public static AgentSpan startSpan(CharSequence spanName, long startTimeMicros) {
        return AgentTracer.startSpan(spanName, startTimeMicros, true);
    }

    public static AgentSpan startSpan(CharSequence spanName, long startTimeMicros, boolean withCheckpoints) {
        return AgentTracer.get().startSpan(spanName, startTimeMicros, withCheckpoints);
    }

    public static AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent) {
        return AgentTracer.startSpan(spanName, parent, true);
    }

    public static AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, boolean withCheckpoints) {
        return AgentTracer.get().startSpan(spanName, parent, withCheckpoints);
    }

    public static AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
        return AgentTracer.startSpan(spanName, parent, startTimeMicros, true);
    }

    public static AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, long startTimeMicros, boolean withCheckpoints) {
        return AgentTracer.get().startSpan(spanName, parent, startTimeMicros, withCheckpoints);
    }

    public static AgentScope activateSpan(AgentSpan span) {
        return AgentTracer.get().activateSpan(span, ScopeSource.INSTRUMENTATION, true);
    }

    public static AgentScope activateSpan(AgentSpan span, boolean isAsyncPropagating) {
        return AgentTracer.get().activateSpan(span, ScopeSource.INSTRUMENTATION, isAsyncPropagating);
    }

    public static TraceScope.Continuation captureSpan(AgentSpan span) {
        return AgentTracer.get().captureSpan(span, ScopeSource.INSTRUMENTATION);
    }

    public static AgentSpan activeSpan() {
        return AgentTracer.get().activeSpan();
    }

    public static TraceScope activeScope() {
        return AgentTracer.get().activeScope();
    }

    public static AgentPropagation propagate() {
        return AgentTracer.get().propagate();
    }

    public static AgentSpan noopSpan() {
        return AgentTracer.get().noopSpan();
    }

    public static boolean isRegistered() {
        return provider != DEFAULT;
    }

    public static synchronized void registerIfAbsent(TracerAPI tracer) {
        if (tracer != null && tracer != DEFAULT) {
            provider = tracer;
        }
    }

    public static synchronized void forceRegister(TracerAPI tracer) {
        provider = tracer;
    }

    public static TracerAPI get() {
        return provider;
    }

    private AgentTracer() {
    }

    static {
        provider = DEFAULT = new NoopTracerAPI();
    }

    public static class NoopAgentTrace
    implements AgentTrace {
        public static final NoopAgentTrace INSTANCE = new NoopAgentTrace();

        @Override
        public void registerContinuation(AgentScope.Continuation continuation) {
        }

        @Override
        public void cancelContinuation(AgentScope.Continuation continuation) {
        }
    }

    public static class NoopContext
    implements AgentSpan.Context.Extracted {
        public static final NoopContext INSTANCE = new NoopContext();

        @Override
        public DDId getTraceId() {
            return DDId.ZERO;
        }

        @Override
        public DDId getSpanId() {
            return DDId.ZERO;
        }

        @Override
        public AgentTrace getTrace() {
            return NoopAgentTrace.INSTANCE;
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return Collections.emptyList();
        }

        @Override
        public String getForwarded() {
            return null;
        }

        @Override
        public String getForwardedProto() {
            return null;
        }

        @Override
        public String getForwardedHost() {
            return null;
        }

        @Override
        public String getForwardedIp() {
            return null;
        }

        @Override
        public String getForwardedPort() {
            return null;
        }

        @Override
        public RequestContext getRequestContext() {
            return null;
        }
    }

    static class NoopContinuation
    implements AgentScope.Continuation {
        static final NoopContinuation INSTANCE = new NoopContinuation();

        NoopContinuation() {
        }

        public TraceScope activate() {
            return NoopAgentScope.INSTANCE;
        }

        public void cancel() {
        }

        @Override
        public void migrate() {
        }
    }

    static class NoopAgentPropagation
    implements AgentPropagation {
        static final NoopAgentPropagation INSTANCE = new NoopAgentPropagation();

        NoopAgentPropagation() {
        }

        @Override
        public AgentScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return NoopContext.INSTANCE;
        }
    }

    public static class NoopAgentScope
    implements AgentScope,
    TraceScope {
        public static final NoopAgentScope INSTANCE = new NoopAgentScope();

        @Override
        public AgentSpan span() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
        }

        @Override
        public boolean checkpointed() {
            return false;
        }

        public AgentScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        public AgentScope.Continuation captureConcurrent() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public void close() {
        }

        public boolean isAsyncPropagating() {
            return false;
        }
    }

    public static class NoopAgentSpan
    implements AgentSpan {
        public static final NoopAgentSpan INSTANCE = new NoopAgentSpan();

        @Override
        public DDId getTraceId() {
            return DDId.ZERO;
        }

        @Override
        public DDId getSpanId() {
            return DDId.ZERO;
        }

        @Override
        public AgentSpan setTag(String key, boolean value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String tag, Number value) {
            return this;
        }

        public boolean isError() {
            return false;
        }

        @Override
        public AgentSpan setTag(String key, int value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, long value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, double value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, Object value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, int value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, long value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, double value) {
            return this;
        }

        @Override
        public Object getTag(String key) {
            return null;
        }

        public long getStartTime() {
            return 0L;
        }

        public long getDurationNano() {
            return 0L;
        }

        public String getOperationName() {
            return null;
        }

        public AgentSpan setOperationName(CharSequence serviceName) {
            return this;
        }

        public String getServiceName() {
            return null;
        }

        public AgentSpan setServiceName(String serviceName) {
            return this;
        }

        public CharSequence getResourceName() {
            return null;
        }

        @Override
        public AgentSpan setResourceName(CharSequence resourceName) {
            return this;
        }

        @Override
        public boolean eligibleForDropping() {
            return true;
        }

        @Override
        public void startThreadMigration() {
        }

        @Override
        public void finishThreadMigration() {
        }

        @Override
        public void finishWork() {
        }

        @Override
        public RequestContext getRequestContext() {
            return null;
        }

        public Integer getSamplingPriority() {
            return -128;
        }

        public AgentSpan setSamplingPriority(int newPriority) {
            return this;
        }

        public String getSpanType() {
            return null;
        }

        @Override
        public AgentSpan setSpanType(CharSequence type) {
            return this;
        }

        @Override
        public Map<String, Object> getTags() {
            return Collections.emptyMap();
        }

        @Override
        public AgentSpan setTag(String key, String value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, CharSequence value) {
            return this;
        }

        @Override
        public AgentSpan setError(boolean error) {
            return this;
        }

        @Override
        public AgentSpan setMeasured(boolean measured) {
            return this;
        }

        public AgentSpan getRootSpan() {
            return this;
        }

        @Override
        public AgentSpan setErrorMessage(String errorMessage) {
            return this;
        }

        @Override
        public AgentSpan addThrowable(Throwable throwable) {
            return this;
        }

        @Override
        public AgentSpan setHttpStatusCode(int statusCode) {
            return this;
        }

        @Override
        public short getHttpStatusCode() {
            return 0;
        }

        @Override
        public AgentSpan getLocalRootSpan() {
            return this;
        }

        @Override
        public boolean isSameTrace(AgentSpan otherSpan) {
            return otherSpan instanceof NoopAgentSpan;
        }

        @Override
        public AgentSpan.Context context() {
            return NoopContext.INSTANCE;
        }

        @Override
        public String getBaggageItem(String key) {
            return null;
        }

        @Override
        public AgentSpan setBaggageItem(String key, String value) {
            return this;
        }

        @Override
        public void finish() {
        }

        @Override
        public void finish(long finishMicros) {
        }

        @Override
        public boolean phasedFinish() {
            return false;
        }

        @Override
        public void publish() {
        }

        @Override
        public String getSpanName() {
            return "";
        }

        @Override
        public void setSpanName(CharSequence spanName) {
        }

        @Override
        public boolean hasResourceName() {
            return false;
        }

        @Override
        public void setEmittingCheckpoints(boolean value) {
        }

        @Override
        public Boolean isEmittingCheckpoints() {
            return Boolean.FALSE;
        }

        @Override
        public boolean hasCheckpoints() {
            return false;
        }
    }

    static class NoopTracerAPI
    implements TracerAPI {
        protected NoopTracerAPI() {
        }

        @Override
        public AgentSpan startSpan(CharSequence spanName, boolean withCheckpoints) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(CharSequence spanName, long startTimeMicros, boolean withCheckpoints) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, boolean withCheckpoints) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, long startTimeMicros, boolean withCheckpoints) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public TraceScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public AgentSpan activeSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public TraceScope activeScope() {
            return null;
        }

        @Override
        public AgentPropagation propagate() {
            return NoopAgentPropagation.INSTANCE;
        }

        @Override
        public AgentSpan noopSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public SpanBuilder buildSpan(CharSequence spanName) {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        public String getTraceId() {
            return null;
        }

        public String getSpanId() {
            return null;
        }

        public boolean addTraceInterceptor(TraceInterceptor traceInterceptor) {
            return false;
        }

        public void addScopeListener(ScopeListener listener) {
        }

        @Override
        public void registerCheckpointer(Checkpointer checkpointer) {
        }

        @Override
        public TraceScope.Continuation capture() {
            return null;
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return null;
        }

        @Override
        public void checkpoint(AgentSpan span, int flags) {
        }

        @Override
        public void onStart(AgentSpan span) {
        }

        @Override
        public void onStartWork(AgentSpan span) {
        }

        @Override
        public void onFinishWork(AgentSpan span) {
        }

        @Override
        public void onStartThreadMigration(AgentSpan span) {
        }

        @Override
        public void onFinishThreadMigration(AgentSpan span) {
        }

        @Override
        public void onFinish(AgentSpan span) {
        }

        @Override
        public void onRootSpan(AgentSpan root, boolean published) {
        }

        @Override
        public InstrumentationGateway instrumentationGateway() {
            return null;
        }
    }

    public static interface SpanBuilder {
        public AgentSpan start();

        public SpanBuilder asChildOf(AgentSpan.Context var1);

        public SpanBuilder ignoreActiveSpan();

        public SpanBuilder withTag(String var1, String var2);

        public SpanBuilder withTag(String var1, boolean var2);

        public SpanBuilder withTag(String var1, Number var2);

        public SpanBuilder withTag(String var1, Object var2);

        public SpanBuilder withStartTimestamp(long var1);

        public SpanBuilder withServiceName(String var1);

        public SpanBuilder withResourceName(String var1);

        public SpanBuilder withErrorFlag();

        public SpanBuilder withSpanType(CharSequence var1);

        public SpanBuilder suppressCheckpoints();
    }

    public static interface TracerAPI
    extends Tracer,
    AgentPropagation,
    SpanCheckpointer {
        public AgentSpan startSpan(CharSequence var1, boolean var2);

        public AgentSpan startSpan(CharSequence var1, long var2, boolean var4);

        public AgentSpan startSpan(CharSequence var1, AgentSpan.Context var2, boolean var3);

        public AgentSpan startSpan(CharSequence var1, AgentSpan.Context var2, long var3, boolean var5);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2, boolean var3);

        public TraceScope.Continuation captureSpan(AgentSpan var1, ScopeSource var2);

        public AgentSpan activeSpan();

        public TraceScope activeScope();

        public AgentPropagation propagate();

        public AgentSpan noopSpan();

        public SpanBuilder buildSpan(CharSequence var1);

        public void close();

        public void flush();

        public void registerCheckpointer(Checkpointer var1);

        public InstrumentationGateway instrumentationGateway();
    }
}

