/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.Function;
import datadog.trace.api.PropagationStyle;
import datadog.trace.api.function.Supplier;
import datadog.trace.api.function.TriConsumer;
import datadog.trace.api.gateway.CallbackProvider;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.B3HttpCodec;
import datadog.trace.core.propagation.DatadogHttpCodec;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HaystackHttpCodec;
import datadog.trace.core.propagation.TagContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HttpCodec.class);
    static final String FORWARDED_KEY = "forwarded";
    static final String FORWARDED_PROTO_KEY = "x-forwarded-proto";
    static final String FORWARDED_HOST_KEY = "x-forwarded-host";
    static final String FORWARDED_FOR_KEY = "x-forwarded-for";
    static final String FORWARDED_PORT_KEY = "x-forwarded-port";

    public static Injector createInjector(Config config) {
        ArrayList<Injector> injectors = new ArrayList<Injector>();
        for (PropagationStyle style : config.getPropagationStylesToInject()) {
            if (style == PropagationStyle.DATADOG) {
                injectors.add(new DatadogHttpCodec.Injector());
                continue;
            }
            if (style == PropagationStyle.B3) {
                injectors.add(new B3HttpCodec.Injector());
                continue;
            }
            if (style == PropagationStyle.HAYSTACK) {
                injectors.add(new HaystackHttpCodec.Injector());
                continue;
            }
            log.debug("No implementation found to inject propagation style: {}", (Object)style);
        }
        return new CompoundInjector(injectors);
    }

    public static Extractor createExtractor(Config config, Map<String, String> taggedHeaders, CallbackProvider callbackProvider) {
        ArrayList<Extractor> extractors = new ArrayList<Extractor>();
        block5: for (PropagationStyle style : config.getPropagationStylesToExtract()) {
            switch (style) {
                case DATADOG: {
                    extractors.add(DatadogHttpCodec.newExtractor(taggedHeaders));
                    continue block5;
                }
                case HAYSTACK: {
                    extractors.add(HaystackHttpCodec.newExtractor(taggedHeaders));
                    continue block5;
                }
                case B3: {
                    extractors.add(B3HttpCodec.newExtractor(taggedHeaders));
                    continue block5;
                }
            }
            log.debug("No implementation found to extract propagation style: {}", (Object)style);
        }
        return new CompoundExtractor(extractors, callbackProvider);
    }

    static String encode(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to encode value - {}", (Object)value);
        }
        return encoded;
    }

    static String decode(String value) {
        String decoded = value;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to decode value - {}", (Object)value);
        }
        return decoded;
    }

    static String firstHeaderValue(String value) {
        if (value == null) {
            return null;
        }
        int firstComma = value.indexOf(44);
        return firstComma == -1 ? value : value.substring(0, firstComma).trim();
    }

    private static final class IGKeyClassifier
    implements AgentPropagation.KeyClassifier {
        private final RequestContext requestContext;
        private final TriConsumer<RequestContext, String, String> headerCallback;
        private final Function<RequestContext, Flow<Void>> doneCallback;

        private static IGKeyClassifier create(RequestContext requestContext, TriConsumer<RequestContext, String, String> headerCallback, Function<RequestContext, Flow<Void>> doneCallback) {
            if (null == requestContext || null == headerCallback) {
                return null;
            }
            return new IGKeyClassifier(requestContext, headerCallback, doneCallback);
        }

        private IGKeyClassifier(RequestContext requestContext, TriConsumer<RequestContext, String, String> headerCallback, Function<RequestContext, Flow<Void>> doneCallback) {
            this.requestContext = requestContext;
            this.headerCallback = headerCallback;
            this.doneCallback = doneCallback;
        }

        @Override
        public boolean accept(String key, String value) {
            this.headerCallback.accept(this.requestContext, key, value);
            return true;
        }

        public void done() {
            if (null != this.doneCallback) {
                this.doneCallback.apply(this.requestContext);
            }
        }
    }

    public static class CompoundExtractor
    implements Extractor {
        private final List<Extractor> extractors;
        private final CallbackProvider callbackProvider;

        public CompoundExtractor(List<Extractor> extractors, CallbackProvider callbackProvider) {
            this.extractors = extractors;
            this.callbackProvider = callbackProvider;
        }

        @Override
        public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            IGKeyClassifier igKeyClassifier;
            Supplier<Flow<RequestContext>> startedCB;
            TagContext context = null;
            RequestContext requestContext = null;
            if (null != this.callbackProvider && null != (startedCB = this.callbackProvider.getCallback(Events.REQUEST_STARTED)) && null != (igKeyClassifier = IGKeyClassifier.create(requestContext = startedCB.get().getResult(), this.callbackProvider.getCallback(Events.REQUEST_HEADER), this.callbackProvider.getCallback(Events.REQUEST_HEADER_DONE)))) {
                getter.forEachKey(carrier, igKeyClassifier);
                igKeyClassifier.done();
            }
            for (Extractor extractor : this.extractors) {
                context = extractor.extract(carrier, getter);
                if (!(context instanceof ExtractedContext)) continue;
                return context.withRequestContext(requestContext);
            }
            if (null != requestContext) {
                if (context == null) {
                    context = TagContext.empty();
                }
                return context.withRequestContext(requestContext);
            }
            return context;
        }
    }

    public static class CompoundInjector
    implements Injector {
        private final List<Injector> injectors;

        public CompoundInjector(List<Injector> injectors) {
            this.injectors = injectors;
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            for (Injector injector : this.injectors) {
                injector.inject(context, carrier, setter);
            }
        }
    }

    public static interface Extractor {
        public <C> TagContext extract(C var1, AgentPropagation.ContextVisitor<C> var2);
    }

    public static interface Injector {
        public <C> void inject(DDSpanContext var1, C var2, AgentPropagation.Setter<C> var3);
    }
}

