/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider;

import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigConverter {
    private static final Logger log = LoggerFactory.getLogger(ConfigConverter.class);
    private static final ValueOfLookup LOOKUP = new ValueOfLookup();

    ConfigConverter() {
    }

    static <T> T valueOf(String value, @Nonnull Class<T> tClass) {
        Objects.requireNonNull(tClass, "tClass is marked non-null but is null");
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        try {
            return (T)((MethodHandle)LOOKUP.get(tClass)).invoke(value);
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (Throwable e) {
            log.debug("Can't parse: ", e);
            throw new NumberFormatException(e.toString());
        }
    }

    @Nonnull
    static List<String> parseList(String str) {
        return ConfigConverter.parseList(str, ",");
    }

    @Nonnull
    @SuppressForbidden
    static List<String> parseList(String str, String separator) {
        if (str == null || str.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = str.split(separator, -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    @Nonnull
    static Map<String, String> parseMap(String str, String settingName) {
        if (str == null) {
            return Collections.emptyMap();
        }
        String trimmed = str.trim();
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ConfigConverter.loadMap(map, trimmed, settingName);
        return map;
    }

    @Nonnull
    static Map<String, String> parseOrderedMap(String str, String settingName) {
        if (str == null) {
            return Collections.emptyMap();
        }
        String trimmed = str.trim();
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ConfigConverter.loadMap(map, trimmed, settingName);
        return map;
    }

    private static void loadMap(Map<String, String> map, String str, String settingName) {
        boolean badFormat = false;
        int start = 0;
        int splitter = str.indexOf(58, start);
        while (splitter != -1 && !badFormat) {
            String key;
            int end;
            int nextSplitter = str.indexOf(58, splitter + 1);
            if (nextSplitter == -1) {
                end = str.length();
                int trailingDelimiter = str.indexOf(44, splitter + 1);
                if (trailingDelimiter == str.length() - 1) {
                    end = trailingDelimiter;
                }
            } else {
                int delimiter = str.indexOf(44, splitter + 1);
                if (delimiter == -1 && (delimiter = str.indexOf(32, splitter + 1)) == -1) {
                    badFormat = true;
                }
                if (delimiter > nextSplitter) {
                    badFormat = true;
                }
                end = delimiter;
            }
            if (badFormat || (badFormat = (key = str.substring(start, splitter).trim()).indexOf(44) != -1)) continue;
            String value = str.substring(splitter + 1, end).trim();
            if (!key.isEmpty() && !value.isEmpty()) {
                map.put(key, value);
            }
            splitter = nextSplitter;
            start = end + 1;
        }
        if (badFormat) {
            log.warn("Invalid config for {}: '{}'. Must match 'key1:value1,key2:value2' or 'key1:value1 key2:value2'.", (Object)settingName, (Object)str);
            map.clear();
        }
    }

    @Nonnull
    @SuppressForbidden
    static BitSet parseIntegerRangeSet(@Nonnull String str, String settingName) throws NumberFormatException {
        String[] tokens;
        if (!(str = str.replaceAll("\\s", "")).matches("\\d{3}(?:-\\d{3})?(?:,\\d{3}(?:-\\d{3})?)*")) {
            log.warn("Invalid config for {}: '{}'. Must be formatted like '400-403,405,410-499'.", (Object)settingName, (Object)str);
            throw new NumberFormatException();
        }
        int lastSeparator = Math.max(str.lastIndexOf(44), str.lastIndexOf(45));
        int maxValue = Integer.parseInt(str.substring(lastSeparator + 1));
        BitSet set = new BitSet(maxValue);
        for (String token : tokens = str.split(",", -1)) {
            int separator = token.indexOf(45);
            if (separator == -1) {
                set.set(Integer.parseInt(token));
                continue;
            }
            if (separator <= 0) continue;
            int left = Integer.parseInt(token.substring(0, separator));
            int right = Integer.parseInt(token.substring(separator + 1));
            int min = Math.min(left, right);
            int max = Math.max(left, right);
            set.set(min, max + 1);
        }
        return set;
    }

    private static class ValueOfLookup
    extends ClassValue<MethodHandle> {
        private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();

        private ValueOfLookup() {
        }

        @Override
        protected MethodHandle computeValue(Class<?> type) {
            try {
                return PUBLIC_LOOKUP.findStatic(type, "valueOf", MethodType.methodType(type, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                log.debug("Can't invoke or access 'valueOf': ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

