/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci.git;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public class GitUtils {
    private static final Pattern ORIGIN_PATTERN = Pattern.compile("origin/", 16);
    private static final Pattern REFS_HEADS_PATTERN = Pattern.compile("refs/heads/", 16);
    private static final Pattern REFS_TAGS_PATTERN = Pattern.compile("refs/tags/", 16);
    private static final Pattern TAGS_PATTERN = Pattern.compile("tags/", 16);

    public static String normalizeRef(String rawRef) {
        if (rawRef == null || rawRef.isEmpty()) {
            return null;
        }
        String ref = rawRef;
        if (ref.startsWith("origin")) {
            ref = ORIGIN_PATTERN.matcher(ref).replaceAll("");
        } else if (ref.startsWith("refs/heads")) {
            ref = REFS_HEADS_PATTERN.matcher(ref).replaceAll("");
        }
        if (ref.startsWith("refs/tags")) {
            return REFS_TAGS_PATTERN.matcher(ref).replaceAll("");
        }
        if (ref.startsWith("tags")) {
            return TAGS_PATTERN.matcher(ref).replaceAll("");
        }
        return ref;
    }

    public static String filterSensitiveInfo(String urlStr) {
        if (urlStr == null || urlStr.isEmpty()) {
            return null;
        }
        try {
            URI url = new URI(urlStr);
            String userInfo = url.getRawUserInfo();
            return Pattern.compile(userInfo + "@", 16).matcher(urlStr).replaceAll("");
        }
        catch (URISyntaxException ex) {
            return urlStr;
        }
    }
}

