/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.communication.ddagent.DDAgentFeaturesDiscovery;
import datadog.communication.ddagent.SharedCommunicationObjects;
import datadog.communication.monitor.DDAgentStatsDClientManager;
import datadog.communication.monitor.Monitoring;
import datadog.communication.monitor.Recording;
import datadog.trace.api.Checkpointer;
import datadog.trace.api.Config;
import datadog.trace.api.DDId;
import datadog.trace.api.IdGenerationStrategy;
import datadog.trace.api.PropagationStyle;
import datadog.trace.api.SamplingCheckpointer;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.gateway.InstrumentationGateway;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.common.metrics.MetricsAggregator;
import datadog.trace.common.metrics.MetricsAggregatorFactory;
import datadog.trace.common.sampling.PrioritySampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.WriterFactory;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import datadog.trace.core.DDSpan;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.DDTraceCoreInfo;
import datadog.trace.core.PendingTrace;
import datadog.trace.core.PendingTraceBuffer;
import datadog.trace.core.StatusLogger;
import datadog.trace.core.monitor.MonitoringImpl;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.scopemanager.ContinuableScopeManager;
import datadog.trace.core.taginterceptor.RuleFlags;
import datadog.trace.core.taginterceptor.TagInterceptor;
import datadog.trace.util.AgentTaskScheduler;
import datadog.trace.util.AgentThreadFactory;
import datadog.trace.util.CollectionUtils;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTracer
implements AgentTracer.TracerAPI {
    private static final Logger log = LoggerFactory.getLogger(CoreTracer.class);
    public static final BigInteger TRACE_ID_MAX = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
    private static final String LANG_STATSD_TAG = "lang";
    private static final String LANG_VERSION_STATSD_TAG = "lang_version";
    private static final String LANG_INTERPRETER_STATSD_TAG = "lang_interpreter";
    private static final String LANG_INTERPRETER_VENDOR_STATSD_TAG = "lang_interpreter_vendor";
    private static final String TRACER_VERSION_STATSD_TAG = "tracer_version";
    private final PendingTraceBuffer pendingTraceBuffer;
    final String serviceName;
    final Writer writer;
    final Sampler<DDSpan> sampler;
    final AgentScopeManager scopeManager;
    final MetricsAggregator metricsAggregator;
    private final Map<String, String> localRootSpanTags;
    private final Map<String, String> defaultSpanTags;
    private final Map<String, String> serviceNameMappings;
    private final int partialFlushMinSpans;
    private final StatsDClient statsDClient;
    private final Monitoring monitoring;
    private final Monitoring performanceMonitoring;
    private final Recording traceWriteTimer;
    private final IdGenerationStrategy idGenerationStrategy;
    private final PendingTrace.Factory pendingTraceFactory;
    private final SamplingCheckpointer checkpointer;
    private final Thread shutdownCallback;
    private final TagInterceptor tagInterceptor;
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(new Comparator<TraceInterceptor>(){

        @Override
        public int compare(TraceInterceptor o1, TraceInterceptor o2) {
            return Integer.compare(o1.priority(), o2.priority());
        }
    });
    private final HttpCodec.Injector injector;
    private final HttpCodec.Extractor extractor;
    private final InstrumentationGateway instrumentationGateway;

    public static CoreTracerBuilder builder() {
        return new CoreTracerBuilder();
    }

    @Override
    public TraceScope.Continuation capture() {
        TraceScope activeScope = this.activeScope();
        return activeScope == null ? null : activeScope.capture();
    }

    @Override
    public void checkpoint(AgentSpan span, int flags) {
        this.checkpointer.checkpoint(span, flags);
    }

    @Override
    public void onStart(AgentSpan span) {
        this.checkpointer.onStart(span);
    }

    @Override
    public void onStartWork(AgentSpan span) {
        this.checkpointer.onStartWork(span);
    }

    @Override
    public void onFinishWork(AgentSpan span) {
        this.checkpointer.onFinishWork(span);
    }

    @Override
    public void onStartThreadMigration(AgentSpan span) {
        this.checkpointer.onStartThreadMigration(span);
    }

    @Override
    public void onFinishThreadMigration(AgentSpan span) {
        this.checkpointer.onFinishThreadMigration(span);
    }

    @Override
    public void onFinish(AgentSpan span) {
        this.checkpointer.onFinish(span);
    }

    @Override
    public void onRootSpan(AgentSpan root, boolean published) {
        this.checkpointer.onRootSpan(root, published);
    }

    private CoreTracer(Config config, String serviceName, SharedCommunicationObjects sharedCommunicationObjects, Writer writer, IdGenerationStrategy idGenerationStrategy, Sampler<DDSpan> sampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, AgentScopeManager scopeManager, Map<String, String> localRootSpanTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, int partialFlushMinSpans, StatsDClient statsDClient, TagInterceptor tagInterceptor, boolean strictTraceWrites, InstrumentationGateway instrumentationGateway) {
        assert (localRootSpanTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        this.checkpointer = SamplingCheckpointer.create();
        this.serviceName = serviceName;
        this.sampler = sampler;
        this.injector = injector;
        this.extractor = extractor;
        this.localRootSpanTags = localRootSpanTags;
        this.defaultSpanTags = defaultSpanTags;
        this.serviceNameMappings = serviceNameMappings;
        this.partialFlushMinSpans = partialFlushMinSpans;
        IdGenerationStrategy idGenerationStrategy2 = this.idGenerationStrategy = null == idGenerationStrategy ? Config.get().getIdGenerationStrategy() : idGenerationStrategy;
        this.statsDClient = statsDClient != null ? statsDClient : (writer == null || writer instanceof DDAgentWriter ? CoreTracer.createStatsDClient(config) : StatsDClient.NO_OP);
        this.monitoring = config.isHealthMetricsEnabled() ? new MonitoringImpl(this.statsDClient, 10L, TimeUnit.SECONDS) : Monitoring.DISABLED;
        this.performanceMonitoring = config.isPerfMetricsEnabled() ? new MonitoringImpl(this.statsDClient, 10L, TimeUnit.SECONDS) : Monitoring.DISABLED;
        this.traceWriteTimer = this.performanceMonitoring.newThreadLocalTimer("trace.write");
        if (scopeManager == null) {
            ContinuableScopeManager csm = new ContinuableScopeManager(config.getScopeDepthLimit(), this.statsDClient, config.isScopeStrictMode(), config.isScopeInheritAsyncPropagation());
            this.scopeManager = csm;
        } else {
            this.scopeManager = scopeManager;
        }
        if (sharedCommunicationObjects == null) {
            sharedCommunicationObjects = new SharedCommunicationObjects();
        }
        sharedCommunicationObjects.monitoring = this.monitoring;
        if (writer == null) {
            sharedCommunicationObjects.createRemaining(config);
            this.writer = WriterFactory.createWriter(config, sharedCommunicationObjects, sampler, this.statsDClient);
        } else {
            this.writer = writer;
        }
        DDAgentFeaturesDiscovery discovery = sharedCommunicationObjects.featuresDiscovery(config);
        this.pendingTraceBuffer = strictTraceWrites ? PendingTraceBuffer.discarding() : PendingTraceBuffer.delaying();
        this.pendingTraceFactory = new PendingTrace.Factory(this, this.pendingTraceBuffer, strictTraceWrites);
        this.pendingTraceBuffer.start();
        this.writer.start();
        this.metricsAggregator = MetricsAggregatorFactory.createMetricsAggregator(config, discovery);
        AgentTaskScheduler.INSTANCE.scheduleWithJitter(new AgentTaskScheduler.Task<MetricsAggregator>(){

            @Override
            public void run(MetricsAggregator target) {
                target.start();
            }
        }, this.metricsAggregator, 1L, TimeUnit.SECONDS);
        this.tagInterceptor = null == tagInterceptor ? new TagInterceptor(new RuleFlags(config)) : tagInterceptor;
        this.instrumentationGateway = instrumentationGateway;
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        StatusLogger.logStatus(config);
    }

    protected void finalize() {
        try {
            this.shutdownCallback.run();
            Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            log.error("Error while finalizing DDTracer.", (Throwable)e);
        }
    }

    PendingTrace createTrace(DDId id) {
        return this.pendingTraceFactory.create(id);
    }

    public String mapServiceName(String serviceName) {
        String mapped = this.serviceNameMappings.get(serviceName);
        return null == mapped ? serviceName : mapped;
    }

    private void registerClassLoader(ClassLoader classLoader) {
        try {
            for (TraceInterceptor interceptor : ServiceLoader.load(TraceInterceptor.class, classLoader)) {
                this.addTraceInterceptor(interceptor);
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn("Problem loading TraceInterceptor for classLoader: " + classLoader, (Throwable)e);
        }
    }

    @Override
    public CoreSpanBuilder buildSpan(CharSequence operationName) {
        return new CoreSpanBuilder(operationName);
    }

    @Override
    public AgentSpan startSpan(CharSequence spanName, boolean emitCheckpoint) {
        AgentTracer.SpanBuilder builder = this.buildSpan(spanName);
        if (!emitCheckpoint) {
            builder = builder.suppressCheckpoints();
        }
        return builder.start();
    }

    @Override
    public AgentSpan startSpan(CharSequence spanName, long startTimeMicros, boolean emitCheckpoint) {
        AgentTracer.SpanBuilder builder = this.buildSpan(spanName).withStartTimestamp(startTimeMicros);
        if (!emitCheckpoint) {
            builder = builder.suppressCheckpoints();
        }
        return builder.start();
    }

    @Override
    public AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, boolean emitCheckpoint) {
        AgentTracer.SpanBuilder builder = this.buildSpan(spanName).ignoreActiveSpan().asChildOf(parent);
        if (!emitCheckpoint) {
            builder = builder.suppressCheckpoints();
        }
        return builder.start();
    }

    @Override
    public AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, long startTimeMicros, boolean emitCheckpoint) {
        AgentTracer.SpanBuilder builder = this.buildSpan(spanName).ignoreActiveSpan().asChildOf(parent).withStartTimestamp(startTimeMicros);
        if (!emitCheckpoint) {
            builder = builder.suppressCheckpoints();
        }
        return builder.start();
    }

    public AgentScope activateSpan(AgentSpan span) {
        return this.scopeManager.activate(span, ScopeSource.INSTRUMENTATION, true);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
        return this.scopeManager.activate(span, source);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.scopeManager.activate(span, source, isAsyncPropagating);
    }

    @Override
    public TraceScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
        return this.scopeManager.captureSpan(span, source);
    }

    public TagInterceptor getTagInterceptor() {
        return this.tagInterceptor;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    @Override
    public AgentSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    @Override
    public TraceScope activeScope() {
        return this.scopeManager.active();
    }

    @Override
    public AgentPropagation propagate() {
        return this;
    }

    @Override
    public AgentSpan noopSpan() {
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(span.context(), carrier, setter, null);
    }

    @Override
    public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(context, carrier, setter, null);
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, PropagationStyle style) {
        this.inject(span.context(), carrier, setter, style);
    }

    private <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter, PropagationStyle style) {
        if (!(context instanceof DDSpanContext)) {
            return;
        }
        DDSpanContext ddSpanContext = (DDSpanContext)context;
        DDSpan rootSpan = ddSpanContext.getTrace().getRootSpan();
        this.setSamplingPriorityIfNecessary(rootSpan);
        if (null == style) {
            this.injector.inject(ddSpanContext, carrier, setter);
        } else {
            HttpCodec.inject(ddSpanContext, carrier, setter, style);
        }
    }

    @Override
    public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        return this.extractor.extract(carrier, getter);
    }

    void write(List<DDSpan> trace) {
        if (trace.isEmpty()) {
            return;
        }
        List<DDSpan> writtenTrace = trace;
        if (!this.interceptors.isEmpty()) {
            Collection<DDSpan> interceptedTrace = new ArrayList<DDSpan>(trace);
            try {
                for (TraceInterceptor traceInterceptor : this.interceptors) {
                    interceptedTrace = traceInterceptor.onTraceComplete(interceptedTrace);
                }
            }
            catch (Exception e) {
                log.debug("Exception in TraceInterceptor", (Throwable)e);
                return;
            }
            writtenTrace = new ArrayList<DDSpan>(interceptedTrace.size());
            for (MutableSpan mutableSpan : interceptedTrace) {
                if (!(mutableSpan instanceof DDSpan)) continue;
                writtenTrace.add((DDSpan)mutableSpan);
            }
        }
        if (!writtenTrace.isEmpty()) {
            boolean published;
            boolean forceKeep = this.metricsAggregator.publish(writtenTrace);
            DDSpan rootSpan = writtenTrace.get(0).getLocalRootSpan();
            this.setSamplingPriorityIfNecessary(rootSpan);
            DDSpan dDSpan = rootSpan == null ? writtenTrace.get(0) : rootSpan;
            dDSpan.forceKeep(forceKeep);
            boolean bl = published = forceKeep || this.sampler.sample(dDSpan);
            if (published) {
                this.writer.write(writtenTrace);
            } else {
                this.writer.incrementDropCounts(writtenTrace.size());
            }
            if (null != rootSpan) {
                this.onRootSpan(rootSpan, published);
            }
        }
    }

    void setSamplingPriorityIfNecessary(DDSpan rootSpan) {
        if (this.sampler instanceof PrioritySampler && rootSpan != null && rootSpan.context().getSamplingPriority() == -128) {
            ((PrioritySampler)((Object)this.sampler)).setSamplingPriority(rootSpan);
        }
    }

    public String getTraceId() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return activeSpan.getTraceId().toString();
        }
        return "0";
    }

    public String getSpanId() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getSpanId().toString();
        }
        return "0";
    }

    public boolean addTraceInterceptor(TraceInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    public void addScopeListener(ScopeListener listener) {
        if (this.scopeManager instanceof ContinuableScopeManager) {
            ((ContinuableScopeManager)this.scopeManager).addScopeListener(listener);
        }
    }

    @Override
    public void registerCheckpointer(Checkpointer checkpointer) {
        this.checkpointer.register(checkpointer);
    }

    @Override
    public InstrumentationGateway instrumentationGateway() {
        return this.instrumentationGateway;
    }

    @Override
    public void close() {
        this.pendingTraceBuffer.close();
        this.writer.close();
        this.statsDClient.close();
        this.metricsAggregator.close();
    }

    @Override
    public void flush() {
        this.pendingTraceBuffer.flush();
        this.writer.flush();
    }

    private static StatsDClient createStatsDClient(Config config) {
        Integer port;
        if (!config.isHealthMetricsEnabled()) {
            return StatsDClient.NO_OP;
        }
        String host = config.getHealthMetricsStatsdHost();
        if (host == null) {
            host = config.getJmxFetchStatsdHost();
        }
        if ((port = config.getHealthMetricsStatsdPort()) == null) {
            port = config.getJmxFetchStatsdPort();
        }
        return DDAgentStatsDClientManager.statsDClientManager().statsDClient(host, port, "datadog.tracer", CoreTracer.generateConstantTags(config));
    }

    private static String[] generateConstantTags(Config config) {
        String env;
        ArrayList<String> constantTags = new ArrayList<String>();
        constantTags.add(CoreTracer.statsdTag(LANG_STATSD_TAG, "java"));
        constantTags.add(CoreTracer.statsdTag(LANG_VERSION_STATSD_TAG, DDTraceCoreInfo.JAVA_VERSION));
        constantTags.add(CoreTracer.statsdTag(LANG_INTERPRETER_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_NAME));
        constantTags.add(CoreTracer.statsdTag(LANG_INTERPRETER_VENDOR_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_VENDOR));
        constantTags.add(CoreTracer.statsdTag(TRACER_VERSION_STATSD_TAG, DDTraceCoreInfo.VERSION));
        constantTags.add(CoreTracer.statsdTag("service", config.getServiceName()));
        Map<String, String> mergedSpanTags = config.getMergedSpanTags();
        String version = mergedSpanTags.get("version");
        if (version != null && !version.isEmpty()) {
            constantTags.add(CoreTracer.statsdTag("version", version));
        }
        if ((env = mergedSpanTags.get("env")) != null && !env.isEmpty()) {
            constantTags.add(CoreTracer.statsdTag("env", env));
        }
        return constantTags.toArray(new String[0]);
    }

    Recording writeTimer() {
        return this.traceWriteTimer.start();
    }

    private static String statsdTag(String tagPrefix, String tagValue) {
        return tagPrefix + ":" + tagValue;
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<CoreTracer> reference;

        private ShutdownHook(CoreTracer tracer) {
            super(AgentThreadFactory.AGENT_THREAD_GROUP, "dd-tracer-shutdown-hook");
            this.reference = new WeakReference<CoreTracer>(tracer);
        }

        @Override
        public void run() {
            CoreTracer tracer = (CoreTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    public class CoreSpanBuilder
    implements AgentTracer.SpanBuilder {
        private final CharSequence operationName;
        private Map<String, Object> tags;
        private long timestampMicro;
        private Object parent;
        private String serviceName;
        private String resourceName;
        private boolean errorFlag;
        private CharSequence spanType;
        private boolean ignoreScope = false;
        private boolean emitCheckpoints = true;

        public CoreSpanBuilder(CharSequence operationName) {
            this.operationName = operationName;
        }

        @Override
        public CoreSpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private DDSpan buildSpan() {
            return DDSpan.create(this.timestampMicro, this.buildSpanContext(), this.emitCheckpoints);
        }

        @Override
        public AgentSpan start() {
            return this.buildSpan();
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        @Override
        public CoreSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)string);
        }

        @Override
        public CoreSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        @Override
        public CoreSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        @Override
        public CoreSpanBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        @Override
        public CoreSpanBuilder withSpanType(CharSequence spanType) {
            this.spanType = spanType;
            return this;
        }

        @Override
        public AgentTracer.SpanBuilder suppressCheckpoints() {
            this.emitCheckpoints = false;
            return this;
        }

        @Override
        public CoreSpanBuilder asChildOf(AgentSpan.Context spanContext) {
            this.parent = spanContext;
            return this;
        }

        public CoreSpanBuilder asChildOf(AgentSpan agentSpan) {
            this.parent = agentSpan.context();
            return this;
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Object value) {
            Map<String, Object> tagMap = this.tags;
            if (tagMap == null) {
                this.tags = tagMap = new LinkedHashMap<String, Object>();
            }
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                tagMap.remove(tag);
            } else {
                tagMap.put(tag, value);
            }
            return this;
        }

        private DDSpanContext buildSpanContext() {
            Object requestContextData;
            Map rootSpanTags;
            Map<String, String> coreTags;
            String origin;
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            DDId parentSpanId;
            DDId traceId;
            AgentSpan activeSpan;
            DDId spanId = CoreTracer.this.idGenerationStrategy.generate();
            Object parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (activeSpan = CoreTracer.this.scopeManager.activeSpan()) != null) {
                parentContext = activeSpan.context();
            }
            String parentServiceName = null;
            if (parentContext instanceof DDSpanContext) {
                RequestContext<Object> requestContext;
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                parentTrace = ddsc.getTrace();
                samplingPriority = -128;
                origin = null;
                coreTags = null;
                rootSpanTags = null;
                parentServiceName = ddsc.getServiceName();
                if (this.serviceName == null) {
                    this.serviceName = parentServiceName;
                }
                requestContextData = null == (requestContext = ddsc.getRequestContext()) ? null : requestContext.getData();
            } else {
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    baggage = extractedContext.getBaggage();
                } else {
                    traceId = IdGenerationStrategy.RANDOM.generate();
                    parentSpanId = DDId.ZERO;
                    samplingPriority = -128;
                    baggage = null;
                }
                if (parentContext instanceof TagContext) {
                    TagContext tc = (TagContext)parentContext;
                    coreTags = tc.getTags();
                    origin = tc.getOrigin();
                    requestContextData = tc.getRequestContextData();
                } else {
                    coreTags = null;
                    origin = null;
                    requestContextData = null;
                }
                rootSpanTags = CoreTracer.this.localRootSpanTags;
                parentTrace = CoreTracer.this.createTrace(traceId);
            }
            if (this.serviceName == null) {
                this.serviceName = CoreTracer.this.serviceName;
            }
            CharSequence operationName = this.operationName != null ? this.operationName : this.resourceName;
            int tagsSize = (null == this.tags ? 0 : this.tags.size()) + CoreTracer.this.defaultSpanTags.size() + (null == coreTags ? 0 : coreTags.size()) + (null == rootSpanTags ? 0 : rootSpanTags.size());
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, parentServiceName, this.serviceName, operationName, this.resourceName, samplingPriority, origin, baggage, this.errorFlag, this.spanType, tagsSize, parentTrace, requestContextData);
            context.setAllTags(CoreTracer.this.defaultSpanTags);
            context.setAllTags(this.tags);
            context.setAllTags(coreTags);
            context.setAllTags(rootSpanTags);
            return context;
        }
    }

    public static class CoreTracerBuilder {
        private Config config;
        private String serviceName;
        private SharedCommunicationObjects sharedCommunicationObjects;
        private Writer writer;
        private IdGenerationStrategy idGenerationStrategy;
        private Sampler<DDSpan> sampler;
        private HttpCodec.Injector injector;
        private HttpCodec.Extractor extractor;
        private AgentScopeManager scopeManager;
        private Map<String, String> localRootSpanTags;
        private Map<String, String> defaultSpanTags;
        private Map<String, String> serviceNameMappings;
        private Map<String, String> taggedHeaders;
        private int partialFlushMinSpans;
        private StatsDClient statsDClient;
        private TagInterceptor tagInterceptor;
        private boolean strictTraceWrites;
        private InstrumentationGateway instrumentationGateway;

        public CoreTracerBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public CoreTracerBuilder sharedCommunicationObjects(SharedCommunicationObjects sharedCommunicationObjects) {
            this.sharedCommunicationObjects = sharedCommunicationObjects;
            return this;
        }

        public CoreTracerBuilder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public CoreTracerBuilder idGenerationStrategy(IdGenerationStrategy idGenerationStrategy) {
            this.idGenerationStrategy = idGenerationStrategy;
            return this;
        }

        public CoreTracerBuilder sampler(Sampler<DDSpan> sampler) {
            this.sampler = sampler;
            return this;
        }

        public CoreTracerBuilder injector(HttpCodec.Injector injector) {
            this.injector = injector;
            return this;
        }

        public CoreTracerBuilder extractor(HttpCodec.Extractor extractor) {
            this.extractor = extractor;
            return this;
        }

        public CoreTracerBuilder scopeManager(AgentScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public CoreTracerBuilder localRootSpanTags(Map<String, String> localRootSpanTags) {
            this.localRootSpanTags = CollectionUtils.tryMakeImmutableMap(localRootSpanTags);
            return this;
        }

        public CoreTracerBuilder defaultSpanTags(Map<String, String> defaultSpanTags) {
            this.defaultSpanTags = CollectionUtils.tryMakeImmutableMap(defaultSpanTags);
            return this;
        }

        public CoreTracerBuilder serviceNameMappings(Map<String, String> serviceNameMappings) {
            this.serviceNameMappings = CollectionUtils.tryMakeImmutableMap(serviceNameMappings);
            return this;
        }

        public CoreTracerBuilder taggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = CollectionUtils.tryMakeImmutableMap(taggedHeaders);
            return this;
        }

        public CoreTracerBuilder partialFlushMinSpans(int partialFlushMinSpans) {
            this.partialFlushMinSpans = partialFlushMinSpans;
            return this;
        }

        public CoreTracerBuilder statsDClient(StatsDClient statsDClient) {
            this.statsDClient = statsDClient;
            return this;
        }

        public CoreTracerBuilder tagInterceptor(TagInterceptor tagInterceptor) {
            this.tagInterceptor = tagInterceptor;
            return this;
        }

        public CoreTracerBuilder statsDClient(TagInterceptor tagInterceptor) {
            this.tagInterceptor = tagInterceptor;
            return this;
        }

        public CoreTracerBuilder strictTraceWrites(boolean strictTraceWrites) {
            this.strictTraceWrites = strictTraceWrites;
            return this;
        }

        public CoreTracerBuilder instrumentationGateway(InstrumentationGateway instrumentationGateway) {
            this.instrumentationGateway = instrumentationGateway;
            return this;
        }

        public CoreTracerBuilder() {
            this.config(Config.get());
        }

        public CoreTracerBuilder withProperties(Properties properties) {
            return this.config(Config.get(properties));
        }

        public CoreTracerBuilder config(Config config) {
            this.config = config;
            this.serviceName(config.getServiceName());
            this.sampler(Sampler.Builder.forConfig(config));
            this.instrumentationGateway(new InstrumentationGateway());
            this.injector(HttpCodec.createInjector(config));
            this.extractor(HttpCodec.createExtractor(config, config.getHeaderTags()));
            this.localRootSpanTags(config.getLocalRootSpanTags());
            this.defaultSpanTags(config.getMergedSpanTags());
            this.serviceNameMappings(config.getServiceMapping());
            this.taggedHeaders(config.getHeaderTags());
            this.partialFlushMinSpans(config.getPartialFlushMinSpans());
            this.strictTraceWrites(config.isTraceStrictWritesEnabled());
            return this;
        }

        public CoreTracer build() {
            return new CoreTracer(this.config, this.serviceName, this.sharedCommunicationObjects, this.writer, this.idGenerationStrategy, this.sampler, this.injector, this.extractor, this.scopeManager, this.localRootSpanTags, this.defaultSpanTags, this.serviceNameMappings, this.taggedHeaders, this.partialFlushMinSpans, this.statsDClient, this.tagInterceptor, this.strictTraceWrites, this.instrumentationGateway);
        }
    }
}

