/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import java.util.concurrent.ThreadFactory;
import org.slf4j.LoggerFactory;

public final class AgentThreadFactory
implements ThreadFactory {
    public static final ThreadGroup AGENT_THREAD_GROUP = new ThreadGroup("dd-trace-java");
    public static final long THREAD_JOIN_TIMOUT_MS = 800L;
    private final AgentThread agentThread;

    public AgentThreadFactory(AgentThread agentThread) {
        this.agentThread = agentThread;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return AgentThreadFactory.newAgentThread(this.agentThread, runnable);
    }

    public static Thread newAgentThread(final AgentThread agentThread, final Runnable runnable) {
        Thread thread = new Thread(AGENT_THREAD_GROUP, runnable, agentThread.threadName);
        thread.setDaemon(true);
        thread.setContextClassLoader(null);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable e) {
                LoggerFactory.getLogger(runnable.getClass()).error("Uncaught exception in {}", (Object)agentThread.threadName, (Object)e);
            }
        });
        return thread;
    }

    public static enum AgentThread {
        TASK_SCHEDULER("dd-task-scheduler"),
        TRACE_STARTUP("dd-agent-startup-datadog-tracer"),
        TRACE_MONITOR("dd-trace-monitor"),
        TRACE_PROCESSOR("dd-trace-processor"),
        TRACE_CASSANDRA_ASYNC_SESSION("dd-cassandra-session-executor"),
        METRICS_AGGREGATOR("dd-metrics-aggregator"),
        STATSD_CLIENT("dd-statsd-client"),
        JMX_STARTUP("dd-agent-startup-jmxfetch"),
        JMX_COLLECTOR("dd-jmx-collector"),
        PROFILER_STARTUP("dd-agent-startup-datadog-profiler"),
        PROFILER_RECORDING_SCHEDULER("dd-profiler-recording-scheduler"),
        PROFILER_HTTP_DISPATCHER("dd-profiler-http-dispatcher"),
        APPSEC_HTTP_DISPATCHER("dd-appsec-http-dispatcher"),
        FLEET_MANAGEMENT_POLLER("dd-fleet-management-poller"),
        CWS_TLS("dd-cws-tls");

        public final String threadName;

        private AgentThread(String threadName) {
            this.threadName = threadName;
        }
    }
}

