/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import datadog.opentracing.DDTracer;
import datadog.opentracing.PendingTrace;
import datadog.opentracing.decorators.AbstractDecorator;
import io.opentracing.SpanContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpanContext
implements SpanContext {
    private static final Logger log = LoggerFactory.getLogger(DDSpanContext.class);
    private final DDTracer tracer;
    private final PendingTrace trace;
    private final Map<String, String> baggageItems;
    private final long traceId;
    private final long spanId;
    private final long parentId;
    private final Map<String, Object> tags = new ConcurrentHashMap<String, Object>();
    private volatile String serviceName;
    private volatile String resourceName;
    private volatile String operationName;
    private volatile String spanType;
    private volatile boolean errorFlag;
    private volatile int samplingPriority = Integer.MIN_VALUE;
    private volatile boolean samplingPriorityLocked = false;
    private final String threadName = Thread.currentThread().getName();
    private final long threadId = Thread.currentThread().getId();

    public DDSpanContext(long traceId, long spanId, long parentId, String serviceName, String operationName, String resourceName, int samplingPriority, Map<String, String> baggageItems, boolean errorFlag, String spanType, Map<String, Object> tags, PendingTrace trace, DDTracer tracer) {
        assert (tracer != null);
        assert (trace != null);
        this.tracer = tracer;
        this.trace = trace;
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.baggageItems = baggageItems == null ? new ConcurrentHashMap<String, String>(0) : baggageItems;
        if (tags != null) {
            this.tags.putAll(tags);
        }
        this.serviceName = serviceName;
        this.operationName = operationName;
        this.resourceName = resourceName;
        this.samplingPriority = samplingPriority;
        this.errorFlag = errorFlag;
        this.spanType = spanType;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getResourceName() {
        return this.resourceName == null || this.resourceName.isEmpty() ? this.operationName : this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public String getSpanType() {
        return this.spanType;
    }

    public void setSpanType(String spanType) {
        this.spanType = spanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamplingPriority(int newPriority) {
        if (this.samplingPriorityLocked) {
            log.debug("samplingPriority locked at {}. Refusing to set to {}", (Object)this.samplingPriority, (Object)newPriority);
        } else {
            DDSpanContext dDSpanContext = this;
            synchronized (dDSpanContext) {
                this.samplingPriority = newPriority;
            }
        }
    }

    public int getSamplingPriority() {
        return this.samplingPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockSamplingPriority() {
        if (!this.samplingPriorityLocked) {
            DDSpanContext dDSpanContext = this;
            synchronized (dDSpanContext) {
                if (this.samplingPriority == Integer.MIN_VALUE) {
                    log.debug("{} : refusing to lock unset samplingPriority", (Object)this);
                } else {
                    this.samplingPriorityLocked = true;
                    log.debug("{} : locked samplingPriority to {}", (Object)this, (Object)this.samplingPriority);
                }
            }
        }
        return this.samplingPriorityLocked;
    }

    public void setBaggageItem(String key, String value) {
        this.baggageItems.put(key, value);
    }

    public String getBaggageItem(String key) {
        return this.baggageItems.get(key);
    }

    public Map<String, String> getBaggageItems() {
        return this.baggageItems;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggageItems.entrySet();
    }

    @JsonIgnore
    public PendingTrace getTrace() {
        return this.trace;
    }

    @JsonIgnore
    public DDTracer getTracer() {
        return this.tracer;
    }

    public synchronized void setTag(String tag, Object value) {
        if (value == null) {
            this.tags.remove(tag);
            return;
        }
        boolean addTag = true;
        List<AbstractDecorator> decorators = this.tracer.getSpanContextDecorators(tag);
        if (decorators != null) {
            for (AbstractDecorator decorator : decorators) {
                try {
                    addTag &= decorator.shouldSetTag(this, tag, value);
                }
                catch (Throwable ex) {
                    log.debug("Could not decorate the span decorator={}: {}", (Object)decorator.getClass().getSimpleName(), (Object)ex.getMessage());
                }
            }
        }
        if (addTag) {
            this.tags.put(tag, value);
        }
    }

    public synchronized Map<String, Object> getTags() {
        this.tags.put("thread.name", this.threadName);
        this.tags.put("thread.id", this.threadId);
        String spanType = this.getSpanType();
        if (spanType != null) {
            this.tags.put("span.type", spanType);
        }
        return Collections.unmodifiableMap(this.tags);
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("Span [ t_id=").append(this.traceId).append(", s_id=").append(this.spanId).append(", p_id=").append(this.parentId).append("] trace=").append(this.getServiceName()).append("/").append(this.getOperationName()).append("/").append(this.getResourceName());
        if (this.getSamplingPriority() != Integer.MIN_VALUE) {
            s.append(" samplingPriority=").append(this.getSamplingPriority());
        }
        if (this.errorFlag) {
            s.append(" *errored*");
        }
        if (this.tags != null) {
            s.append(" tags=").append(new TreeMap<String, Object>(this.tags));
        }
        return s.toString();
    }
}

