/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExtractedContext
extends TagContext {
    private final DDId traceId;
    private final DDId spanId;
    private final int samplingPriority;
    private final Map<String, String> baggage;
    private final AtomicBoolean samplingPriorityLocked = new AtomicBoolean(false);

    public ExtractedContext(DDId traceId, DDId spanId, int samplingPriority, String origin, String forwarded, String forwardedProto, String forwardedHost, String forwardedIp, String forwardedPort, Map<String, String> baggage, Map<String, String> tags) {
        super(origin, forwarded, forwardedProto, forwardedHost, forwardedIp, forwardedPort, tags);
        this.traceId = traceId;
        this.spanId = spanId;
        this.samplingPriority = samplingPriority;
        this.baggage = baggage;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public void lockSamplingPriority() {
        this.samplingPriorityLocked.set(true);
    }

    @Override
    public DDId getTraceId() {
        return this.traceId;
    }

    @Override
    public DDId getSpanId() {
        return this.spanId;
    }

    public int getSamplingPriority() {
        return this.samplingPriority;
    }

    public Map<String, String> getBaggage() {
        return this.baggage;
    }

    public boolean getSamplingPriorityLocked() {
        return this.samplingPriorityLocked.get();
    }
}

