/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.LogHandler;
import datadog.opentracing.OTScopeManager;
import datadog.opentracing.OTSpan;
import datadog.opentracing.OTSpanContext;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;

class TypeConverter {
    private final LogHandler logHandler;

    public TypeConverter(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public AgentSpan toAgentSpan(Span span) {
        if (span == null) {
            return null;
        }
        if (span instanceof OTSpan) {
            return ((OTSpan)span).getDelegate();
        }
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    public OTSpan toSpan(AgentSpan agentSpan) {
        if (agentSpan == null) {
            return null;
        }
        return new OTSpan(agentSpan, this, this.logHandler);
    }

    public AgentScope toAgentScope(Scope scope) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof OTScopeManager.OTScope) {
            OTScopeManager.OTScope wrapper = (OTScopeManager.OTScope)scope;
            if (wrapper.finishSpanOnClose()) {
                return new FinishingScope(wrapper.unwrap());
            }
            return wrapper.unwrap();
        }
        return new CustomScope(scope);
    }

    public Scope toScope(AgentScope scope, boolean finishSpanOnClose) {
        if (scope == null) {
            return null;
        }
        return new OTScopeManager.OTScope(scope, finishSpanOnClose, this);
    }

    public SpanContext toSpanContext(AgentSpan.Context context) {
        if (context == null) {
            return null;
        }
        return new OTSpanContext(context);
    }

    public AgentSpan.Context toContext(SpanContext spanContext) {
        if (spanContext == null) {
            return null;
        }
        if (spanContext instanceof OTSpanContext) {
            return ((OTSpanContext)spanContext).getDelegate();
        }
        return AgentTracer.NoopContext.INSTANCE;
    }

    final class CustomScope
    implements AgentScope {
        private final Scope delegate;

        private CustomScope(Scope delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public AgentSpan span() {
            return TypeConverter.this.toAgentSpan(this.delegate.span());
        }

        @Override
        public byte source() {
            return ScopeSource.MANUAL.id();
        }

        @Override
        public AgentScope.Continuation capture() {
            return null;
        }

        @Override
        public AgentScope.Continuation captureConcurrent() {
            return null;
        }

        @Override
        public boolean checkpointed() {
            return false;
        }

        public boolean isAsyncPropagating() {
            return false;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CustomScope) {
                return this.delegate.equals(((CustomScope)o).delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    static final class FinishingScope
    implements AgentScope {
        private final AgentScope delegate;

        private FinishingScope(AgentScope delegate) {
            this.delegate = delegate;
        }

        @Override
        public AgentSpan span() {
            return this.delegate.span();
        }

        @Override
        public byte source() {
            return this.delegate.source();
        }

        @Override
        public void close() {
            this.delegate.close();
            this.delegate.span().finish();
        }

        @Override
        public AgentScope.Continuation capture() {
            return this.delegate.capture();
        }

        @Override
        public AgentScope.Continuation captureConcurrent() {
            return this.delegate.captureConcurrent();
        }

        @Override
        public boolean checkpointed() {
            return this.delegate.checkpointed();
        }

        public boolean isAsyncPropagating() {
            return this.delegate.isAsyncPropagating();
        }

        @Override
        public void setAsyncPropagation(boolean value) {
            this.delegate.setAsyncPropagation(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FinishingScope) {
                return this.delegate.equals(((FinishingScope)o).delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

