/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import datadog.trace.api.Config;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.scopemanager.ExtendedScopeListener;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.context.ScopeListener;
import datadog.trace.util.AgentTaskScheduler;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContinuableScopeManager
implements AgentScopeManager {
    static final Logger log = LoggerFactory.getLogger(ContinuableScopeManager.class);
    final ThreadLocal<ScopeStack> tlsScopeStack = new ThreadLocal<ScopeStack>(){

        @Override
        protected final ScopeStack initialValue() {
            return new ScopeStack();
        }
    };
    static final long iterationKeepAlive = TimeUnit.SECONDS.toMillis(Config.get().getScopeIterationKeepAlive());
    volatile ConcurrentMap<ScopeStack, ContinuableScope> rootIterationScopes;
    final List<ScopeListener> scopeListeners;
    final List<ExtendedScopeListener> extendedScopeListeners;
    final StatsDClient statsDClient;
    private final int depthLimit;
    private final boolean strictMode;
    private final boolean inheritAsyncPropagation;

    public ContinuableScopeManager(int depthLimit, StatsDClient statsDClient, boolean strictMode, boolean inheritAsyncPropagation) {
        this.depthLimit = depthLimit == 0 ? Integer.MAX_VALUE : depthLimit;
        this.statsDClient = statsDClient;
        this.strictMode = strictMode;
        this.inheritAsyncPropagation = inheritAsyncPropagation;
        this.scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
        this.extendedScopeListeners = new CopyOnWriteArrayList<ExtendedScopeListener>();
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source) {
        return this.activate(span, source.id(), false, false);
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.activate(span, source.id(), true, isAsyncPropagating);
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
        SingleContinuation continuation = new SingleContinuation(this, span, source.id());
        continuation.register();
        return continuation;
    }

    private AgentScope activate(AgentSpan span, byte source, boolean overrideAsyncPropagation, boolean isAsyncPropagating) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.span.equals(span)) {
            top.incrementReferences();
            return top;
        }
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        assert (span != null);
        boolean asyncPropagation = overrideAsyncPropagation ? isAsyncPropagating : (this.inheritAsyncPropagation && top != null ? top.isAsyncPropagating() : true);
        ContinuableScope scope = new ContinuableScope(this, span, source, asyncPropagation);
        scopeStack.push(scope);
        return scope;
    }

    ContinuableScope continueSpan(Continuation continuation, AgentSpan span, byte source) {
        ContinuableScope scope = continuation != null ? new ContinuingScope(this, span, source, true, continuation) : new ContinuableScope(this, span, source, true);
        this.scopeStack().push(scope);
        return scope;
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.source() == ScopeSource.ITERATION.id()) {
            if (iterationKeepAlive > 0L) {
                this.cancelRootIterationScopeCleanup(scopeStack, top);
            }
            top.close();
            scopeStack.cleanup();
            if (finishSpan) {
                top.span.finish();
            }
        }
    }

    @Override
    public AgentScope activateNext(AgentSpan span) {
        ScopeStack scopeStack = this.scopeStack();
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        assert (span != null);
        ContinuableScope top = scopeStack.top;
        boolean asyncPropagation = this.inheritAsyncPropagation && top != null ? top.isAsyncPropagating() : true;
        ContinuableScope scope = new ContinuableScope(this, span, ScopeSource.ITERATION.id(), asyncPropagation);
        if (iterationKeepAlive > 0L && currentDepth == 0) {
            this.scheduleRootIterationScopeCleanup(scopeStack, scope);
        }
        scopeStack.push(scope);
        return scope;
    }

    @Override
    public AgentScope active() {
        return this.scopeStack().active();
    }

    @Override
    public AgentSpan activeSpan() {
        ContinuableScope active = this.scopeStack().active();
        return active == null ? null : active.span;
    }

    public void addScopeListener(ScopeListener listener) {
        if (listener instanceof ExtendedScopeListener) {
            this.addExtendedScopeListener((ExtendedScopeListener)listener);
        } else {
            this.scopeListeners.add(listener);
            log.debug("Added scope listener {}", (Object)listener);
            AgentSpan activeSpan = this.activeSpan();
            if (activeSpan != null) {
                listener.afterScopeActivated();
            }
        }
    }

    private void addExtendedScopeListener(ExtendedScopeListener listener) {
        this.extendedScopeListeners.add(listener);
        log.debug("Added scope listener {}", (Object)listener);
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan != null && !(activeSpan instanceof AgentTracer.NoopAgentSpan)) {
            listener.afterScopeActivated(activeSpan.getTraceId(), activeSpan.context().getSpanId());
        }
    }

    ScopeStack scopeStack() {
        return this.tlsScopeStack.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes == null) {
            ContinuableScopeManager continuableScopeManager = this;
            synchronized (continuableScopeManager) {
                if (this.rootIterationScopes == null) {
                    this.rootIterationScopes = new ConcurrentHashMap<ScopeStack, ContinuableScope>();
                    RootIterationCleaner.scheduleFor(this.rootIterationScopes);
                }
            }
        }
        this.rootIterationScopes.put(scopeStack, scope);
    }

    private void cancelRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes != null) {
            this.rootIterationScopes.remove(scopeStack, scope);
        }
    }

    private static final class RootIterationCleaner
    implements AgentTaskScheduler.Task<Map<ScopeStack, ContinuableScope>> {
        private static final RootIterationCleaner CLEANER = new RootIterationCleaner();

        private RootIterationCleaner() {
        }

        public static void scheduleFor(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            long period = Math.min(iterationKeepAlive, 10000L);
            AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(CLEANER, rootIterationScopes, iterationKeepAlive, period, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            Iterator<Map.Entry<ScopeStack, ContinuableScope>> itr = rootIterationScopes.entrySet().iterator();
            long cutOff = System.currentTimeMillis() - iterationKeepAlive;
            while (itr.hasNext()) {
                Map.Entry<ScopeStack, ContinuableScope> entry = itr.next();
                ScopeStack scopeStack = entry.getKey();
                ContinuableScope rootScope = entry.getValue();
                if (!rootScope.alive()) {
                    itr.remove();
                    continue;
                }
                if (TimeUnit.NANOSECONDS.toMillis(rootScope.span.getStartTime()) >= cutOff) continue;
                scopeStack.overdueRootScope = rootScope;
                rootScope.span.finish();
                itr.remove();
            }
        }
    }

    private static final class ConcurrentContinuation
    extends Continuation {
        private static final int START = 1;
        private static final int CLOSED = -1073741824;
        private static final int BARRIER = -536870912;
        private volatile int count = 1;
        private static final AtomicIntegerFieldUpdater<ConcurrentContinuation> COUNT = AtomicIntegerFieldUpdater.newUpdater(ConcurrentContinuation.class, "count");

        private ConcurrentContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            super(scopeManager, spanUnderScope, source);
            spanUnderScope.startThreadMigration();
        }

        private boolean tryActivate() {
            int current = COUNT.incrementAndGet(this);
            if (current < 1) {
                COUNT.decrementAndGet(this);
            }
            return current > 1;
        }

        private boolean tryClose() {
            int current = COUNT.get(this);
            if (current < -536870912) {
                return false;
            }
            current = COUNT.decrementAndGet(this);
            while (current < 1 && current > -536870912) {
                if (COUNT.compareAndSet(this, current, -1073741824)) {
                    return true;
                }
                current = COUNT.get(this);
            }
            return false;
        }

        @Override
        public AgentScope activate() {
            if (this.tryActivate()) {
                ContinuableScope scope = this.scopeManager.continueSpan(this, this.spanUnderScope, this.source);
                this.spanUnderScope.finishThreadMigration();
                return scope;
            }
            return null;
        }

        public void cancel() {
            if (this.tryClose()) {
                this.trace.cancelContinuation(this);
            }
            log.debug("t_id={} -> canceling continuation {}", (Object)this.spanUnderScope.getTraceId(), (Object)this);
        }

        @Override
        public void migrate() {
        }

        @Override
        public void migrated() {
        }

        @Override
        public AgentSpan getSpan() {
            return this.spanUnderScope;
        }

        @Override
        void cancelFromContinuedScopeClose() {
            this.spanUnderScope.finishWork();
            this.cancel();
        }

        public String toString() {
            int c = COUNT.get(this);
            String s = c < -536870912 ? "CANCELED" : String.valueOf(c);
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "(" + s + ")->" + this.spanUnderScope;
        }
    }

    private static final class SingleContinuation
    extends Continuation {
        private static final AtomicIntegerFieldUpdater<SingleContinuation> USED = AtomicIntegerFieldUpdater.newUpdater(SingleContinuation.class, "used");
        private volatile int used = 0;

        private SingleContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            super(scopeManager, spanUnderScope, source);
        }

        @Override
        public AgentScope activate() {
            if (USED.compareAndSet(this, 0, 1)) {
                if (this.migrated) {
                    this.spanUnderScope.finishThreadMigration();
                }
                return this.scopeManager.continueSpan(this, this.spanUnderScope, this.source);
            }
            log.debug("Failed to activate continuation. Reusing a continuation not allowed. Spans may be reported separately.");
            return this.scopeManager.continueSpan(null, this.spanUnderScope, this.source);
        }

        public void cancel() {
            if (USED.compareAndSet(this, 0, 1)) {
                this.trace.cancelContinuation(this);
            } else {
                log.debug("Failed to close continuation {}. Already used.", (Object)this);
            }
        }

        @Override
        public void migrate() {
            this.migrated = true;
            this.spanUnderScope.startThreadMigration();
        }

        @Override
        public void migrated() {
            this.migrated = true;
        }

        @Override
        public AgentSpan getSpan() {
            return this.spanUnderScope;
        }

        @Override
        void cancelFromContinuedScopeClose() {
            this.trace.cancelContinuation(this);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "->" + this.spanUnderScope;
        }
    }

    private static abstract class Continuation
    implements AgentScope.Continuation {
        final ContinuableScopeManager scopeManager;
        final AgentSpan spanUnderScope;
        final byte source;
        final AgentTrace trace;
        protected volatile boolean migrated;

        public Continuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            this.scopeManager = scopeManager;
            this.spanUnderScope = spanUnderScope;
            this.source = source;
            this.trace = spanUnderScope.context().getTrace();
        }

        Continuation register() {
            this.trace.registerContinuation(this);
            return this;
        }

        abstract void cancelFromContinuedScopeClose();
    }

    static final class ScopeStack {
        private final ArrayDeque<ContinuableScope> stack = new ArrayDeque();
        ContinuableScope top;
        volatile ContinuableScope overdueRootScope;

        ScopeStack() {
        }

        ContinuableScope active() {
            return this.top != this.overdueRootScope ? this.top : null;
        }

        void cleanup() {
            ContinuableScope curScope = this.top;
            boolean changedTop = false;
            while (curScope != null && !curScope.alive()) {
                curScope.onProperClose();
                changedTop = true;
                curScope = this.stack.poll();
            }
            if (curScope != null && curScope == this.overdueRootScope) {
                curScope.onProperClose();
                this.overdueRootScope = null;
                this.top = null;
            } else if (changedTop) {
                this.top = curScope;
                if (curScope != null) {
                    curScope.afterActivated();
                }
            }
        }

        void push(ContinuableScope scope) {
            if (this.top != null) {
                this.stack.push(this.top);
            }
            this.top = scope;
            scope.afterActivated();
        }

        boolean checkTop(ContinuableScope expectedScope) {
            return expectedScope.equals(this.top);
        }

        final boolean checkOverdueScopes(ContinuableScope expectedScope) {
            if (this.top == null || this.top.source() != ScopeSource.ITERATION.id()) {
                return false;
            }
            this.top.clearReferences();
            this.top.span.finish();
            for (ContinuableScope scope : this.stack) {
                if (scope.source() != ScopeSource.ITERATION.id()) {
                    return expectedScope.equals(scope);
                }
                scope.clearReferences();
                scope.span.finish();
            }
            return false;
        }

        int depth() {
            return this.top != null ? 1 + this.stack.size() : 0;
        }

        void clear() {
            this.stack.clear();
            this.top = null;
        }
    }

    private static final class ContinuingScope
    extends ContinuableScope {
        private final Continuation continuation;

        ContinuingScope(ContinuableScopeManager scopeManager, AgentSpan span, byte source, boolean isAsyncPropagating, Continuation continuation) {
            super(scopeManager, span, source, isAsyncPropagating);
            this.continuation = continuation;
        }

        @Override
        public boolean checkpointed() {
            return this.continuation.migrated;
        }

        @Override
        void cleanup(ScopeStack scopeStack) {
            super.cleanup(scopeStack);
            this.continuation.cancelFromContinuedScopeClose();
        }
    }

    private static class ContinuableScope
    implements AgentScope {
        private final ContinuableScopeManager scopeManager;
        final AgentSpan span;
        private boolean isAsyncPropagating;
        private byte flags;
        private short referenceCount = 1;

        ContinuableScope(ContinuableScopeManager scopeManager, AgentSpan span, byte source, boolean isAsyncPropagating) {
            this.scopeManager = scopeManager;
            this.span = span;
            this.flags = source;
            this.isAsyncPropagating = isAsyncPropagating;
        }

        @Override
        public final void close() {
            boolean alive;
            ScopeStack scopeStack = this.scopeManager.scopeStack();
            if (!scopeStack.checkTop(this) && !scopeStack.checkOverdueScopes(this)) {
                if (log.isDebugEnabled()) {
                    log.debug("Tried to close {} scope when not on top.  Current top: {}", (Object)this, (Object)scopeStack.top);
                }
                this.scopeManager.statsDClient.incrementCounter("scope.close.error", new String[0]);
                if (this.source() == ScopeSource.MANUAL.id()) {
                    this.scopeManager.statsDClient.incrementCounter("scope.user.close.error", new String[0]);
                    if (this.scopeManager.strictMode) {
                        throw new RuntimeException("Tried to close scope when not on top");
                    }
                }
            }
            if (!(alive = this.decrementReferences())) {
                this.cleanup(scopeStack);
            }
        }

        void cleanup(ScopeStack scopeStack) {
            scopeStack.cleanup();
        }

        final void onProperClose() {
            for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
                try {
                    scopeListener.afterScopeClosed();
                }
                catch (Exception e) {
                    log.debug("ScopeListener threw exception in close()", (Throwable)e);
                }
            }
            if (!this.notifiedOnActivate()) {
                return;
            }
            for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
                try {
                    extendedScopeListener.afterScopeClosed();
                }
                catch (Exception e) {
                    log.debug("ScopeListener threw exception in close()", (Throwable)e);
                }
            }
        }

        final void incrementReferences() {
            this.referenceCount = (short)(this.referenceCount + 1);
        }

        final boolean decrementReferences() {
            this.referenceCount = (short)(this.referenceCount - 1);
            return this.referenceCount > 0;
        }

        final void clearReferences() {
            this.referenceCount = 0;
        }

        final boolean alive() {
            return this.referenceCount > 0;
        }

        public final boolean isAsyncPropagating() {
            return this.isAsyncPropagating;
        }

        @Override
        public final AgentSpan span() {
            return this.span;
        }

        @Override
        public final void setAsyncPropagation(boolean value) {
            this.isAsyncPropagating = value;
        }

        @Override
        public boolean checkpointed() {
            return false;
        }

        @Override
        public final Continuation capture() {
            return this.isAsyncPropagating ? new SingleContinuation(this.scopeManager, this.span, this.source()).register() : null;
        }

        @Override
        public final Continuation captureConcurrent() {
            return this.isAsyncPropagating ? new ConcurrentContinuation(this.scopeManager, this.span, this.source()).register() : null;
        }

        public final String toString() {
            return super.toString() + "->" + this.span;
        }

        public final void afterActivated() {
            for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
                try {
                    scopeListener.afterScopeActivated();
                }
                catch (Throwable e) {
                    log.debug("ScopeListener threw exception in afterActivated()", e);
                }
            }
            if (this.span.eligibleForDropping()) {
                return;
            }
            this.flags = (byte)(this.flags | 0x80);
            for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
                try {
                    extendedScopeListener.afterScopeActivated(this.span.getTraceId(), this.span.context().getSpanId());
                }
                catch (Throwable e) {
                    log.debug("ExtendedScopeListener threw exception in afterActivated()", e);
                }
            }
        }

        @Override
        public byte source() {
            return (byte)(this.flags & 0x7F);
        }

        private boolean notifiedOnActivate() {
            return this.flags < 0;
        }
    }
}

