/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DDId;
import datadog.trace.api.Functions;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.ForwardedTagContext;
import datadog.trace.bootstrap.instrumentation.api.TagContext;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.ForwardedExtractedContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContextInterpreter
implements AgentPropagation.KeyClassifier {
    protected final Map<String, String> taggedHeaders;
    protected DDId traceId;
    protected DDId spanId;
    protected int samplingPriority;
    protected Map<String, String> tags;
    protected Map<String, String> baggage;
    protected String origin;
    protected boolean hasForwarded;
    protected String forwarded;
    protected String forwardedProto;
    protected String forwardedHost;
    protected String forwardedIp;
    protected String forwardedPort;
    protected boolean valid;
    protected static final boolean LOG_EXTRACT_HEADER_NAMES = Config.get().isLogExtractHeaderNames();
    private static final DDCache<String, String> CACHE = DDCaches.newFixedSizeCache(64);

    protected String toLowerCase(String key) {
        return CACHE.computeIfAbsent(key, Functions.LowerCase.INSTANCE);
    }

    protected ContextInterpreter(Map<String, String> taggedHeaders) {
        this.taggedHeaders = taggedHeaders;
        this.reset();
    }

    protected final boolean handledForwarding(String key, String value) {
        if (null != value && "forwarded".equalsIgnoreCase(key)) {
            this.forwarded = value;
            this.hasForwarded = true;
            return true;
        }
        return false;
    }

    protected final boolean handledXForwarding(String key, String value) {
        if (null != value) {
            if ("x-forwarded-proto".equalsIgnoreCase(key)) {
                this.forwardedProto = value;
                this.hasForwarded = true;
                return true;
            }
            if ("x-forwarded-host".equalsIgnoreCase(key)) {
                this.forwardedHost = value;
                this.hasForwarded = true;
                return true;
            }
            if ("x-forwarded-for".equalsIgnoreCase(key)) {
                this.forwardedIp = value;
                this.hasForwarded = true;
                return true;
            }
            if ("x-forwarded-port".equalsIgnoreCase(key)) {
                this.forwardedPort = value;
                this.hasForwarded = true;
                return true;
            }
        }
        return false;
    }

    public ContextInterpreter reset() {
        this.traceId = DDId.ZERO;
        this.spanId = DDId.ZERO;
        this.samplingPriority = this.defaultSamplingPriority();
        this.origin = null;
        this.hasForwarded = false;
        this.forwarded = null;
        this.forwardedProto = null;
        this.forwardedHost = null;
        this.forwardedIp = null;
        this.forwardedPort = null;
        this.tags = Collections.emptyMap();
        this.baggage = Collections.emptyMap();
        this.valid = true;
        return this;
    }

    TagContext build() {
        if (this.valid) {
            if (!DDId.ZERO.equals((Object)this.traceId)) {
                ExtractedContext context = this.hasForwarded ? new ForwardedExtractedContext(this.traceId, this.spanId, this.samplingPriority, this.origin, this.forwarded, this.forwardedProto, this.forwardedHost, this.forwardedIp, this.forwardedPort, this.baggage, this.tags) : new ExtractedContext(this.traceId, this.spanId, this.samplingPriority, this.origin, this.baggage, this.tags);
                return context;
            }
            if (this.hasForwarded) {
                return new ForwardedTagContext(this.origin, this.forwarded, this.forwardedProto, this.forwardedHost, this.forwardedIp, this.forwardedPort, this.tags);
            }
            if (this.origin != null || !this.tags.isEmpty()) {
                return new TagContext(this.origin, this.tags);
            }
        }
        return null;
    }

    protected void invalidateContext() {
        this.valid = false;
    }

    protected int defaultSamplingPriority() {
        return -128;
    }

    public static abstract class Factory {
        public ContextInterpreter create(Map<String, String> tagsMapping) {
            return this.construct(this.cleanMapping(tagsMapping));
        }

        protected abstract ContextInterpreter construct(Map<String, String> var1);

        protected Map<String, String> cleanMapping(Map<String, String> taggedHeaders) {
            HashMap<String, String> cleanedMapping = new HashMap<String, String>(taggedHeaders.size() * 4 / 3);
            for (Map.Entry<String, String> association : taggedHeaders.entrySet()) {
                cleanedMapping.put(association.getKey().trim().toLowerCase(), association.getValue().trim().toLowerCase());
            }
            return cleanedMapping;
        }
    }
}

