/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.gateway;

import datadog.trace.api.Function;
import datadog.trace.api.function.BiFunction;
import datadog.trace.api.function.Supplier;
import datadog.trace.api.function.TriConsumer;
import datadog.trace.api.function.TriFunction;
import datadog.trace.api.gateway.EventType;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.IGSpanInfo;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.http.StoredBodySupplier;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import java.util.concurrent.atomic.AtomicInteger;

public final class Events<D> {
    private static final AtomicInteger nextId = new AtomicInteger(0);
    static final int REQUEST_STARTED_ID = 0;
    private static final EventType REQUEST_STARTED = new ET("request.started", 0);
    static final int REQUEST_ENDED_ID = 1;
    private static final EventType REQUEST_ENDED = new ET("request.ended", 1);
    static final int REQUEST_HEADER_ID = 2;
    private static final EventType REQUEST_HEADER = new ET("server.request.header", 2);
    static final int REQUEST_HEADER_DONE_ID = 3;
    private static final EventType REQUEST_HEADER_DONE = new ET("server.request.header.done", 3);
    static final int REQUEST_METHOD_URI_RAW_ID = 4;
    private static final EventType REQUEST_METHOD_URI_RAW = new ET("server.request.method.uri.raw", 4);
    static final int REQUEST_CLIENT_SOCKET_ADDRESS_ID = 5;
    private static final EventType REQUEST_CLIENT_SOCKET_ADDRESS = new ET("http.server.client_socket_address", 5);
    static final int REQUEST_BODY_START_ID = 6;
    private static final EventType REQUEST_BODY_START = new ET("request.body.started", 6);
    static final int REQUEST_BODY_DONE_ID = 7;
    private static final EventType REQUEST_BODY_DONE = new ET("request.body.done", 7);
    static final int RESPONSE_STARTED_ID = 8;
    private static final EventType RESPONSE_STARTED = new ET("response.started", 8);
    static final int MAX_EVENTS = nextId.get();
    public static final Events<Object> EVENTS = new Events();

    public EventType<Supplier<Flow<D>>> requestStarted() {
        return REQUEST_STARTED;
    }

    public EventType<BiFunction<RequestContext<D>, IGSpanInfo, Flow<Void>>> requestEnded() {
        return REQUEST_ENDED;
    }

    public EventType<TriConsumer<RequestContext<D>, String, String>> requestHeader() {
        return REQUEST_HEADER;
    }

    public EventType<Function<RequestContext<D>, Flow<Void>>> requestHeaderDone() {
        return REQUEST_HEADER_DONE;
    }

    public EventType<TriFunction<RequestContext<D>, String, URIDataAdapter, Flow<Void>>> requestMethodUriRaw() {
        return REQUEST_METHOD_URI_RAW;
    }

    public EventType<TriFunction<RequestContext<D>, String, Integer, Flow<Void>>> requestClientSocketAddress() {
        return REQUEST_CLIENT_SOCKET_ADDRESS;
    }

    public EventType<BiFunction<RequestContext<D>, StoredBodySupplier, Void>> requestBodyStart() {
        return REQUEST_BODY_START;
    }

    public EventType<BiFunction<RequestContext<D>, StoredBodySupplier, Flow<Void>>> requestBodyDone() {
        return REQUEST_BODY_DONE;
    }

    public EventType<BiFunction<RequestContext<D>, Integer, Flow<Void>>> responseStarted() {
        return RESPONSE_STARTED;
    }

    private Events() {
    }

    public static <D> Events<D> get() {
        return EVENTS;
    }

    private static final class ET<T>
    extends EventType<T> {
        public ET(String type, int id) {
            super(type, id);
            int expectedId = nextId.getAndIncrement();
            if (id != expectedId) {
                throw new IllegalArgumentException("Event " + type + " has broken id " + id + ", expected " + expectedId + ".");
            }
        }
    }
}

