/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.OTSpan;
import datadog.opentracing.TypeConverter;
import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.util.AgentTaskScheduler;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

class CustomScopeManagerWrapper
implements AgentScopeManager {
    private static final String DD_ITERATION = "_dd.iteration";
    private static final boolean CAN_GET_ACTIVE_SCOPE;
    private final ScopeManager delegate;
    private final TypeConverter converter;
    static final long iterationKeepAlive;
    volatile ConcurrentMap<Thread, IterationSpanStack> iterationSpans;

    CustomScopeManagerWrapper(ScopeManager scopeManager, TypeConverter converter) {
        this.delegate = scopeManager;
        this.converter = converter;
    }

    @Override
    public AgentScope activate(AgentSpan agentSpan, ScopeSource source) {
        OTSpan span = this.converter.toSpan(agentSpan);
        Scope scope = this.delegate.activate((Span)span);
        return this.converter.toAgentScope(span, scope);
    }

    @Override
    public AgentScope activate(AgentSpan agentSpan, ScopeSource source, boolean isAsyncPropagating) {
        OTSpan span = this.converter.toSpan(agentSpan);
        Scope scope = this.delegate.activate((Span)span);
        AgentScope agentScope = this.converter.toAgentScope(span, scope);
        agentScope.setAsyncPropagation(isAsyncPropagating);
        return agentScope;
    }

    @Override
    public AgentScope active() {
        return this.converter.toAgentScope(this.delegate.activeSpan(), CAN_GET_ACTIVE_SCOPE ? this.delegate.active() : null);
    }

    @Override
    public AgentSpan activeSpan() {
        return this.converter.toAgentSpan(this.delegate.activeSpan());
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
        try (AgentScope scope = this.activate(span, source);){
            AgentScope.Continuation continuation = scope.capture();
            return continuation;
        }
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        AgentSpan agentSpan;
        Span span = this.delegate.activeSpan();
        if (span != null && (agentSpan = this.converter.toAgentSpan(span)) != null && agentSpan.getTag(DD_ITERATION) != null) {
            if (iterationKeepAlive > 0L) {
                this.cancelIterationSpanCleanup(agentSpan);
            }
            if (CAN_GET_ACTIVE_SCOPE) {
                this.delegate.active().close();
            }
            if (finishSpan) {
                agentSpan.finishWithEndToEnd();
            }
        }
    }

    @Override
    public AgentScope activateNext(AgentSpan agentSpan) {
        agentSpan.setTag(DD_ITERATION, "true");
        OTSpan span = this.converter.toSpan(agentSpan);
        Scope scope = this.delegate.activate((Span)span);
        if (iterationKeepAlive > 0L) {
            this.scheduleIterationSpanCleanup(agentSpan);
        }
        return this.converter.toAgentScope(span, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIterationSpanCleanup(AgentSpan span) {
        IterationSpanStack spanStack;
        if (this.iterationSpans == null) {
            CustomScopeManagerWrapper customScopeManagerWrapper = this;
            synchronized (customScopeManagerWrapper) {
                if (this.iterationSpans == null) {
                    this.iterationSpans = new ConcurrentHashMap<Thread, IterationSpanStack>();
                    IterationCleaner.scheduleFor(this.iterationSpans);
                }
            }
        }
        if ((spanStack = (IterationSpanStack)this.iterationSpans.get(Thread.currentThread())) == null) {
            spanStack = new IterationSpanStack();
            this.iterationSpans.put(Thread.currentThread(), spanStack);
        }
        spanStack.trackSpan(span);
    }

    private void cancelIterationSpanCleanup(AgentSpan span) {
        IterationSpanStack spanStack;
        if (this.iterationSpans != null && (spanStack = (IterationSpanStack)this.iterationSpans.get(Thread.currentThread())) != null) {
            spanStack.untrackSpan(span);
        }
    }

    static {
        boolean canGetActiveScope;
        try {
            canGetActiveScope = ScopeManager.class.getMethod("active", new Class[0]) != null;
        }
        catch (Throwable e) {
            canGetActiveScope = false;
        }
        CAN_GET_ACTIVE_SCOPE = canGetActiveScope;
        iterationKeepAlive = TimeUnit.SECONDS.toMillis(Config.get().getScopeIterationKeepAlive());
    }

    private static final class IterationSpanStack {
        private final Deque<AgentSpan> spans = new ArrayDeque<AgentSpan>();

        private IterationSpanStack() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackSpan(AgentSpan span) {
            Deque<AgentSpan> deque = this.spans;
            synchronized (deque) {
                this.spans.push(span);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void untrackSpan(AgentSpan span) {
            Deque<AgentSpan> deque = this.spans;
            synchronized (deque) {
                this.spans.remove(span);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishOverdueSpans(long cutOff) {
            while (true) {
                AgentSpan s;
                Deque<AgentSpan> deque = this.spans;
                synchronized (deque) {
                    s = this.spans.peek();
                    if (s == null || cutOff <= TimeUnit.NANOSECONDS.toMillis(s.getStartTime())) {
                        break;
                    }
                    this.spans.poll();
                }
                s.finishThreadMigration();
                s.finishWithEndToEnd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishAllSpans() {
            Deque<AgentSpan> deque = this.spans;
            synchronized (deque) {
                for (AgentSpan s : this.spans) {
                    s.finishThreadMigration();
                    s.finishWithEndToEnd();
                }
            }
        }
    }

    private static final class IterationCleaner
    implements AgentTaskScheduler.Task<Map<Thread, IterationSpanStack>> {
        private static final IterationCleaner CLEANER = new IterationCleaner();

        private IterationCleaner() {
        }

        public static void scheduleFor(Map<Thread, IterationSpanStack> iterationSpans) {
            long period = Math.min(iterationKeepAlive, 10000L);
            AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(CLEANER, iterationSpans, iterationKeepAlive, period, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run(Map<Thread, IterationSpanStack> iterationSpans) {
            Iterator<Map.Entry<Thread, IterationSpanStack>> itr = iterationSpans.entrySet().iterator();
            long cutOff = System.currentTimeMillis() - iterationKeepAlive;
            while (itr.hasNext()) {
                Map.Entry<Thread, IterationSpanStack> entry = itr.next();
                Thread thread = entry.getKey();
                IterationSpanStack spanStack = entry.getValue();
                if (thread.isAlive()) {
                    spanStack.finishOverdueSpans(cutOff);
                    continue;
                }
                spanStack.finishAllSpans();
                itr.remove();
            }
        }
    }
}

