/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.TypeConverter;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.context.TraceScope;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import java.util.Objects;

class OTScopeManager
implements ScopeManager {
    private final TypeConverter converter;
    private final AgentTracer.TracerAPI tracer;

    OTScopeManager(AgentTracer.TracerAPI tracer, TypeConverter converter) {
        this.tracer = tracer;
        this.converter = converter;
    }

    public Scope activate(Span span) {
        return this.activate(span, false);
    }

    public Scope activate(Span span, boolean finishSpanOnClose) {
        if (null == span) {
            return null;
        }
        AgentSpan agentSpan = this.converter.toAgentSpan(span);
        AgentScope agentScope = this.tracer.activateSpan(agentSpan, ScopeSource.MANUAL);
        return this.converter.toScope(agentScope, finishSpanOnClose);
    }

    @Deprecated
    public Scope active() {
        return this.converter.toScope(this.tracer.activeScope(), false);
    }

    public Span activeSpan() {
        return this.converter.toSpan(this.tracer.activeSpan());
    }

    static class OTScope
    implements Scope,
    TraceScope {
        private final AgentScope delegate;
        private final boolean finishSpanOnClose;
        private final TypeConverter converter;

        OTScope(AgentScope delegate, boolean finishSpanOnClose, TypeConverter converter) {
            this.delegate = delegate;
            this.finishSpanOnClose = finishSpanOnClose;
            this.converter = converter;
        }

        public void close() {
            this.delegate.close();
            if (this.finishSpanOnClose) {
                this.delegate.span().finish();
            }
        }

        public Span span() {
            return this.converter.toSpan(this.delegate.span());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OTScope)) {
                return false;
            }
            OTScope otScope = (OTScope)o;
            return this.delegate.equals(otScope.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        public TraceScope.Continuation capture() {
            return this.delegate.capture();
        }

        public TraceScope.Continuation captureConcurrent() {
            return this.delegate.captureConcurrent();
        }

        public boolean isAsyncPropagating() {
            return this.delegate.isAsyncPropagating();
        }

        public void setAsyncPropagation(boolean value) {
            this.delegate.setAsyncPropagation(value);
        }

        AgentScope unwrap() {
            return this.delegate;
        }

        boolean finishSpanOnClose() {
            return this.finishSpanOnClose;
        }
    }
}

