/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Base64Encoder {
    protected static final char[] BASE_64;
    private final boolean doPadding;

    public Base64Encoder(boolean doPadding) {
        this.doPadding = doPadding;
    }

    private int outLength(int srclen) {
        int len = 0;
        if (this.doPadding) {
            len = 4 * ((srclen + 2) / 3);
        } else {
            int n = srclen % 3;
            len = 4 * (srclen / 3) + (n == 0 ? 0 : n + 1);
        }
        return len;
    }

    public byte[] encode(byte[] src) {
        int len = this.outLength(src.length);
        byte[] dst = new byte[len];
        int ret = this.encode0(src, 0, src.length, dst);
        if (ret != dst.length) {
            return Arrays.copyOf(dst, ret);
        }
        return dst;
    }

    public ByteBuffer encode(ByteBuffer buffer) {
        int len = this.outLength(buffer.remaining());
        byte[] dst = new byte[len];
        int ret = 0;
        if (buffer.hasArray()) {
            ret = this.encode0(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit(), dst);
            buffer.position(buffer.limit());
        } else {
            byte[] src = new byte[buffer.remaining()];
            buffer.get(src);
            ret = this.encode0(src, 0, src.length, dst);
        }
        if (ret != dst.length) {
            dst = Arrays.copyOf(dst, ret);
        }
        return ByteBuffer.wrap(dst);
    }

    private void encodeBlock(byte[] src, int sp, int sl, byte[] dst, int dp) {
        int sp0 = sp;
        int dp0 = dp;
        while (sp0 < sl) {
            int bits = (src[sp0++] & 0xFF) << 16 | (src[sp0++] & 0xFF) << 8 | src[sp0++] & 0xFF;
            dst[dp0++] = (byte)BASE_64[bits >>> 18 & 0x3F];
            dst[dp0++] = (byte)BASE_64[bits >>> 12 & 0x3F];
            dst[dp0++] = (byte)BASE_64[bits >>> 6 & 0x3F];
            dst[dp0++] = (byte)BASE_64[bits & 0x3F];
        }
    }

    private int encode0(byte[] src, int off, int end, byte[] dst) {
        int sp = off;
        int slen = (end - off) / 3 * 3;
        int sl = off + slen;
        int dp = 0;
        while (sp < sl) {
            int sl0 = Math.min(sp + slen, sl);
            this.encodeBlock(src, sp, sl0, dst, dp);
            int dlen = (sl0 - sp) / 3 * 4;
            dp += dlen;
            sp = sl0;
        }
        if (sp < end) {
            int b0 = src[sp++] & 0xFF;
            dst[dp++] = (byte)BASE_64[b0 >> 2];
            if (sp == end) {
                dst[dp++] = (byte)BASE_64[b0 << 4 & 0x3F];
                if (this.doPadding) {
                    dst[dp++] = 61;
                    dst[dp++] = 61;
                }
            } else {
                int b1 = src[sp++] & 0xFF;
                dst[dp++] = (byte)BASE_64[b0 << 4 & 0x3F | b1 >> 4];
                dst[dp++] = (byte)BASE_64[b1 << 2 & 0x3F];
                if (this.doPadding) {
                    dst[dp++] = 61;
                }
            }
        }
        return dp;
    }

    static {
        int c;
        BASE_64 = new char[65];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64Encoder.BASE_64[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64Encoder.BASE_64[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64Encoder.BASE_64[i++] = c;
        }
        Base64Encoder.BASE_64[i++] = 43;
        Base64Encoder.BASE_64[i] = 47;
    }
}

