/*
 * Decompiled with CFR 0.152.
 */
package datadog.communication.fleet;

import datadog.communication.ddagent.SharedCommunicationObjects;
import datadog.communication.fleet.FleetService;
import datadog.communication.http.OkHttpUtils;
import datadog.trace.util.AgentThreadFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FleetServiceImpl
implements FleetService {
    private static final Logger log = LoggerFactory.getLogger(FleetServiceImpl.class);
    private static final String CONFIG_PRODUCT_HEADER = "Datadog-Client-Config-Product";
    private static final int MAX_RESPONSE_SIZE = 0x800000;
    private final SharedCommunicationObjects sco;
    private final Thread thread;
    volatile CountDownLatch testingLatch;
    private final ConcurrentMap<FleetService.Product, FleetSubscriptionImpl> subscriptions = new ConcurrentHashMap<FleetService.Product, FleetSubscriptionImpl>();

    public FleetServiceImpl(SharedCommunicationObjects sco, AgentThreadFactory agentThreadFactory) {
        this.sco = sco;
        this.thread = agentThreadFactory.newThread(new AgentConfigPollingRunnable());
    }

    @Override
    public void init() {
        this.thread.start();
    }

    @Override
    public FleetService.FleetSubscription subscribe(FleetService.Product product, FleetService.ConfigurationListener listener) {
        FleetSubscriptionImpl sub = new FleetSubscriptionImpl(product, listener);
        this.subscriptions.put(product, sub);
        return sub;
    }

    @Override
    public void close() throws IOException {
        this.thread.interrupt();
        try {
            this.thread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted waiting for thread " + this.thread.getName() + "to join");
        }
    }

    private class FleetSubscriptionImpl
    implements FleetService.FleetSubscription {
        private final FleetService.Product product;
        private final Map<String, String> headers;
        private final FleetService.ConfigurationListener listener;
        private byte[] lastHash;

        private FleetSubscriptionImpl(FleetService.Product product, FleetService.ConfigurationListener listener) {
            this.product = product;
            this.headers = Collections.singletonMap(FleetServiceImpl.CONFIG_PRODUCT_HEADER, product.name());
            this.listener = listener;
        }

        @Override
        public void cancel() {
            FleetServiceImpl.this.subscriptions.remove((Object)this.product, this);
        }

        static /* synthetic */ byte[] access$502(FleetSubscriptionImpl x0, byte[] x1) {
            x0.lastHash = x1;
            return x1;
        }
    }

    private class AgentConfigPollingRunnable
    implements Runnable {
        private static final double BACKOFF_INITIAL = 3.0;
        private static final double BACKOFF_BASE = 3.0;
        private static final double BACKOFF_MAX_EXPONENT = 3.0;
        private int consecutiveFailures;
        private OkHttpClient okHttpClient;
        private HttpUrl httpUrl;
        private MessageDigest digest;

        AgentConfigPollingRunnable() {
            try {
                this.digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        @Override
        public void run() {
            this.okHttpClient = ((FleetServiceImpl)FleetServiceImpl.this).sco.okHttpClient;
            this.httpUrl = ((FleetServiceImpl)FleetServiceImpl.this).sco.agentUrl.newBuilder().addPathSegment("v0.6").addPathSegment("config").build();
            if (FleetServiceImpl.this.testingLatch != null) {
                FleetServiceImpl.this.testingLatch.countDown();
            }
            while (!Thread.interrupted()) {
                try {
                    boolean success = this.mainLoopIteration();
                    if (FleetServiceImpl.this.testingLatch != null) {
                        FleetServiceImpl.this.testingLatch.countDown();
                    }
                    if (success) {
                        this.successWait();
                        continue;
                    }
                    this.failureWait();
                }
                catch (InterruptedException e) {
                    log.info("Interrupted; exiting");
                    Thread.currentThread().interrupt();
                }
            }
        }

        private boolean mainLoopIteration() throws InterruptedException {
            boolean anySuccess = false;
            Collection subs = FleetServiceImpl.this.subscriptions.values();
            if (subs.isEmpty()) {
                return true;
            }
            for (FleetSubscriptionImpl sub : subs) {
                anySuccess |= this.fetchConfig(sub);
            }
            return anySuccess;
        }

        private boolean fetchConfig(FleetSubscriptionImpl sub) {
            Response response;
            Request request = OkHttpUtils.prepareRequest(this.httpUrl, sub.headers).get().build();
            try {
                response = this.okHttpClient.newCall(request).execute();
            }
            catch (IOException e) {
                log.warn("IOException on HTTP class to fleet service", (Throwable)e);
                return false;
            }
            if (response.code() == 200) {
                byte[] body;
                try {
                    body = this.consumeBody(response);
                }
                catch (IOException e) {
                    log.warn("IOException when reading fleet service response");
                    return false;
                }
                this.digest.reset();
                byte[] hash = this.digest.digest(body);
                if (Arrays.equals(hash, sub.lastHash)) {
                    return true;
                }
                FleetSubscriptionImpl.access$502(sub, hash);
                sub.listener.onNewConfiguration(new ByteArrayInputStream(body));
                return true;
            }
            log.warn("FleetService: agent responded with code " + response.code());
            return false;
        }

        private void successWait() {
            this.consecutiveFailures = 0;
            int waitSeconds = 30;
            if (FleetServiceImpl.this.testingLatch != null && FleetServiceImpl.this.testingLatch.getCount() > 0L) {
                waitSeconds = 0;
            }
            try {
                Thread.sleep((long)waitSeconds * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private void failureWait() {
            ++this.consecutiveFailures;
            double waitSeconds = 3.0 * Math.pow(3.0, Math.min((double)this.consecutiveFailures - 1.0, 3.0));
            if (FleetServiceImpl.this.testingLatch != null && FleetServiceImpl.this.testingLatch.getCount() > 0L) {
                waitSeconds = 0.0;
            }
            log.warn("Last fleet management config fetching attempt failed; will retry in {} seconds (num failures: {})", (Object)waitSeconds, (Object)this.consecutiveFailures);
            try {
                Thread.sleep((long)(waitSeconds * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private byte[] consumeBody(Response response) throws IOException {
            int read;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            InputStream inputStream = response.body().byteStream();
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) > 0) {
                os.write(buffer, 0, read);
                if (os.size() <= 0x800000) continue;
                throw new IOException("MAX_RESPONSE_SIZE exceeded");
            }
            return os.toByteArray();
        }
    }
}

