/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci.git;

import datadog.trace.bootstrap.instrumentation.ci.git.PersonInfo;
import java.util.Objects;

public class CommitInfo {
    public static final CommitInfo NOOP = new CommitInfo(null, PersonInfo.NOOP, PersonInfo.NOOP, null);
    private final String sha;
    private final PersonInfo author;
    private final PersonInfo committer;
    private final String fullMessage;

    public CommitInfo(String sha) {
        this(sha, PersonInfo.NOOP, PersonInfo.NOOP, null);
    }

    public CommitInfo(String sha, PersonInfo author, PersonInfo committer, String fullMessage) {
        this.sha = sha;
        this.author = author;
        this.committer = committer;
        this.fullMessage = fullMessage;
    }

    public String getSha() {
        return this.sha;
    }

    public PersonInfo getAuthor() {
        return this.author;
    }

    public PersonInfo getCommitter() {
        return this.committer;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitInfo that = (CommitInfo)o;
        return Objects.equals(this.sha, that.sha) && Objects.equals(this.author, that.author) && Objects.equals(this.committer, that.committer) && Objects.equals(this.fullMessage, that.fullMessage);
    }

    public int hashCode() {
        return Objects.hash(this.sha, this.author, this.committer, this.fullMessage);
    }

    public String toString() {
        return "CommitInfo{sha='" + this.sha + '\'' + ", author=" + this.author + ", committer=" + this.committer + ", fullMessage='" + this.fullMessage + '\'' + '}';
    }
}

