/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.communication.ddagent.DroppingPolicy;
import datadog.trace.common.writer.ddagent.FlushEvent;
import datadog.trace.common.writer.ddagent.PrioritizationStrategy;
import datadog.trace.core.CoreSpan;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public enum Prioritization {
    ENSURE_TRACE{

        @Override
        public PrioritizationStrategy create(Queue<Object> primary, Queue<Object> secondary, DroppingPolicy neverUsed) {
            return new EnsureTraceStrategy(primary, secondary);
        }
    }
    ,
    FAST_LANE{

        @Override
        public PrioritizationStrategy create(Queue<Object> primary, Queue<Object> secondary, DroppingPolicy droppingPolicy) {
            return new FastLaneStrategy(primary, secondary, droppingPolicy);
        }
    };


    public abstract PrioritizationStrategy create(Queue<Object> var1, Queue<Object> var2, DroppingPolicy var3);

    private static final class FastLaneStrategy
    extends PrioritizationStrategyWithFlush {
        private final Queue<Object> secondary;
        private final DroppingPolicy droppingPolicy;

        private FastLaneStrategy(Queue<Object> primary, Queue<Object> secondary, DroppingPolicy droppingPolicy) {
            super(primary);
            this.secondary = secondary;
            this.droppingPolicy = droppingPolicy;
        }

        @Override
        public <T extends CoreSpan<T>> boolean publish(T root, int priority, List<T> trace) {
            if (root.isForceKeep()) {
                return this.primary.offer(trace);
            }
            switch (priority) {
                case -1: 
                case 0: {
                    return !this.droppingPolicy.active() && this.secondary.offer(trace);
                }
            }
            return this.primary.offer(trace);
        }
    }

    private static final class EnsureTraceStrategy
    extends PrioritizationStrategyWithFlush {
        private final Queue<Object> secondary;

        private EnsureTraceStrategy(Queue<Object> primary, Queue<Object> secondary) {
            super(primary);
            this.secondary = secondary;
        }

        @Override
        public <T extends CoreSpan<T>> boolean publish(T root, int priority, List<T> trace) {
            switch (priority) {
                case -1: 
                case 0: {
                    return this.secondary.offer(trace);
                }
            }
            this.blockingOffer(this.primary, trace);
            return true;
        }
    }

    private static abstract class PrioritizationStrategyWithFlush
    implements PrioritizationStrategy {
        protected final Queue<Object> primary;

        protected PrioritizationStrategyWithFlush(Queue<Object> primary) {
            this.primary = primary;
        }

        @Override
        public boolean flush(long timeout, TimeUnit timeUnit) {
            CountDownLatch latch = new CountDownLatch(1);
            FlushEvent event = new FlushEvent(latch);
            this.blockingOffer(this.primary, event);
            try {
                return latch.await(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        protected void blockingOffer(Queue<Object> queue, Object event) {
            boolean offered;
            while (!(offered = queue.offer(event))) {
            }
        }
    }
}

