/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci.git;

import java.util.Arrays;
import java.util.Objects;

public final class GitObject {
    public static final byte UNKNOWN_TYPE = 0;
    public static final byte COMMIT_TYPE = 1;
    public static final byte TAG_TYPE = 4;
    public static final GitObject NOOP = new GitObject();
    private final byte type;
    private final int size;
    private final byte[] content;

    public GitObject() {
        this(0, 0, null);
    }

    public GitObject(byte type, int size, byte[] content) {
        this.type = type;
        this.size = size;
        this.content = content;
    }

    public byte getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getContent() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitObject gitObject = (GitObject)o;
        return this.size == gitObject.size && Objects.equals(this.type, gitObject.type) && Arrays.equals(this.content, gitObject.content);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.size);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }
}

