/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.common.container.ServerlessInfo;
import datadog.communication.ddagent.SharedCommunicationObjects;
import datadog.trace.api.Config;
import datadog.trace.api.StatsDClient;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.LoggingWriter;
import datadog.trace.common.writer.MultiWriter;
import datadog.trace.common.writer.PrintingWriter;
import datadog.trace.common.writer.TraceStructureWriter;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.Prioritization;
import datadog.trace.core.monitor.HealthMetrics;
import datadog.trace.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterFactory {
    private static final Logger log = LoggerFactory.getLogger(WriterFactory.class);

    public static Writer createWriter(Config config, SharedCommunicationObjects commObjects, Sampler sampler, StatsDClient statsDClient) {
        return WriterFactory.createWriter(config, commObjects, sampler, statsDClient, config.getWriterType());
    }

    public static Writer createWriter(Config config, SharedCommunicationObjects commObjects, Sampler sampler, StatsDClient statsDClient, String configuredType) {
        if ("LoggingWriter".equals(configuredType)) {
            return new LoggingWriter();
        }
        if ("PrintingWriter".equals(configuredType)) {
            return new PrintingWriter(System.out, true);
        }
        if (configuredType.startsWith("TraceStructureWriter")) {
            return new TraceStructureWriter(Strings.replace(configuredType, "TraceStructureWriter", ""));
        }
        if (configuredType.startsWith("MultiWriter")) {
            return new MultiWriter(config, commObjects, sampler, statsDClient, configuredType);
        }
        if (!"DDAgentWriter".equals(configuredType)) {
            log.warn("Writer type not configured correctly: Type {} not recognized. Ignoring", (Object)configuredType);
        }
        boolean alwaysFlush = false;
        if (config.isAgentConfiguredUsingDefault() && ServerlessInfo.get().isRunningInServerlessEnvironment()) {
            if (!ServerlessInfo.get().hasExtension()) {
                log.info("Detected serverless environment. Serverless extension has not been detected, using PrintingWriter");
                return new PrintingWriter(System.out, true);
            }
            log.info("Detected serverless environment. Serverless extension has been detected, using DDAgentWriter");
            alwaysFlush = true;
        }
        DDAgentApi ddAgentApi = new DDAgentApi(commObjects.okHttpClient, commObjects.agentUrl, commObjects.featuresDiscovery, commObjects.monitoring, config.isTracerMetricsEnabled());
        Prioritization prioritization = config.getEnumValue("prioritization.type", Prioritization.class, Prioritization.FAST_LANE);
        if (Prioritization.ENSURE_TRACE == prioritization) {
            log.info("Using 'EnsureTrace' prioritization type. (Do not use this type if your application is running in production mode)");
        }
        DDAgentWriter ddAgentWriter = DDAgentWriter.builder().agentApi(ddAgentApi).featureDiscovery(commObjects.featuresDiscovery).prioritization(prioritization).healthMetrics(new HealthMetrics(statsDClient)).monitoring(commObjects.monitoring).alwaysFlush(alwaysFlush).build();
        if (sampler instanceof DDAgentResponseListener) {
            ddAgentWriter.addResponseListener((DDAgentResponseListener)((Object)sampler));
        }
        return ddAgentWriter;
    }

    private WriterFactory() {
    }
}

