/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.http;

import datadog.trace.api.function.BiFunction;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.http.StoredBodySupplier;
import datadog.trace.api.http.StoredCharBody;
import datadog.trace.api.http.ThreadLocalCoders;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class StoredByteBody
implements StoredBodySupplier {
    static final Charset UTF_8 = StandardCharsets.UTF_8;
    static final Charset ISO_8859_1 = StandardCharsets.ISO_8859_1;
    private final ByteBuffer undecodedData = ByteBuffer.allocate(64);
    private final CharBuffer decodedData = CharBuffer.allocate(128);
    private CharsetDecoder charsetDecoder;
    private StoredCharBody storedCharBody;

    public StoredByteBody(RequestContext<Object> requestContext, BiFunction<RequestContext<Object>, StoredBodySupplier, Void> startCb, BiFunction<RequestContext<Object>, StoredBodySupplier, Flow<Void>> endCb, @Nullable Charset charset, int lengthHint) {
        if (charset != null) {
            this.charsetDecoder = ThreadLocalCoders.decoderFor(charset);
        }
        this.storedCharBody = new StoredCharBody(requestContext, startCb, endCb, lengthHint, this);
    }

    public synchronized void appendData(byte[] bytes, int start, int end) {
        int write;
        if (this.storedCharBody.isLimitReached()) {
            return;
        }
        for (int i = start; i < end; i += write) {
            if (!this.undecodedData.hasRemaining()) {
                this.commit(false);
            }
            write = Math.min(end - i, this.undecodedData.remaining());
            this.undecodedData.put(bytes, i, write);
        }
        this.storedCharBody.maybeNotifyStart();
    }

    public synchronized void appendData(ByteBufferWriteCallback cb, int len) {
        int i = 0;
        while (i < len) {
            if (this.storedCharBody.isLimitReached()) {
                return;
            }
            if (!this.undecodedData.hasRemaining()) {
                this.commit(false);
            }
            int left = len - i;
            int remainingInUndecoded = this.undecodedData.remaining();
            if (remainingInUndecoded > left) {
                this.undecodedData.limit(left);
                i += left;
            } else {
                i += remainingInUndecoded;
            }
            cb.put(this.undecodedData);
        }
        this.undecodedData.limit(this.undecodedData.capacity());
        this.storedCharBody.maybeNotifyStart();
    }

    public synchronized void appendData(int byteValue) {
        if (this.storedCharBody.isLimitReached()) {
            return;
        }
        if (byteValue < 0 || byteValue > 255) {
            return;
        }
        if (!this.undecodedData.hasRemaining()) {
            this.commit(false);
        }
        this.undecodedData.put((byte)byteValue);
        this.storedCharBody.maybeNotifyStart();
    }

    public synchronized void setCharset(Charset charset) {
        this.charsetDecoder = ThreadLocalCoders.decoderFor(charset);
    }

    public Flow<Void> maybeNotify() {
        this.commit(true);
        return this.storedCharBody.maybeNotify();
    }

    @Override
    public synchronized CharSequence get() {
        this.commit(false);
        return this.storedCharBody.get();
    }

    private void commit(boolean endOfInput) {
        if (this.undecodedData.position() == 0) {
            return;
        }
        if (this.charsetDecoder == null) {
            this.charsetDecoder = ThreadLocalCoders.decoderFor(UTF_8).onMalformedInput(CodingErrorAction.REPORT);
        }
        this.undecodedData.flip();
        CoderResult decode = this.charsetDecoder.decode(this.undecodedData, this.decodedData, endOfInput);
        this.decodedData.flip();
        this.storedCharBody.appendData(this.decodedData);
        this.decodedData.position(0);
        this.decodedData.limit(this.decodedData.capacity());
        this.undecodedData.compact();
        if (decode.isError()) {
            this.reencodeAsLatin1();
            this.charsetDecoder = ThreadLocalCoders.decoderFor(ISO_8859_1);
            this.commit(endOfInput);
        }
    }

    private void reencodeAsLatin1() {
        ByteBuffer utf8Encoded;
        CharBuffer curData = this.storedCharBody.get();
        CharsetEncoder encoder = ThreadLocalCoders.utf8Encoder();
        try {
            utf8Encoded = encoder.encode(curData);
        }
        catch (CharacterCodingException e) {
            throw new UndeclaredThrowableException(e);
        }
        this.storedCharBody.dropData();
        int limit = utf8Encoded.limit();
        for (int i = 0; i < limit; ++i) {
            this.storedCharBody.appendData(utf8Encoded.get(i) & 0xFF);
        }
    }

    public static interface ByteBufferWriteCallback {
        public void put(ByteBuffer var1);
    }
}

