/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.core.propagation.DatadogTags;
import datadog.trace.util.Base64Encoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatadogTagsTracking
extends DatadogTags {
    private static final Logger log = LoggerFactory.getLogger(DatadogTagsTracking.class);
    private static final Base64Encoder BASE_64_ENCODER = new Base64Encoder(false);
    private static final String UPSTREAM_SERVICES = "_dd.p.upstream_services";
    private static final DecimalFormat RATE_FORMATTER = new DecimalFormat("#.####");
    private final String rawTags;
    private volatile ServiceSamplingDecision samplingDecision;
    private static final AtomicReferenceFieldUpdater<DatadogTagsTracking, ServiceSamplingDecision> SAMPLING_DECISION_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DatadogTagsTracking.class, ServiceSamplingDecision.class, "samplingDecision");

    DatadogTagsTracking(String rawTags) {
        this.rawTags = rawTags == null ? "" : rawTags;
    }

    @Override
    public void updateUpstreamServices(String serviceName, int priority, int mechanism, double rate) {
        if (!(priority == -128 || this.samplingDecision != null && this.samplingDecision.priority == priority && this.samplingDecision.mechanism == mechanism && this.samplingDecision.rate == rate && this.samplingDecision.service.equals(serviceName))) {
            ServiceSamplingDecision newSamplingDecision = new ServiceSamplingDecision(serviceName, priority, mechanism, rate);
            SAMPLING_DECISION_UPDATER.compareAndSet(this, this.samplingDecision, newSamplingDecision);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.rawTags.isEmpty() && this.samplingDecision == null;
    }

    @Override
    public String encodeAsHeaderValue() {
        boolean isSamplingDecisionEmpty;
        boolean bl = isSamplingDecisionEmpty = this.samplingDecision == null || this.samplingDecision.isUnset();
        if (this.rawTags.isEmpty()) {
            if (isSamplingDecisionEmpty) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            this.encodeUpstreamServices(sb);
            return sb.toString();
        }
        if (isSamplingDecisionEmpty) {
            return this.rawTags;
        }
        StringBuilder sb = new StringBuilder();
        int upstreamStart = this.rawTags.indexOf(UPSTREAM_SERVICES);
        if (upstreamStart < 0) {
            sb.append(this.rawTags);
            sb.append(',');
            this.encodeUpstreamServices(sb);
            return sb.toString();
        }
        int upstreamEnd = this.rawTags.indexOf(44, upstreamStart);
        if (upstreamEnd < 0) {
            sb.append(this.rawTags);
            this.appendUpstreamServicesEncoded(sb, this.rawTags.length() - 1);
            return sb.toString();
        }
        sb.append(this.rawTags.subSequence(0, upstreamEnd));
        this.appendUpstreamServicesEncoded(sb, upstreamEnd - 1);
        sb.append(this.rawTags.subSequence(upstreamEnd, this.rawTags.length()));
        return sb.toString();
    }

    @Override
    public Map<String, String> parseAndMerge() {
        boolean nonEmptySamplingDecision;
        HashMap<String, String> result = new HashMap<String, String>();
        if (!this.rawTags.isEmpty()) {
            int startIndex = 0;
            while (startIndex < this.rawTags.length()) {
                String tagValue;
                int tagNamePosition = this.rawTags.indexOf(61, startIndex);
                if (tagNamePosition <= 0) {
                    log.warn("Malformed Datadog tags `{}` won't be sent to the backend!", (Object)this.rawTags);
                    return null;
                }
                String tagName = this.rawTags.substring(startIndex, tagNamePosition);
                startIndex = tagNamePosition + 1;
                int tagValueEnds = this.rawTags.indexOf(44, startIndex);
                if (tagValueEnds < 0) {
                    tagValueEnds = this.rawTags.length();
                }
                if (!(tagValue = this.rawTags.substring(startIndex, tagValueEnds)).isEmpty()) {
                    result.put(tagName, tagValue);
                }
                startIndex = tagValueEnds + 1;
            }
        }
        String upstreamServices = (String)result.get(UPSTREAM_SERVICES);
        StringBuilder sb = new StringBuilder();
        boolean bl = nonEmptySamplingDecision = this.samplingDecision != null;
        if (upstreamServices != null) {
            sb.append(upstreamServices);
            if (nonEmptySamplingDecision) {
                sb.append(';');
            }
        }
        if (nonEmptySamplingDecision) {
            this.samplingDecision.encode(sb);
        }
        if (sb.length() > 0) {
            result.put(UPSTREAM_SERVICES, sb.toString());
        }
        return result;
    }

    private void appendUpstreamServicesEncoded(StringBuilder sb, int lastCharIndex) {
        char lastChar = this.rawTags.charAt(lastCharIndex);
        if (lastChar != '=' && lastChar != ';') {
            sb.append(';');
        }
        this.samplingDecision.encode(sb);
    }

    private void encodeUpstreamServices(StringBuilder sb) {
        sb.append(UPSTREAM_SERVICES);
        sb.append('=');
        this.samplingDecision.encode(sb);
    }

    private static final class ServiceSamplingDecision {
        private final String service;
        private final int priority;
        private final int mechanism;
        private final double rate;

        private ServiceSamplingDecision(String service, int priority, int mechanism, double rate) {
            this.service = service;
            this.priority = priority;
            this.mechanism = mechanism;
            this.rate = rate;
        }

        public void encode(StringBuilder sb) {
            String serviceNameBase64 = new String(BASE_64_ENCODER.encode(this.service.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            sb.append(serviceNameBase64);
            sb.append('|');
            sb.append(this.priority);
            sb.append('|');
            sb.append(this.mechanism);
            if (this.rate >= 0.0) {
                sb.append('|');
                sb.append(RATE_FORMATTER.format(this.rate));
            }
        }

        public boolean isUnset() {
            return this.priority == -128;
        }
    }
}

