/*
 * Decompiled with CFR 0.152.
 */
package datadog.communication.monitor;

import com.timgroup.statsd.ServiceCheck;
import datadog.communication.monitor.DDAgentStatsDConnection;
import datadog.trace.api.Function;
import datadog.trace.api.StatsDClient;

final class DDAgentStatsDClient
implements StatsDClient {
    private final DDAgentStatsDConnection connection;
    private final Function<String, String> nameMapping;
    private final Function<String[], String[]> tagMapping;

    DDAgentStatsDClient(DDAgentStatsDConnection connection, Function<String, String> nameMapping, Function<String[], String[]> tagMapping) {
        this.connection = connection;
        this.nameMapping = nameMapping;
        this.tagMapping = tagMapping;
        connection.acquire();
    }

    @Override
    public void incrementCounter(String metricName, String ... tags) {
        this.connection.statsd.count(this.nameMapping.apply(metricName), 1L, this.tagMapping.apply(tags));
    }

    @Override
    public void count(String metricName, long value, String ... tags) {
        this.connection.statsd.count(this.nameMapping.apply(metricName), value, this.tagMapping.apply(tags));
    }

    @Override
    public void gauge(String metricName, long value, String ... tags) {
        this.connection.statsd.recordGaugeValue(this.nameMapping.apply(metricName), value, this.tagMapping.apply(tags));
    }

    @Override
    public void gauge(String metricName, double value, String ... tags) {
        this.connection.statsd.recordGaugeValue(this.nameMapping.apply(metricName), value, this.tagMapping.apply(tags));
    }

    @Override
    public void histogram(String metricName, long value, String ... tags) {
        this.connection.statsd.recordHistogramValue(this.nameMapping.apply(metricName), value, this.tagMapping.apply(tags));
    }

    @Override
    public void histogram(String metricName, double value, String ... tags) {
        this.connection.statsd.recordHistogramValue(this.nameMapping.apply(metricName), value, this.tagMapping.apply(tags));
    }

    @Override
    public void serviceCheck(String serviceCheckName, String status, String message, String ... tags) {
        ServiceCheck serviceCheck = ServiceCheck.builder().withName(this.nameMapping.apply(serviceCheckName)).withStatus(DDAgentStatsDClient.serviceCheckStatus(status)).withMessage(message).withTags(this.tagMapping.apply(tags)).build();
        this.connection.statsd.recordServiceCheckRun(serviceCheck);
    }

    static ServiceCheck.Status serviceCheckStatus(String status) {
        switch (status) {
            case "OK": {
                return ServiceCheck.Status.OK;
            }
            case "WARN": 
            case "WARNING": {
                return ServiceCheck.Status.WARNING;
            }
            case "CRITICAL": 
            case "ERROR": {
                return ServiceCheck.Status.CRITICAL;
            }
        }
        return ServiceCheck.Status.UNKNOWN;
    }

    @Override
    public void error(Exception error) {
        this.connection.handle(error);
    }

    @Override
    public int getErrorCount() {
        return this.connection.getErrorCount();
    }

    @Override
    public void close() {
        this.connection.release();
    }
}

