/*
 * Decompiled with CFR 0.152.
 */
package datadog.communication.ddagent;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.communication.ddagent.DroppingPolicy;
import datadog.communication.http.OkHttpUtils;
import datadog.communication.monitor.DDAgentStatsDClientManager;
import datadog.communication.monitor.Monitoring;
import datadog.communication.monitor.Recording;
import datadog.trace.util.Strings;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentFeaturesDiscovery
implements DroppingPolicy {
    private static final Logger log = LoggerFactory.getLogger(DDAgentFeaturesDiscovery.class);
    private static final JsonAdapter<Map<String, Object>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Object.class}));
    public static final String V3_ENDPOINT = "v0.3/traces";
    public static final String V4_ENDPOINT = "v0.4/traces";
    public static final String V5_ENDPOINT = "v0.5/traces";
    public static final String V6_METRICS_ENDPOINT = "v0.6/stats";
    public static final String DATADOG_AGENT_STATE = "Datadog-Agent-State";
    private final OkHttpClient client;
    private final HttpUrl agentBaseUrl;
    private final Recording discoveryTimer;
    private final String[] traceEndpoints;
    private final String[] metricsEndpoints = new String[]{"v0.6/stats"};
    private final boolean metricsEnabled;
    private volatile String traceEndpoint;
    private volatile String metricsEndpoint;
    private volatile boolean supportsDropping;
    private volatile String state;

    public DDAgentFeaturesDiscovery(OkHttpClient client, Monitoring monitoring, HttpUrl agentUrl, boolean enableV05Traces, boolean metricsEnabled) {
        String[] stringArray;
        this.client = client;
        this.agentBaseUrl = agentUrl;
        this.metricsEnabled = metricsEnabled;
        if (enableV05Traces) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = V5_ENDPOINT;
            stringArray2[1] = V4_ENDPOINT;
            stringArray = stringArray2;
            stringArray2[2] = V3_ENDPOINT;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = V4_ENDPOINT;
            stringArray = stringArray3;
            stringArray3[1] = V3_ENDPOINT;
        }
        this.traceEndpoints = stringArray;
        this.discoveryTimer = monitoring.newTimer("trace.agent.discovery.time");
    }

    private void reset() {
        this.traceEndpoint = null;
        this.metricsEndpoint = null;
        this.supportsDropping = false;
        this.state = null;
    }

    public void discover() {
        this.reset();
        try (Recording recording = this.discoveryTimer.start();){
            boolean fallback = true;
            try (Response response = this.client.newCall(new Request.Builder().url(this.agentBaseUrl.resolve("info").url()).build()).execute();){
                if (response.isSuccessful()) {
                    fallback = !this.processInfoResponse(response.body().string());
                }
            }
            catch (Throwable error) {
                this.errorQueryingEndpoint("info", error);
            }
            if (fallback) {
                this.supportsDropping = false;
                log.debug("Falling back to probing, client dropping will be disabled");
                this.metricsEndpoint = null;
            }
            if (null == this.traceEndpoint) {
                this.traceEndpoint = this.probeTracesEndpoint(this.traceEndpoints);
            } else if (this.state == null || this.state.isEmpty()) {
                this.probeTracesEndpoint(new String[]{this.traceEndpoint});
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("discovered traceEndpoint={}, metricsEndpoint={}, supportsDropping={}", new Object[]{this.traceEndpoint, this.metricsEndpoint, this.supportsDropping});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String probeTracesEndpoint(String[] endpoints) {
        String[] stringArray = endpoints;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            try (Response response = this.client.newCall(new Request.Builder().put(OkHttpUtils.msgpackRequestBodyOf(Collections.emptyList())).url(this.agentBaseUrl.resolve(candidate)).build()).execute();){
                if (response.code() != 404) {
                    this.state = response.header(DATADOG_AGENT_STATE);
                    String string = candidate;
                    return string;
                }
            }
            catch (IOException e) {
                this.errorQueryingEndpoint(candidate, e);
            }
            ++n2;
        }
        return V3_ENDPOINT;
    }

    private boolean processInfoResponse(String response) {
        try {
            Map map = (Map)RESPONSE_ADAPTER.fromJson(response);
            DDAgentFeaturesDiscovery.discoverStatsDPort(map);
            HashSet endpoints = new HashSet((List)map.get("endpoints"));
            String foundMetricsEndpoint = null;
            if (this.metricsEnabled) {
                for (String endpoint : this.metricsEndpoints) {
                    if (!endpoints.contains(endpoint) && !endpoints.contains("/" + endpoint)) continue;
                    foundMetricsEndpoint = endpoint;
                    break;
                }
            }
            this.metricsEndpoint = foundMetricsEndpoint;
            for (String endpoint : this.traceEndpoints) {
                if (!endpoints.contains(endpoint) && !endpoints.contains("/" + endpoint)) continue;
                this.traceEndpoint = endpoint;
                break;
            }
            if (this.metricsEnabled) {
                Object canDrop = map.get("client_drop_p0s");
                this.supportsDropping = null != canDrop && ("true".equalsIgnoreCase(String.valueOf(canDrop)) || Boolean.TRUE.equals(canDrop));
            }
            try {
                this.state = Strings.sha256(response);
            }
            catch (NoSuchAlgorithmException ex) {
                log.debug("Failed to hash trace agent /info response. Will probe {}", (Object)this.traceEndpoint, (Object)ex);
            }
            return true;
        }
        catch (Throwable error) {
            log.debug("Error parsing trace agent /info response", error);
            return false;
        }
    }

    private static void discoverStatsDPort(Map<String, Object> info) {
        try {
            Map config = (Map)info.get("config");
            int statsdPort = ((Number)config.get("statsd_port")).intValue();
            DDAgentStatsDClientManager.setDefaultStatsDPort(statsdPort);
        }
        catch (Throwable ignore) {
            log.debug("statsd_port missing from trace agent /info response", ignore);
        }
    }

    public boolean supportsMetrics() {
        return this.metricsEnabled && null != this.metricsEndpoint;
    }

    boolean supportsDropping() {
        return this.supportsDropping;
    }

    public String getMetricsEndpoint() {
        return this.metricsEndpoint;
    }

    public String getTraceEndpoint() {
        return this.traceEndpoint;
    }

    private void errorQueryingEndpoint(String endpoint, Throwable t) {
        log.debug("Error querying {} at {}", new Object[]{endpoint, this.agentBaseUrl, t});
    }

    public String state() {
        return this.state;
    }

    @Override
    public boolean active() {
        return this.supportsMetrics() && this.supportsDropping;
    }
}

