/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDId;
import datadog.trace.api.Functions;
import datadog.trace.api.TraceSegment;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.cache.RadixTreeCache;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.sampling.SamplingMechanism;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.Metadata;
import datadog.trace.core.MetadataConsumer;
import datadog.trace.core.PendingTrace;
import datadog.trace.core.taginterceptor.TagInterceptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpanContext
implements AgentSpan.Context,
RequestContext<Object>,
TraceSegment {
    private static final Logger log = LoggerFactory.getLogger(DDSpanContext.class);
    public static final String PRIORITY_SAMPLING_KEY = "_sampling_priority_v1";
    public static final String SAMPLE_RATE_KEY = "_sample_rate";
    private static final DDCache<String, UTF8BytesString> THREAD_NAMES = DDCaches.newFixedSizeCache(256);
    private static final Map<String, String> EMPTY_BAGGAGE = Collections.emptyMap();
    private final PendingTrace trace;
    private volatile Map<String, String> baggageItems;
    private final DDId traceId;
    private final DDId spanId;
    private final DDId parentId;
    private final String parentServiceName;
    private final long threadId;
    private final UTF8BytesString threadName;
    private volatile short httpStatusCode;
    private final Map<String, Object> unsafeTags;
    private volatile String serviceName;
    private volatile CharSequence resourceName;
    private volatile byte resourceNamePriority = 0;
    private volatile CharSequence operationName;
    private volatile CharSequence spanType;
    private volatile boolean errorFlag;
    private volatile boolean measured;
    private volatile boolean topLevel;
    private static final AtomicIntegerFieldUpdater<DDSpanContext> SAMPLING_DECISION_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DDSpanContext.class, "samplingDecision");
    private volatile int samplingDecision = SamplingDecision.UNSET_UNKNOWN;
    private volatile CharSequence origin;
    private final Object requestContextData;
    private final boolean disableSamplingMechanismValidation;

    public DDSpanContext(DDId traceId, DDId spanId, DDId parentId, CharSequence parentServiceName, String serviceName, CharSequence operationName, CharSequence resourceName, int samplingPriority, int samplingMechanism, CharSequence origin, Map<String, String> baggageItems, boolean errorFlag, CharSequence spanType, int tagsSize, PendingTrace trace, Object requestContextData, boolean disableSamplingMechanismValidation) {
        assert (trace != null);
        this.trace = trace;
        assert (traceId != null);
        assert (spanId != null);
        assert (parentId != null);
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.parentServiceName = String.valueOf(parentServiceName);
        this.baggageItems = baggageItems == null || baggageItems.isEmpty() ? EMPTY_BAGGAGE : new ConcurrentHashMap<String, String>(baggageItems);
        this.requestContextData = requestContextData;
        int capacity = Math.max((tagsSize <= 0 ? 3 : tagsSize + 1) * 4 / 3, 8);
        this.unsafeTags = new HashMap<String, Object>(capacity);
        this.setServiceName(serviceName);
        this.operationName = operationName;
        this.resourceName = resourceName;
        this.errorFlag = errorFlag;
        this.spanType = spanType;
        this.origin = origin;
        long samplingParams = SamplingDecision.create(samplingPriority, samplingMechanism);
        if (samplingParams != (long)SamplingDecision.UNSET_UNKNOWN) {
            this.setSamplingPriority(samplingPriority, samplingMechanism);
        }
        Thread current = Thread.currentThread();
        this.threadId = current.getId();
        this.threadName = THREAD_NAMES.computeIfAbsent(current.getName(), Functions.UTF8_ENCODE);
        this.disableSamplingMechanismValidation = disableSamplingMechanismValidation;
    }

    @Override
    public DDId getTraceId() {
        return this.traceId;
    }

    public DDId getParentId() {
        return this.parentId;
    }

    @Override
    public DDId getSpanId() {
        return this.spanId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = this.trace.getTracer().mapServiceName(serviceName);
        this.topLevel = DDSpanContext.isTopLevel(this.parentServiceName, this.serviceName);
    }

    public CharSequence getResourceName() {
        return this.isResourceNameSet() ? this.resourceName : this.operationName;
    }

    public boolean hasResourceName() {
        return this.isResourceNameSet() || this.getTag("resource.name") != null;
    }

    public byte getResourceNamePriority() {
        return this.resourceNamePriority;
    }

    public void setResourceName(CharSequence resourceName, byte priority) {
        if (priority >= this.resourceNamePriority) {
            this.resourceNamePriority = priority;
            this.resourceName = resourceName;
        }
    }

    private boolean isResourceNameSet() {
        return this.resourceName != null && this.resourceName.length() != 0;
    }

    public CharSequence getOperationName() {
        return this.operationName;
    }

    public void setOperationName(CharSequence operationName) {
        this.operationName = operationName;
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean errorFlag) {
        if (errorFlag != this.errorFlag) {
            this.errorFlag = errorFlag;
        }
    }

    public boolean isMeasured() {
        return this.measured;
    }

    public void setMeasured(boolean measured) {
        if (measured != this.measured) {
            this.measured = measured;
        }
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    private static boolean isTopLevel(String parentServiceName, String serviceName) {
        return parentServiceName == null || parentServiceName.length() == 0 || !parentServiceName.equals(serviceName);
    }

    public CharSequence getSpanType() {
        return this.spanType;
    }

    public void setSpanType(CharSequence spanType) {
        this.spanType = spanType;
    }

    public void forceKeep() {
        DDSpan rootSpan;
        if (this.trace != null && null != (rootSpan = this.trace.getRootSpan()) && rootSpan.context() != this) {
            rootSpan.context().forceKeep();
            return;
        }
        int newSamplingPriorityAndMechanism = SamplingDecision.create(2, 4);
        SAMPLING_DECISION_UPDATER.set(this, newSamplingPriorityAndMechanism);
    }

    public boolean setSamplingPriority(int newPriority, int newMechanism) {
        DDSpan rootSpan;
        if (newPriority == -128) {
            log.debug("{}: Refusing to set samplingPriority to UNSET", (Object)this);
            return false;
        }
        if (!SamplingMechanism.validateWithSamplingPriority(newMechanism, newPriority)) {
            if (this.disableSamplingMechanismValidation) {
                log.debug("{}: Bypassing setting setSamplingPriority check (trace.sampling.mechanism.validation.disabled) for a non valid combination of samplingMechanism {} and samplingPriority {}.", new Object[]{this, newMechanism, newPriority});
            } else {
                log.debug("{}: Refusing to set samplingMechanism to {}. Provided samplingPriority {} is not allowed.", new Object[]{this, newMechanism, newPriority});
                return false;
            }
        }
        if (this.trace != null && null != (rootSpan = this.trace.getRootSpan()) && rootSpan.context() != this) {
            return rootSpan.context().setSamplingPriority(newPriority, newMechanism);
        }
        int newSamplingDecision = SamplingDecision.create(newPriority, newMechanism);
        if (!SAMPLING_DECISION_UPDATER.compareAndSet(this, SamplingDecision.UNSET_UNKNOWN, newSamplingDecision)) {
            if (log.isDebugEnabled()) {
                log.debug("samplingPriority locked at priority: {} mechanism: {}. Refusing to set to priority: {} mechanism: {}", new Object[]{SamplingDecision.priority(this.samplingDecision), SamplingDecision.mechanism(this.samplingDecision), SamplingDecision.priority(newSamplingDecision), SamplingDecision.mechanism(newSamplingDecision)});
            }
            return false;
        }
        return true;
    }

    public int getSamplingPriority() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().getSamplingPriority();
        }
        return SamplingDecision.priority(this.samplingDecision);
    }

    @Deprecated
    public boolean lockSamplingPriority() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().lockSamplingPriority();
        }
        return SAMPLING_DECISION_UPDATER.get(this) != SamplingDecision.UNSET_UNKNOWN;
    }

    public CharSequence getOrigin() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan) {
            return rootSpan.context().origin;
        }
        return this.origin;
    }

    public void beginEndToEnd() {
        this.trace.beginEndToEnd();
    }

    public long getEndToEndStartTime() {
        return this.trace.getEndToEndStartTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaggageItem(String key, String value) {
        if (this.baggageItems == EMPTY_BAGGAGE) {
            DDSpanContext dDSpanContext = this;
            synchronized (dDSpanContext) {
                if (this.baggageItems == EMPTY_BAGGAGE) {
                    this.baggageItems = new ConcurrentHashMap<String, String>(4);
                }
            }
        }
        this.baggageItems.put(key, value);
    }

    public String getBaggageItem(String key) {
        return this.baggageItems.get(key);
    }

    public Map<String, String> getBaggageItems() {
        return this.baggageItems;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggageItems.entrySet();
    }

    @Override
    public PendingTrace getTrace() {
        return this.trace;
    }

    public RequestContext<Object> getRequestContext() {
        return null == this.requestContextData ? null : this;
    }

    public CoreTracer getTracer() {
        return this.trace.getTracer();
    }

    public void setHttpStatusCode(short statusCode) {
        this.httpStatusCode = statusCode;
    }

    public short getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setOrigin(CharSequence origin) {
        this.origin = origin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetric(CharSequence key, Number value) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            this.unsafeSetTag(key.toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTag(String tag, Object value) {
        if (null == value || "".equals(value)) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeTags.remove(tag);
            }
        }
        if (!this.trace.getTracer().getTagInterceptor().interceptTag(this, tag, value)) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeSetTag(tag, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAllTags(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        TagInterceptor tagInterceptor = this.trace.getTracer().getTagInterceptor();
        Map<String, Object> map2 = this.unsafeTags;
        synchronized (map2) {
            for (Map.Entry<String, ?> tag : map.entrySet()) {
                if (tagInterceptor.interceptTag(this, tag.getKey(), tag.getValue())) continue;
                this.unsafeSetTag(tag.getKey(), tag.getValue());
            }
        }
    }

    void unsafeSetTag(String tag, Object value) {
        this.unsafeTags.put(tag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getTag(String key) {
        switch (key) {
            case "thread.id": {
                return this.threadId;
            }
            case "thread.name": {
                return this.threadName.toString();
            }
            case "http.status_code": {
                return 0 == this.httpStatusCode ? null : Integer.valueOf(this.httpStatusCode);
            }
        }
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            return this.unsafeGetTag(key);
        }
    }

    public Object unsafeGetTag(String tag) {
        return this.unsafeTags.get(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            HashMap<String, Object> tags = new HashMap<String, Object>(this.unsafeTags);
            tags.put("thread.id", this.threadId);
            tags.put("thread.name", this.threadName.toString());
            if (this.samplingDecision != SamplingDecision.UNSET_UNKNOWN) {
                tags.put(SAMPLE_RATE_KEY, SamplingDecision.priority(this.samplingDecision));
            }
            if (this.httpStatusCode != 0) {
                tags.put("http.status_code", this.httpStatusCode);
            }
            return Collections.unmodifiableMap(tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTagsAndBaggage(MetadataConsumer consumer) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            consumer.accept(new Metadata(this.threadId, this.threadName, this.unsafeTags, this.baggageItems, this.samplingDecision != SamplingDecision.UNSET_UNKNOWN ? SamplingDecision.priority(this.samplingDecision) : this.getSamplingPriority(), this.measured, this.topLevel, this.httpStatusCode == 0 ? null : RadixTreeCache.HTTP_STATUSES.get(this.httpStatusCode), this.getOrigin()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder s = new StringBuilder().append("DDSpan [ t_id=").append(this.traceId).append(", s_id=").append(this.spanId).append(", p_id=").append(this.parentId).append(" ] trace=").append(this.getServiceName()).append("/").append(this.getOperationName()).append("/").append(this.getResourceName()).append(" metrics=");
        if (this.errorFlag) {
            s.append(" *errored*");
        }
        if (this.measured) {
            s.append(" *measured*");
        }
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            s.append(" tags=").append(new TreeMap<String, Object>(this.getTags()));
        }
        return s.toString();
    }

    @Override
    public Object getData() {
        return this.requestContextData;
    }

    @Override
    public TraceSegment getTraceSegment() {
        return this;
    }

    @Override
    public void setTagTop(String key, Object value) {
        this.getTopContext().setTagCurrent(key, value);
    }

    @Override
    public void setTagCurrent(String key, Object value) {
        this.setTag(key, value);
    }

    @Override
    public void setDataTop(String key, Object value) {
        this.getTopContext().setDataCurrent(key, value);
    }

    @Override
    public void setDataCurrent(String key, Object value) {
        String tagKey = "_dd." + key + ".json";
        this.setTag(tagKey, value);
    }

    private DDSpanContext getTopContext() {
        DDSpan span = this.trace.getRootSpan();
        return null != span ? span.context() : this;
    }

    protected static class SamplingDecision {
        public static final int UNSET_UNKNOWN = SamplingDecision.create(-128, -1);

        public static int create(int priority, int mechanism) {
            return priority << 16 | (byte)mechanism & 0xFFFF;
        }

        public static int priority(int samplingDecision) {
            return samplingDecision >> 16;
        }

        public static int mechanism(int samplingDecision) {
            return (byte)samplingDecision;
        }

        private SamplingDecision() {
        }
    }
}

