/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci.git;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public class PersonInfo {
    public static final PersonInfo NOOP = new PersonInfo();
    private static final String DATE_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private final String name;
    private final String email;
    private final String ISO8601Date;

    public PersonInfo() {
        this(null, null, 0L, 0);
    }

    public PersonInfo(String name, String email) {
        this(name, email, 0L, 0);
    }

    public PersonInfo(String name, String email, String iso8601date) {
        this.name = name;
        this.email = email;
        this.ISO8601Date = iso8601date;
    }

    public PersonInfo(String name, String email, long when, int tzOffset) {
        this.name = name;
        this.email = email;
        this.ISO8601Date = PersonInfo.buildISO8601Date(when);
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getISO8601Date() {
        return this.ISO8601Date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonInfo that = (PersonInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.email, that.email) && Objects.equals(this.ISO8601Date, that.ISO8601Date);
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + (this.name == null ? 0 : this.name.hashCode());
        hash = 31 * hash + (this.email == null ? 0 : this.email.hashCode());
        hash = 31 * hash + (this.ISO8601Date == null ? 0 : this.ISO8601Date.hashCode());
        return hash;
    }

    public String toString() {
        return "PersonInfo{name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", ISO8601Date='" + this.ISO8601Date + '\'' + '}';
    }

    private static String buildISO8601Date(long when) {
        if (when <= 0L) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_ISO8601);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date(when));
    }
}

