/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class DDId {
    private static final long MAX_FIRST_PART = 0x1999999999999999L;
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private DDId() {
    }

    private static int firstNonZeroCharacter(String s, int start) {
        int firstNonZero;
        for (firstNonZero = start; firstNonZero < s.length() && s.charAt(firstNonZero) == '0'; ++firstNonZero) {
        }
        return firstNonZero;
    }

    private static NumberFormatException numberFormatOutOfRange(String s) {
        return new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
    }

    static long parseUnsignedLong(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 18) {
                return Long.parseLong(s);
            }
            if (len > 20) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long first = 0L;
            int ok = 0;
            for (int i = 0; i < len - 1; ++i) {
                char c = s.charAt(i);
                int d = Character.digit(c, 10);
                ok |= d;
                first = first * 10L + (long)d;
            }
            int last = Character.digit(s.charAt(len - 1), 10);
            if ((ok |= last) < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            if (first > 0x1999999999999999L) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long guard = first * 10L;
            long result = guard + (long)last;
            if (guard < 0L && result >= 0L) {
                throw DDId.numberFormatOutOfRange(s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    static long parseUnsignedLongHex(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        return DDId.parseUnsignedLongHex(s, 0, s.length());
    }

    static long parseUnsignedLongHex(String s, int start, int len) throws NumberFormatException {
        if (len > 0) {
            if (len > 16 && len - DDId.firstNonZeroCharacter(s, start) > 16) {
                throw DDId.numberFormatOutOfRange(s);
            }
            long result = 0L;
            int ok = 0;
            int i = 0;
            while (i < len) {
                char c = s.charAt(start);
                int d = Character.digit(c, 16);
                ok |= d;
                result = result << 4 | (long)d;
                ++i;
                ++start;
            }
            if (ok < 0) {
                throw new NumberFormatException("Illegal character in " + s);
            }
            return result;
        }
        throw new NumberFormatException("Empty input string");
    }

    static String toHexStringPadded(long id, int size) {
        if (size > 16) {
            size = 32;
        } else if (size < 16) {
            size = 16;
        }
        byte[] bytes = new byte[size];
        long remaining = id;
        int nibbleCount = Long.numberOfLeadingZeros(remaining) >>> 2;
        Arrays.fill(bytes, 0, size - 16 + nibbleCount, (byte)48);
        for (int i = 0; i < 16 - nibbleCount; ++i) {
            int b = (int)(remaining & 0xFL);
            bytes[size - 1 - i] = HEX_DIGITS[b];
            remaining >>>= 4;
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

