/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.ddagent;

import datadog.trace.api.Config;
import datadog.trace.api.Platform;
import ddtrot.dd.common.container.ContainerInfo;
import ddtrot.dd.common.socket.SocketUtils;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.TracerVersion;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCommunicationObjects {
    private static final Logger log = LoggerFactory.getLogger(SharedCommunicationObjects.class);
    public OkHttpClient okHttpClient;
    public HttpUrl agentUrl;
    public Monitoring monitoring;
    private DDAgentFeaturesDiscovery featuresDiscovery;
    private Object configurationPoller;

    public void createRemaining(Config config) {
        if (this.monitoring == null) {
            this.monitoring = Monitoring.DISABLED;
        }
        if (this.agentUrl == null) {
            this.agentUrl = HttpUrl.parse(config.getAgentUrl());
        }
        if (this.okHttpClient == null) {
            String unixDomainSocket = SocketUtils.discoverApmSocket(config);
            String namedPipe = config.getAgentNamedPipe();
            this.okHttpClient = OkHttpUtils.buildHttpClient(this.agentUrl, unixDomainSocket, namedPipe, TimeUnit.SECONDS.toMillis(config.getAgentTimeout()));
        }
    }

    public Object configurationPoller(Config config) {
        if (this.configurationPoller != null) {
            return this.configurationPoller;
        }
        if (!SharedCommunicationObjects.isAtLeastJava8()) {
            return null;
        }
        try {
            this.configurationPoller = this.maybeCreatePoller(config);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Error creating remote configuration poller", (Throwable)e);
            return null;
        }
        return this.configurationPoller;
    }

    private Object maybeCreatePoller(Config config) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Supplier<String> configUrlSupplier;
        if (!config.isRemoteConfigEnabled()) {
            return null;
        }
        Class<?> confPollerCls = this.getClass().getClassLoader().loadClass("ddtrot.dd.remoteconfig.ConfigurationPoller");
        Constructor<?> constructor = confPollerCls.getConstructor(Config.class, String.class, String.class, Supplier.class, OkHttpClient.class);
        String containerId = ContainerInfo.get().getContainerId();
        String remoteConfigUrl = config.getFinalRemoteConfigUrl();
        if (remoteConfigUrl != null) {
            configUrlSupplier = new FixedConfigUrlSupplier(remoteConfigUrl);
        } else {
            this.createRemaining(config);
            configUrlSupplier = new RetryConfigUrlSupplier(this, config);
        }
        return constructor.newInstance(config, TracerVersion.TRACER_VERSION, containerId, configUrlSupplier, this.okHttpClient);
    }

    private static boolean isAtLeastJava8() {
        return Platform.isJavaVersionAtLeast(8, 0);
    }

    public void setFeaturesDiscovery(DDAgentFeaturesDiscovery featuresDiscovery) {
        this.featuresDiscovery = featuresDiscovery;
    }

    public DDAgentFeaturesDiscovery featuresDiscovery(Config config) {
        if (this.featuresDiscovery == null) {
            this.createRemaining(config);
            this.featuresDiscovery = new DDAgentFeaturesDiscovery(this.okHttpClient, this.monitoring, this.agentUrl, config.isTraceAgentV05Enabled(), config.isTracerMetricsEnabled());
            if (!"true".equalsIgnoreCase(System.getProperty("dd.test.no.early.discovery"))) {
                this.featuresDiscovery.discover();
            }
        }
        return this.featuresDiscovery;
    }

    private static final class RetryConfigUrlSupplier
    implements Supplier<String> {
        private String configUrl;
        private final SharedCommunicationObjects sco;
        private final Config config;
        private long lastTry = 0L;
        private long retryInterval = 5000L;

        private RetryConfigUrlSupplier(SharedCommunicationObjects sco, Config config) {
            this.sco = sco;
            this.config = config;
        }

        @Override
        public String get() {
            if (this.configUrl != null) {
                return this.configUrl;
            }
            long now = System.currentTimeMillis();
            long elapsed = now - this.lastTry;
            if (elapsed > this.retryInterval) {
                if (this.sco.featuresDiscovery == null) {
                    this.sco.featuresDiscovery(this.config);
                } else {
                    if (this.sco.featuresDiscovery.getConfigEndpoint() == null) {
                        this.sco.featuresDiscovery.discover();
                    }
                    this.retryInterval = 60000L;
                }
            } else {
                return null;
            }
            this.lastTry = now;
            String configEndpoint = this.sco.featuresDiscovery.getConfigEndpoint();
            if (configEndpoint == null) {
                log.debug("Remote config endpoint not found");
                return null;
            }
            this.configUrl = this.sco.featuresDiscovery.buildUrl(configEndpoint).toString();
            log.debug("Found remote config endpoint: {}", (Object)this.configUrl);
            return this.configUrl;
        }
    }

    private static final class FixedConfigUrlSupplier
    implements Supplier<String> {
        private final String configUrl;

        private FixedConfigUrlSupplier(String configUrl) {
            this.configUrl = configUrl;
        }

        @Override
        public String get() {
            return this.configUrl;
        }
    }
}

