/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import ddtrot.dd.trace.common.sampling.RateSampler;
import ddtrot.dd.trace.core.CoreSpan;
import java.util.regex.Pattern;

public abstract class SamplingRule<T extends CoreSpan<T>> {
    private final RateSampler<T> sampler;

    public SamplingRule(RateSampler<T> sampler) {
        this.sampler = sampler;
    }

    public abstract boolean matches(T var1);

    public boolean sample(T span) {
        return this.sampler.sample(span);
    }

    public RateSampler<T> getSampler() {
        return this.sampler;
    }

    public static final class TraceSamplingRule<T extends CoreSpan<T>>
    extends SamplingRule<T> {
        private final String serviceName;
        private final String operationName;

        public TraceSamplingRule(String exactServiceName, String exactOperationName, RateSampler<T> sampler) {
            super(sampler);
            this.serviceName = exactServiceName;
            this.operationName = exactOperationName;
        }

        @Override
        public boolean matches(T span) {
            return !(this.serviceName != null && !this.serviceName.equals(span.getServiceName()) || this.operationName != null && !this.operationName.contentEquals(span.getOperationName()));
        }
    }

    public static class OperationSamplingRule<T extends CoreSpan<T>>
    extends PatternMatchSamplingRule<T> {
        public OperationSamplingRule(String regex, RateSampler<T> sampler) {
            super(regex, sampler);
        }

        @Override
        protected CharSequence getRelevantString(T span) {
            return span.getOperationName();
        }
    }

    public static class ServiceSamplingRule<T extends CoreSpan<T>>
    extends PatternMatchSamplingRule<T> {
        public ServiceSamplingRule(String regex, RateSampler<T> sampler) {
            super(regex, sampler);
        }

        @Override
        protected String getRelevantString(T span) {
            return span.getServiceName();
        }
    }

    public static abstract class PatternMatchSamplingRule<T extends CoreSpan<T>>
    extends SamplingRule<T> {
        private final Pattern pattern;

        public PatternMatchSamplingRule(String regex, RateSampler<T> sampler) {
            super(sampler);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean matches(T span) {
            CharSequence relevantString = this.getRelevantString(span);
            return relevantString != null && this.pattern.matcher(relevantString).matches();
        }

        protected abstract CharSequence getRelevantString(T var1);
    }

    public static class AlwaysMatchesSamplingRule<T extends CoreSpan<T>>
    extends SamplingRule<T> {
        public AlwaysMatchesSamplingRule(RateSampler<T> sampler) {
            super(sampler);
        }

        @Override
        public boolean matches(T span) {
            return true;
        }
    }
}

